/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twitclient.TwitterUserInfo;

public class FriendshipManager {
    private ArrayList<Long> friendIDs = new ArrayList();
    private ArrayList<Long> followerIDs = new ArrayList();
    private ArrayList<TwitterUserInfo> friends = new ArrayList();
    private ArrayList<TwitterUserInfo> followers = new ArrayList();
    private static String friendshipFileName = String.valueOf(System.getProperty("user.home")) + File.separator + ".jtc" + File.separator + "friendship.xml";

    public boolean readFriendshipFromFile() {
        System.out.println("Read friendship from: " + friendshipFileName);
        File friendshipFile = new File(friendshipFileName);
        if (friendshipFile.exists()) {
            try {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(friendshipFile);
                Element root = doc.getDocumentElement();
                NodeList childNodes = root.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node n;
                    int k;
                    NodeList nl;
                    String name;
                    Node ns;
                    int j;
                    NodeList nodelist;
                    Node nodes = childNodes.item(i);
                    String nodeName = nodes.getNodeName();
                    if (nodeName.equals("friend")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            ns = nodelist.item(j);
                            name = ns.getNodeName();
                            if (name.equals("id")) {
                                nl = ns.getChildNodes();
                                k = 0;
                                while (k < nl.getLength()) {
                                    n = nl.item(k);
                                    if (n.getNodeType() == 3) {
                                        this.friendIDs.add(Long.parseLong(n.getNodeValue()));
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("follower")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            ns = nodelist.item(j);
                            name = ns.getNodeName();
                            if (name.equals("id")) {
                                nl = ns.getChildNodes();
                                k = 0;
                                while (k < nl.getLength()) {
                                    n = nl.item(k);
                                    if (n.getNodeType() == 3) {
                                        this.followerIDs.add(Long.parseLong(n.getNodeValue()));
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public void writeFriendshipToFile() {
        System.out.println("Write friendship to: " + friendshipFileName);
        File friendshipFile = new File(friendshipFileName);
        FileOutputStream out = null;
        try {
            File dir = friendshipFile.getParentFile();
            if (!dir.exists() && !dir.mkdir()) {
                System.err.println("Cannot create client directory");
                System.exit(1);
            }
            out = new FileOutputStream(friendshipFileName);
            Document doc = null;
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder bld = fac.newDocumentBuilder();
            DOMImplementation impl = bld.getDOMImplementation();
            doc = impl.createDocument("", "friendship", null);
            doc.setXmlStandalone(true);
            Element root = doc.getDocumentElement();
            Element fd = doc.createElement("friend");
            for (Long id : this.friendIDs) {
                Element idTag = doc.createElement("id");
                idTag.appendChild(doc.createTextNode(Long.toString(id)));
                fd.appendChild(idTag);
            }
            Element fl = doc.createElement("follower");
            for (Long id : this.followerIDs) {
                Element idTag = doc.createElement("id");
                idTag.appendChild(doc.createTextNode(Long.toString(id)));
                fl.appendChild(idTag);
            }
            root.appendChild(fd);
            root.appendChild(fl);
            DOMSource dsrc = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            StreamResult sr = new StreamResult(out);
            transformer.transform(dsrc, sr);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void readFriendIDs(InputStream in) {
        this.friendIDs.clear();
        this.friendIDs.addAll(this.readList(in));
    }

    public void readFollowerIDs(InputStream in) {
        this.followerIDs.clear();
        this.followerIDs.addAll(this.readList(in));
    }

    public long load(InputStream in, boolean isFriend, boolean isFollower) {
        if (isFriend) {
            return this.readFriends(in);
        }
        if (isFollower) {
            return this.readFollowers(in);
        }
        return 0L;
    }

    public long readFriends(InputStream in) {
        return this.readUserList(in, this.friends);
    }

    public long readFollowers(InputStream in) {
        return this.readUserList(in, this.followers);
    }

    private ArrayList<Long> readList(InputStream in) {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node nodes = childNodes.item(i);
                String nodeName = nodes.getNodeName();
                if (nodeName.equals("id")) {
                    NodeList nodelist = nodes.getChildNodes();
                    int j = 0;
                    while (j < nodelist.getLength()) {
                        Node n = nodelist.item(j);
                        if (n.getNodeType() == 3) {
                            list.add(Long.parseLong(n.getNodeValue()));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("During reading friendship information, we meets error.");
            System.exit(1);
        }
        return list;
    }

    private long readUserList(InputStream in, ArrayList<TwitterUserInfo> list) {
        long nextCursor = 0L;
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node nodes = childNodes.item(i);
                String nodeName = nodes.getNodeName();
                if (nodeName.equals("users")) {
                    NodeList nodelist = nodes.getChildNodes();
                    int j = 0;
                    while (j < nodelist.getLength()) {
                        Node n = nodelist.item(j);
                        if (n.getNodeName().equals("user")) {
                            TwitterUserInfo info = new TwitterUserInfo();
                            info.load(n.getChildNodes());
                            list.add(info);
                        }
                        ++j;
                    }
                } else if (nodeName.equals("next_cursor")) {
                    nextCursor = Long.parseLong(nodes.getTextContent());
                } else {
                    nodeName.equals("previous_cursor");
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("During reading friend information, we meets error.");
            System.exit(1);
        }
        return nextCursor;
    }

    public boolean isOneWayFollowing(long id) {
        return this.friendIDs.contains(id) && !this.followerIDs.contains(id);
    }

    public boolean isOneWayFollowed(long id) {
        return !this.friendIDs.contains(id) && this.followerIDs.contains(id);
    }

    public boolean isFollowingEachOther(long id) {
        return this.friendIDs.contains(id) && this.followerIDs.contains(id);
    }

    public ArrayList<Long> getFriendIDs() {
        return this.friendIDs;
    }

    public ArrayList<Long> getFollowerIDs() {
        return this.followerIDs;
    }

    public ArrayList<TwitterUserInfo> getFriends() {
        return this.friends;
    }

    public ArrayList<TwitterUserInfo> getFollowers() {
        return this.followers;
    }

    public ArrayList<String> getFriendNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (TwitterUserInfo user : this.friends) {
            result.add(user.getScreenName());
        }
        return result;
    }

    public ArrayList<String> getFollowerNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (TwitterUserInfo user : this.followers) {
            result.add(user.getScreenName());
        }
        return result;
    }
}

