/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.File;
import java.util.ArrayList;
import twitclient.TimelineFilter;
import twitclient.Tweet;

public class FilterManager {
    private ArrayList<TimelineFilter> filters = new ArrayList();

    public void loadFilters() {
        File dir = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".jtc" + File.separator + "filter");
        if (dir.exists()) {
            String[] files;
            String[] stringArray = files = dir.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                TimelineFilter filter = new TimelineFilter();
                filter.readFromFile(String.valueOf(dir.getAbsolutePath()) + File.separator + filename);
                this.filters.add(filter);
                ++n2;
            }
        } else {
            dir.mkdir();
        }
    }

    public void writeFilters() {
        for (TimelineFilter filter : this.filters) {
            filter.writeFilter();
        }
    }

    public void removeAllFilters() {
        this.filters.clear();
    }

    public void add(TimelineFilter filter) {
        this.filters.add(filter);
    }

    public TimelineFilter get(String filterName) {
        for (TimelineFilter filter : this.filters) {
            if (!filter.getName().equals(filterName)) continue;
            return filter;
        }
        return null;
    }

    public void remove(String filterName) {
        TimelineFilter remFilter = null;
        for (TimelineFilter filter : this.filters) {
            if (!filter.getName().equals(filterName)) continue;
            remFilter = filter;
            break;
        }
        if (remFilter != null) {
            remFilter.delete();
            this.filters.remove(remFilter);
        }
    }

    public void update(String originalName, String name, ArrayList<String> includeUsers, ArrayList<String> includeWords, ArrayList<String> excludeUsers, ArrayList<String> excludeWords, boolean removeFromTimeline) {
        this.get(originalName).update(name, includeUsers, includeWords, excludeUsers, excludeWords, removeFromTimeline);
    }

    public ArrayList<Tweet> getFilteredTweets(ArrayList<Tweet> tweets) {
        ArrayList<Tweet> result = new ArrayList<Tweet>();
        result.addAll(tweets);
        for (TimelineFilter filter : this.filters) {
            filter.filter(tweets);
            if (!filter.isRemoveFromTimeline()) continue;
            result.removeAll(filter.getFilteredTweet());
        }
        return result;
    }

    public ArrayList<Tweet> getTweetsInFilterFor(String name) {
        ArrayList<Tweet> result = new ArrayList<Tweet>();
        for (TimelineFilter filter : this.filters) {
            if (!filter.getName().equals(name)) continue;
            result.addAll(filter.getFilteredTweet());
            break;
        }
        return result;
    }

    public ArrayList<String> getFilterNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (TimelineFilter filter : this.filters) {
            result.add(filter.getName());
        }
        return result;
    }
}

