/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twitclient.DirectMessage;

public class DirectMessageManager {
    private ArrayList<DirectMessage> directMessages = new ArrayList();
    private long latestID = 0L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(InputStream in) {
        boolean isNotEmpty = !this.directMessages.isEmpty();
        int loadCount = 0;
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            int i = 0;
            while (true) {
                if (i >= childNodes.getLength()) {
                    return true;
                }
                Node nodes = childNodes.item(i);
                String nodeName = nodes.getNodeName();
                if (nodeName.equals("direct_message")) {
                    DirectMessage tweet = new DirectMessage();
                    if (!tweet.load(nodes.getChildNodes())) {
                        System.out.println("Faild to load direct message");
                        return false;
                    }
                    if (isNotEmpty) {
                        this.directMessages.add(loadCount, tweet);
                    } else {
                        this.directMessages.add(tweet);
                    }
                    ++loadCount;
                    this.latestID = Math.max(this.latestID, tweet.getID());
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("During reading direct messages, we meets error.");
            System.exit(1);
        }
        return true;
    }

    public boolean add(InputStream in) {
        block5: {
            boolean isNotEmpty = !this.directMessages.isEmpty();
            int loadCount = 0;
            try {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(in);
                Element root = doc.getDocumentElement();
                if (!root.getNodeName().equals("direct_message")) break block5;
                DirectMessage tweet = new DirectMessage();
                if (tweet.load(root.getChildNodes())) {
                    if (isNotEmpty) {
                        this.directMessages.add(loadCount, tweet);
                    } else {
                        this.directMessages.add(tweet);
                    }
                    ++loadCount;
                    this.latestID = Math.max(this.latestID, tweet.getID());
                    break block5;
                }
                System.out.println("Faild to load direct message");
                return false;
            }
            catch (Exception e) {
                System.err.println("During reading direct messages, we meets error.");
                System.exit(1);
            }
        }
        return true;
    }

    public void remove(long id) {
        DirectMessage remDM = null;
        for (DirectMessage dm : this.directMessages) {
            if (dm.getID() != id) continue;
            remDM = dm;
            break;
        }
        this.directMessages.remove(remDM);
        this.latestID = 0L;
        for (DirectMessage dm : this.directMessages) {
            this.latestID = Math.max(this.latestID, dm.getID());
        }
    }

    public long getLatestID() {
        return this.latestID;
    }

    public DirectMessage getDirectMessage(int index) {
        return this.directMessages.get(index);
    }

    public ArrayList<DirectMessage> getDirectMessages() {
        return this.directMessages;
    }

    public int getNumberOfDirectMessages() {
        return this.directMessages.size();
    }
}

