/*
 * Decompiled with CFR 0.152.
 */
package twitclient;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twitclient.gui.ClientMainFrame;

public class AuthenticationManager {
    private String pinCode = "";
    private String token = "";
    private String tokenSecret = "";
    private final String authFileName = String.valueOf(System.getProperty("user.home")) + File.separator + ".jtc" + File.separator + "auth.xml";

    public AuthenticationManager(ClientMainFrame frame) {
        System.out.println("Read authentication from: " + this.authFileName);
        File authFile = new File(this.authFileName);
        if (authFile.exists()) {
            try {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(authFile);
                Element root = doc.getDocumentElement();
                NodeList childNodes = root.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node node;
                    int j;
                    NodeList nodelist;
                    Node nodes = childNodes.item(i);
                    String nodeName = nodes.getNodeName();
                    if (nodeName.equals("pin-code")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.pinCode = node.getNodeValue();
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("token")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.token = node.getNodeValue();
                            }
                            ++j;
                        }
                    } else if (nodeName.equals("token-secret")) {
                        nodelist = nodes.getChildNodes();
                        j = 0;
                        while (j < nodelist.getLength()) {
                            node = nodelist.item(j);
                            if (node.getNodeType() == 3) {
                                this.tokenSecret = node.getNodeValue();
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            DefaultOAuthConsumer consumer = new DefaultOAuthConsumer("ITPVxxaBe8rxKLU6cgfJg", "3iyAaOi3NgkDAV4tWQzFVoNx1UrFkUjOgkjr7FjIfc4");
            DefaultOAuthProvider provider = new DefaultOAuthProvider("http://twitter.com/oauth/request_token", "http://twitter.com/oauth/access_token", "http://twitter.com/oauth/authorize");
            try {
                String authURL = provider.retrieveRequestToken((OAuthConsumer)consumer, "oob");
                this.pinCode = frame.getPINCode(authURL);
                System.out.println("Now visit:\n" + authURL + "\n... and grant NTR authorization");
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
            }
            catch (OAuthNotAuthorizedException e) {
                e.printStackTrace();
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
            }
            try {
                provider.retrieveAccessToken((OAuthConsumer)consumer, this.pinCode);
            }
            catch (OAuthMessageSignerException e) {
                e.printStackTrace();
                System.err.println("Cannot identify your PIN code.");
                System.err.println("Please rerun client.");
                System.exit(10);
            }
            catch (OAuthNotAuthorizedException e) {
                e.printStackTrace();
                System.err.println("Cannot identify your PIN code.");
                System.err.println("Please rerun client.");
                System.exit(10);
            }
            catch (OAuthExpectationFailedException e) {
                e.printStackTrace();
                System.err.println("Cannot identify your PIN code.");
                System.err.println("Please rerun client.");
                System.exit(10);
            }
            catch (OAuthCommunicationException e) {
                e.printStackTrace();
                System.err.println("Cannot identify your PIN code.");
                System.err.println("Please rerun client.");
                System.exit(10);
            }
            this.token = consumer.getToken();
            this.tokenSecret = consumer.getTokenSecret();
            FileOutputStream out = null;
            try {
                File dir = authFile.getParentFile();
                if (!dir.exists() && !dir.mkdir()) {
                    System.err.println("Cannot create client directory");
                    System.exit(1);
                }
                out = new FileOutputStream(this.authFileName);
                Document doc = null;
                DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
                DocumentBuilder bld = fac.newDocumentBuilder();
                DOMImplementation impl = bld.getDOMImplementation();
                doc = impl.createDocument("", "auth", null);
                doc.setXmlStandalone(true);
                Element root = doc.getDocumentElement();
                Element pin = doc.createElement("pin-code");
                pin.appendChild(doc.createTextNode(this.pinCode));
                Element tok = doc.createElement("token");
                tok.appendChild(doc.createTextNode(this.token));
                Element tokSec = doc.createElement("token-secret");
                tokSec.appendChild(doc.createTextNode(this.tokenSecret));
                root.appendChild(pin);
                root.appendChild(tok);
                root.appendChild(tokSec);
                DOMSource dsrc = new DOMSource(doc);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                StreamResult sr = new StreamResult(out);
                transformer.transform(dsrc, sr);
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        if (this.token.isEmpty() || this.tokenSecret.isEmpty()) {
            System.err.println("Authentication is failed.");
            System.exit(10);
        }
    }

    public String getPinCode() {
        return this.pinCode;
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }
}

