//////////////////////////////////////////////////////////////////////////////////////
//
//  Mahjong.cpp
//
//////////////////////////////////////////////////////////////////////////////////////

#include "Mahjong.h"
#include "Def.h"

#include "Hantei.h"

//xxx game.cppRs[
void	ErrorMessage( const char * msg )
{
	MessageBox( NULL, msg, "G[", MB_OK );
}

struct YakuNameFan
{
	BYTE		yakuID ;		// hc
	char		name[16] ;		// 𖼑O
	BYTE		fan[2] ;		// OʁCH
};

static const YakuNameFan s_YakuInfo[ 40 ] =
{	// hc                       O   H(Ȍꍇ0ɂĂ܂)
	{ YAKU_YAKUNASI,		"𖳂",		1,  0 },
	{ YAKU_LEECHI,			"[`",		1,  0 },
	{ YAKU_IPPATSU,			"ꔭ",			1,  0 },
	{ YAKU_TSUMO,			"O͘a",	1,  0 },
	{ YAKU_YAKUHAI,			"v",			1,  1 },
	{ YAKU_DORA,			"h",			1,  1 },
	{ YAKU_PINFU,			"a",			1,  0 },
//xxx H^IȂ
//	{ YAKU_TANYAO,			"fI",		1,  1 },
	{ YAKU_TANYAO,			"fI",		1,  0 },
//xxx 𓌕ɂ킹
//	{ YAKU_IPEIKO,			"t",		1,  0 },
	{ YAKU_IPEIKO,			"u",		1,  0 },
	{ YAKU_HAITEI,			"Cꝝ",		1,  1 },
	{ YAKU_HOUTEI,			"͒ꝝ",		1,  1 },
	{ YAKU_RINSHANKAIHOU,	"J",		1,  1 },
	{ YAKU_CHANKAN,			"",			1,  1 },
	{ YAKU_SANSYOKU,		"OF",		2,  1 },
	{ YAKU_IKKI,			"Cʊ",		2,  1 },
	{ YAKU_TOITOI,			"΁Xa",		2,  2 },
	{ YAKU_CHITOITSU,		"Ύq",		2,  0 },
	{ YAKU_DOUBLEE,			"_u[",		2,  0 },
	{ YAKU_CHANTA,			"S",			2,  1 },
	{ YAKU_SANANKO,			"OÍ",		2,  2 },
	{ YAKU_SANSYOKUDOUKOKU,	"OF",		2,  2 },
	{ YAKU_SANKANTSU,		"OȎq",		2,  2 },
	{ YAKU_HONITSU,			"F",		3,  2 },
	{ YAKU_JYUNCHAN,		"S",		3,  2 },
//xxx 𓌕ɂ킹
//	{ YAKU_RYANPEIKO,		"t",		3,  0 },
	{ YAKU_RYANPEIKO,		"u",		3,  0 },
//xxx O2nɂ
//	{ YAKU_SYOUSANGEN,		"O",		4,  4 },
	{ YAKU_SYOUSANGEN,		"O",		2,  2 },
	{ YAKU_HONRO,			"V",		2,  2 },
	{ YAKU_CHINITSU,		"F",		6,  5 },
	{ YAKU_KOKUSHI,			"mo",	   13,  0 },
	{ YAKU_SUANKO,			"lÍ",      13,  0 },
	{ YAKU_DAISANGEN,		"O",      13, 13 },
	{ YAKU_SYOUSUSHI,		"l",      13, 13 },
	{ YAKU_DAISUSHI,		"l",      13, 13 },
	{ YAKU_TENHO,			"Va",	       13,  0 },
	{ YAKU_CHIHO,			"na",        13,  0 },
	{ YAKU_TSUISO,			"F",      13, 13 },
	{ YAKU_RYUISO,			"ΈF",      13, 13 },
	{ YAKU_CHINROTO,		"V",      13, 13 },
	{ YAKU_CHUREN,			"A",    13, 13 },
	{ YAKU_SUKANTSU,		"lȎq",      13,  0 },
};

// eオƂ̓_e[u
static const long s_ScoreTableParent[ 13 ][ 10 ] =
{//    20   30   40   50   60   70   80   90  100  110
	{     0,  1500,  2000,  2400,  2900,  3400,  3900,  4400,  4800,  5300 },	// P
	{  2000,  2900,  3900,  4800,  5800,  6800,  7700,  8700,  9600, 11000 },	// Q
	{  3900,  5800,  7700,  9600, 11600, 12000, 12000, 12000, 12000, 12000 },	// R
	{  7700, 11600, 12000, 12000, 12000, 12000, 12000, 12000, 12000, 12000 },	// S
	{ 12000, 12000, 12000, 12000, 12000, 12000, 12000, 12000, 12000, 12000 },	// 
	{ 18000, 18000, 18000, 18000, 18000, 18000, 18000, 18000, 18000, 18000 },	// 
	{ 18000, 18000, 18000, 18000, 18000, 18000, 18000, 18000, 18000, 18000 },	
	{ 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000 },	// {
	{ 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000 },	
	{ 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000 },	
	{ 36000, 36000, 36000, 36000, 36000, 36000, 36000, 36000, 36000, 36000 },	// 3{
	{ 36000, 36000, 36000, 36000, 36000, 36000, 36000, 36000, 36000, 36000 },	
	{ 48000, 48000, 48000, 48000, 48000, 48000, 48000, 48000, 48000, 48000 }	// 
};

// qオƂ̓_e[u
static const long s_ScoreTableChild[ 13 ][ 10 ] =
{//    20   30   40   50   60   70   80   90  100  110
	{     0,  1000,  1300,  1600,  2000,  2300,  2600,  2900,  3200,  3600 },	// P
	{  1300,  2000,  2600,  3200,  3900,  4500,  3900,  5800,  6400,  7100 },	// Q
	{  2600,  3900,  5200,  6400,  7700,  8000,  8000,  8000,  8000,  8000 },	// R
	{  5200,  7700,  8000,  8000,  8000,  8000,  8000,  8000,  8000,  8000 },	// S
	{  8000,  8000,  8000,  8000,  8000,  8000,  8000,  8000,  8000,  8000 },	// 
	{ 12000, 12000, 12000, 12000, 12000, 12000, 12000, 12000, 12000, 12000 },	// 
	{ 12000, 12000, 12000, 12000, 12000, 12000, 12000, 12000, 12000, 12000 },	
	{ 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000 },	// {
	{ 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000 },
	{ 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000 },
	{ 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000 },	// 3{
	{ 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000, 24000 },	
	{ 32000, 32000, 32000, 32000, 32000, 32000, 32000, 32000, 32000, 32000 }	// 
};



BOOL	is_hai( char hai )			{ return ( ( 0  <= hai ) && ( hai < 34 ) )? TRUE : FALSE ; }
BOOL	is_suujihai( char hai )		{ return ( ( 0  <= hai ) && ( hai < 27 ) )? TRUE : FALSE ; }
BOOL	is_wanzu( char hai )		{ return ( ( 0  <= hai ) && ( hai <  9 ) )? TRUE : FALSE ; }
BOOL	is_pinzu( char hai )		{ return ( ( 9  <= hai ) && ( hai < 18 ) )? TRUE : FALSE ; }
BOOL	is_souuzu( char hai )		{ return ( ( 18 <= hai ) && ( hai < 27 ) )? TRUE : FALSE ; }
BOOL	is_jihai( char hai )		{ return ( ( 27 <= hai ) && ( hai < 34 ) )? TRUE : FALSE ; }
BOOL	is_kazehai( char hai )		{ return ( ( 27 <= hai ) && ( hai < 31 ) )? TRUE : FALSE ; }
BOOL	is_sangenhai( char hai )	{ return ( ( 31 <= hai ) && ( hai < 34 ) )? TRUE : FALSE ; }
BOOL	is_19jihai( char hai ) 
{
	if ( ( 33 < hai ) || ( hai < 0 ) )	  return FALSE ; // vȂ
	if ( 27 <= hai )					  return TRUE ;  // v
	hai %= 9 ;
	if ( ( hai == 0 ) || ( hai == 8 ) )	  return TRUE ;
	return FALSE ;
}
BOOL	is_19hai( char hai )
{
	if ( ( hai < 0 ) || ( 27 <= hai ) )	  return FALSE ; // vȂ
	hai %= 9 ;
	if ( ( hai == 0 ) || ( hai == 8 ) )	  return TRUE ;
	return FALSE ;
}
BOOL	is_yakuhai( char hai, BYTE bakaze, BYTE jikaze )
{
	if ( hai == HAI_TON + bakaze ) return TRUE ;
	if ( hai == HAI_TON + jikaze ) return TRUE ;
	return is_sangenhai( hai ) ;
}


//[  Ԃ ]
const char * GetYakuName( BYTE yaku )
{
	if ( yaku >= YAKU_MAX ) yaku = YAKU_YAKUNASI ;

	return	s_YakuInfo[ yaku ].name ;
	//return s_YakuName[ yaku ] ;
};


//[  Ԃ ]
char GetYakuFan( BYTE yaku, BOOL IsMenzen )
{
	if ( yaku >= YAKU_MAX ) yaku = YAKU_YAKUNASI ;

	if ( IsMenzen )	return s_YakuInfo[ yaku ].fan[ 0 ] ;
	else			return s_YakuInfo[ yaku ].fan[ 1 ] ;
}

//[    XRA 𓾂 ]
long GetScore( BYTE fan, BYTE fu, BOOL oya )
{
	// Pʂ20 Ȃꍇ͂O_I
	if ( fan < 1 ) return 0 ;
	if ( fu < 20 ) return 0 ;


	// ʂ͍ŒłP͂D(e[ů֌W-1)
	// 13()傫ꍇ13ĂƂŁD
	if ( fan > 13 ) fan = 13 ;
	fan-- ;

	// ͍Œł20͂D(e[ů֌W-20)
	if ( fu%10 != 0 ) fu += 10 ;
	fu	-= 20 ;	
	fu /= 10 ;
	if ( fu > 9 ) fu = 9 ;

	switch ( oya )
	{
	case TRUE  :	return s_ScoreTableParent[ fan ][ fu ] ;
	case FALSE :	return s_ScoreTableChild [ fan ][ fu ] ;
	}

	return 0 ;
}




//////////////////////////////////////////////////////////////////////////////////////
//
//	Mahjong NX
//
//////////////////////////////////////////////////////////////////////////////////////


char Mahjong::s_DoraIndicator[ DORA_MAX ] ;

//====================================================================================
//
//	RXgN^
//
//====================================================================================
Mahjong ::Mahjong()
{

}


//====================================================================================
//
//	fXgN^
//
//====================================================================================
Mahjong ::~Mahjong()
{

}


//====================================================================================
//
//	
//
//====================================================================================
BOOL	Mahjong ::Init()
{
	// `FbN
	for (int i=0 ; i < YAKU_MAX -1  ; ++i )
	{
		if ( s_YakuInfo[ i ].yakuID != i )
		{
			::ErrorMessage( "IDƖ񂪈vĂ܂" );
			return FALSE ;
		}
	}


	YHM_SetBakaze( KAZE_TON ) ;
	SetWangpaiNum( 14 ) ;


	Shipai() ;

	return TRUE ;
}


//====================================================================================
//
//	v
//
//====================================================================================
void	Mahjong::Shipai()
{
	m_Tehai.Reset() ;
	
	m_IsHaitei	= FALSE ;
	m_IsChankan	= FALSE ;
	m_IsRinshan	= FALSE ;

	int i ;

	// Rv̂Zbg
	m_YamahaiNum = 136 ;
	for ( i=0 ; i < 34 ; ++i )
	{
		m_Yama[ i ] = 4 ;
	}

	// h\ṽZbg
	for ( i=0 ; i < DORA_MAX ; ++i )
	{
		Mahjong::s_DoraIndicator[ i ] = -1 ;
	}
}


//====================================================================================
//
//	vRPv𓾂܂
//
//	[߂l]
//	-1		: vRɂ͔vcĂ܂D
//	̑	: vRĂvłD
//
//====================================================================================
char	Mahjong::GetHaiFromYama()
{
	if ( NokoriNum() == 0 )
	{
		ErrorMessage( "Mahjong::GetHaiFromYama : vRɂ͉vcĂ܂" ) ;
		return -1 ;
	}


	const BYTE hai_kouho_begin = rand()%34 ;

	for (int i=0 ; i < 34 ; ++i )
	{
		BYTE hai = hai_kouho_begin + i ;
		if ( hai >= 34 ) hai -= 34 ;

		if ( m_Yama[ hai ] > 0 )
		{
			m_Yama[ hai ]-- ;
			m_YamahaiNum -- ;
			return hai ;
		}
	}

	return -1 ;
}

//------------------------------------------------------------------------------------
//
//	vRCӂ̔v𓾂܂
//
//	[߂l]
//	TRUE	: 
//	FALSE	: v
//------------------------------------------------------------------------------------
BOOL	Mahjong::GetHaiFromYama( char hai )
{
	if ( ! is_hai( hai ) ) return FALSE ;

	if ( NokoriNum() == 0 )
	{
		ErrorMessage( "Mahjong::GetHaiFromYama : vRɂ͉vcĂ܂" ) ;
		return FALSE ;
	}

	if ( m_Yama[ hai ] == 0 ) return FALSE ;

	m_Yama[ hai ]-- ;
	m_YamahaiNum-- ;

	return TRUE ;
}












//////////////////////////////////////////////////////////////////////////////////////
//
//	ȉC𔻒胂[hp
//
//////////////////////////////////////////////////////////////////////////////////////


//====================================================================================
//
//	v(𔻒胂[hp)
//
//====================================================================================
void	Mahjong::YHM_Leepai()
{
	const int tehai_num	= m_Tehai.tehai_num ;
	char	tmp ;

	//Ȃou\[głD
	for (int j=0 ; j < m_Tehai.tehai_num-1 ; ++j )
	{
		for (int k=j+1 ; k < m_Tehai.tehai_num ; ++k )
		{
			if ( m_Tehai.tehai[ j ] > m_Tehai.tehai[ k ] )
			{
				tmp = m_Tehai.tehai[ k ] ;
				m_Tehai.tehai[ k ] = m_Tehai.tehai[ j ] ;
				m_Tehai.tehai[ j ] = tmp ;
			}
		}
	}
}

//====================================================================================
//
//	c(𔻒胂[hp)
//
//====================================================================================
BOOL	Mahjong ::YHM_Tsumo( char hai )
{
	if ( ! is_hai( hai ) ) return FALSE ;

	if ( m_Yama[ hai ] <= 0 ) return FALSE ;	// vD

	// vɗ]Tꍇ
	if ( m_Tehai.tehai_num + m_Tehai.NakihaiNum()*3  <=  12 )
	{
		if ( m_Tehai.HasTsumohai() )	// cvꍇ́CcvvɈڂD
		{
			m_Tehai.tehai[ m_Tehai.tehai_num ] = m_Tehai.Tsumohai() ;
			m_Tehai.tehai_num ++ ;
		}

		m_Tehai.SetTsumohai( hai ) ;
		m_Yama[ hai ] -- ;

		return TRUE ;
	}
	// vɗ]Tꍇcvւ
	else
	{
		if ( m_Tehai.HasTsumohai() )
		{
			return YHM_Nurikae( hai, 13 ) ;
		}
		else
		{
			m_Tehai.SetTsumohai( hai ) ;
			m_Yama[ hai ] -- ;
			return TRUE ;
		}
	}

	return FALSE ;
}


//====================================================================================
//
//	vhւ(𔻒胂[hp)
//
//	[]
//	hai			:	hւv
//	tehai_index	:	0`12:vC13:cv
//	
//====================================================================================
BOOL	Mahjong ::YHM_Nurikae( char hai, BYTE tehai_index )
{
	if ( ! is_hai( hai ) ) return FALSE ;
	if ( m_Yama[ hai ] <= 0 ) return FALSE ;

	// hւΏۂcv
	if ( tehai_index == 13 )
	{
		if ( ! m_Tehai.HasTsumohai() ) return FALSE ;
	}
	// hւΏۂv
	else //if ( m_Tehai.HasTsumohai() )
	{
		if ( ( tehai_index < 0 ) || ( tehai_index >= m_Tehai.tehai_num-1 ) ) return FALSE ;
	}

	
	// ܂ŗ΁Cp^I
	m_Yama[ m_Tehai.tehai[ tehai_index ] ]++ ;
	m_Yama[ hai ]-- ;
	m_Tehai.tehai[ tehai_index ] = hai ;

	return TRUE ;
	
}



//====================================================================================
//
//	`[(𔻒胂[hp)
//
//====================================================================================
BOOL	Mahjong ::YHM_MakeChi( char hai )
{
	if ( ! is_hai( hai ) )			return FALSE ;
	if ( m_Tehai.NakihaiNum() >= 4 ) return FALSE ;
	
	if ( m_Tehai.tehai_num + m_Tehai.NakihaiNum()*3 >= 13 - 3 ) return FALSE ;

	// ܂łΎvIɂ̓`[ł邼
	
	// `[̐擪ɂȂ肤邩H
	if ( is_jihai( hai ) ) return FALSE ;
	if ( ( HAI_8WAN == hai ) || ( HAI_9WAN == hai ) ) return FALSE ;
	if ( ( HAI_8PIN == hai ) || ( HAI_9PIN == hai ) ) return FALSE ;
	if ( ( HAI_8SOU == hai ) || ( HAI_9SOU == hai ) ) return FALSE ;

	// RɃ`[ł邾̔vcĂ邩D
	if ( ( m_Yama[ hai + 0 ] <= 0 ) ||
		 ( m_Yama[ hai + 1 ] <= 0 ) ||
		 ( m_Yama[ hai + 2 ] <= 0 ) )
	{
		return FALSE ;
	}

	// RR܂ł΂ƃ`[ł邼[I
	m_Yama[ hai + 0 ] -- ;
	m_Yama[ hai + 1 ] -- ;
	m_Yama[ hai + 2 ] -- ;

	m_Tehai.AddChi( hai ) ;

	return TRUE ;
}

//====================================================================================
//
//	|(𔻒胂[hp)
//
//====================================================================================
BOOL	Mahjong ::YHM_MakePon( char hai )
{
	if ( ! is_hai( hai ) )			return FALSE ;
	if ( m_Tehai.NakihaiNum() >= 4 ) return FALSE ;
	
	if ( m_Tehai.tehai_num + m_Tehai.NakihaiNum()*3 >= 13 - 3 ) return FALSE ;

	// ܂łΎvIɂ̓|ł邼

	// R̒ɂ̓|ł邾̔vcĂ邩ȁH
	if ( m_Yama[ hai ] < 3 ) return FALSE ;

	// ܂ł΃|ł邼[I
	m_Yama[ hai ] -= 3 ;

	m_Tehai.AddPon( hai ) ;

	return TRUE ;

}


//====================================================================================
//
//	Ȃ(𔻒胂[hp)
//
//====================================================================================
BOOL	Mahjong::YHM_MakeMinkan( char hai )
{
	if ( ! is_hai( hai ) )			return FALSE ;
	if ( m_Tehai.NakihaiNum() >= 4 ) return FALSE ;
	
	if ( m_Tehai.tehai_num + m_Tehai.NakihaiNum()*3 >= 13 - 3 ) return FALSE ;

	// ܂łΎvIɂ͖Ȃł邼

	// R̒ɂ͖Ȃł邾̔v̂Ă邩ȁH
	if ( m_Yama[ hai ] < 4 ) return FALSE ;

	// ܂łΖȂł邼I
	m_Yama[ hai ] -= 4 ;

	m_Tehai.AddAnkan( hai ) ;

	return TRUE ;
}

//====================================================================================
//
//	ÞȂ(𔻒胂[hp)
//
//====================================================================================
BOOL	Mahjong::YHM_MakeAnkan( char hai )
{
	if ( ! is_hai( hai ) )			return FALSE ;
	if ( m_Tehai.NakihaiNum() >= 4 ) return FALSE ;
	
	if ( m_Tehai.tehai_num + m_Tehai.NakihaiNum()*3 >= 13 - 3 ) return FALSE ;

	// ܂łΎvIɂ͈ÞȂł邼

	// R̒ɂ͈ÞȂł邾̔v̂Ă邩ȁH
	if ( m_Yama[ hai ] < 4 ) return FALSE ;

	// ܂łΈÞȂł邼I
	m_Yama[ hai ] -= 4 ;

	m_Tehai.AddAnkan( hai ) ;

	return TRUE ;

}


//====================================================================================
//
//	h\vZbgD(𔻒胂[hp)
//
//====================================================================================
BOOL	Mahjong ::YHM_SetDoraIndicator( int index, char hai )
{
	if ( index < 0  ||  index >= DORA_MAX ) return FALSE ;

	// w肳ꂽh\v LvȂCRɖ߂D
	if ( is_hai( Mahjong::s_DoraIndicator[ index ] ) )
	{
		m_Yama[ Mahjong::s_DoraIndicator[ index ] ] ++ ;
	}

	// vݒ肷D
	if ( ! is_hai( hai ) )
	{
		Mahjong::s_DoraIndicator[ index ] = -1 ;
	}
	// Lvݒ肷D
	// vRɔvcĂȂꍇ́CD
	else
	{
		if ( m_Yama[ hai ] <= 0 ) return FALSE ;

		m_Yama[ hai ] -- ;
		Mahjong::s_DoraIndicator[ index ] = hai ;
	}

	return TRUE ;
}





//====================================================================================
//
//	𔻒(𔻒胂[hp)
//
//	قǂǖ̃CˁD
//	œKقƂǂĂȂ̂ŁCʑȁD
//	[I
//
//====================================================================================
BOOL	Mahjong ::YHM_YakuHantei( BOOL is_ron )
{
	Hantei::SetBakaze( YHM_Bakaze() ) ;

	if ( Hantei::YakuHantei( m_Tehai, is_ron, YHM_IsHaitei(), YHM_IsRinshan(), YHM_IsChankan() ) )
	{
		m_Yaku	= Hantei::GetYakuData() ;
		return TRUE ;
	}

	return FALSE ;

}









//////////////////////////////////////////////////////////////////////////////////////
//  EOF : Mahjong.cpp
//////////////////////////////////////////////////////////////////////////////////////
