//////////////////////////////////////////////////////////////////////////////////////
//
//  Hantei.h
//
//////////////////////////////////////////////////////////////////////////////////////
#ifndef _HANTEI_H_
#define _HANTEI_H_

#include "Def.h"
#include "Mahjong.h"

//////////////////////////////////////////////////////////////////////////////////////
//	
//	HaiteNX
//
//	ɖ𔻒sNXłD
//	قƂǂX^eBbNĝŁĈ͍܂D
//
//////////////////////////////////////////////////////////////////////////////////////
class Hantei
{
private :
	Hantei() {}				// ͍̂点ˁ[
	virtual ~Hantei() {}

public :
	static void SetBakaze( BYTE kaze ) ;
	static BYTE Bakaze() { return Hantei::s_Bakaze ; }

	static BOOL	YakuHantei( const TehaiData & tehai, BOOL is_ron, BOOL is_haitei=FALSE, BOOL is_rinshan=FALSE, BOOL is_chankan=FALSE ) ;
	static YakuData & GetYakuData() { return Hantei::s_Yaku ; }
//	static void	CopyYakuData( YakuData * pYaku ) { *pYaku = Hantei::s_Yaku ; }

	static void	MakeHistogram( char * pHist, const TehaiData & tehai ) ;

	static void SumYakuFan	( YakuData * pYaku ) ;
	static void CalcFu		( YakuData * pYaku ) ;
	static long	CalcScoreFromYakuData( const YakuData & yaku ) ;

	//[ AK`ɂȂĂ邩ǂ𒲂ׂ邾iSɒׂ荂j]
	static BOOL FastCheckAgariForm( const TehaiData & tehai ) ;

	//[ ߂ ]
	static int CalcShantenValue( const TehaiData & tehai ) ;


protected :	// YakuHantei ̃Tu[`

	// moCΎqC1Sʎq ^CvƂɖ𔻒肷D
	static BOOL	KokushiHanteiRoutine( YakuList * pYakuList, const TehaiData & tehai, BOOL is_ron );
	static BOOL ChitoiHanteiRoutine ( YakuList * pYakuList, const TehaiData & tehai, BOOL is_ron );
	static BOOL NormalHanteiRoutine ( YakuList * pYakuList, const TehaiData & tehai, BOOL is_ron );
	static void	AddAgariForm_ShuntsuMain( AgariList * pAgariList, const TehaiData & tehai ) ;
	static void AddAgariForm_KotsuMain	( AgariList * pAgariList, const TehaiData & tehai ) ;
	static void SearchAndAddYaku( YakuData * pYaku, const TehaiData & tehai,
								  BOOL is_haitei, BOOL is_rinshan, BOOL is_chankan ) ;

protected :
	// uAKv̌`ɂȂĂ邩ǂ̍`FbND
	static BOOL FastCheckNormalForm_ShuntsuMain	( const TehaiData & tehai ) ;
	static BOOL	FastCheckNormalForm_KotsuMain	( const TehaiData & tehai ) ;

	// u҂vXgǉD
	static void MakeMachiList( MachiList * pMachiList, const AgariForm & agari_form, const char agari_hai ) ;
	static void RemoveOverlappedMachi( MachiList * pMachiList );


protected :	// Ƃɖ邩ǂ̃`FbN

	static BOOL	CheckKokushi	( const TehaiData & tehai ) ;
	static BOOL CheckChitoitsu	( const TehaiData & tehai ) ;
	static BOOL CheckTanyao		( const TehaiData & tehai ) ;
	static BOOL CheckHonro		( const TehaiData & tehai, const YakuData & yaku, BOOL chitoi ) ;
	static BOOL CheckHonitsu	( const TehaiData & tehai, const YakuData & yaku, BOOL chitoi ) ;
	static BOOL	CheckTsuiso		( const TehaiData & tehai, const YakuData & yaku, BOOL chitoi ) ;

	static BYTE CountDora		( const TehaiData & tehai, const char * pDoraIndicator ) ;
	static BYTE CountYakuhai	( const YakuData & yaku ) ;
	static BOOL CheckPinfu		( const YakuData & yaku ) ;
	static BOOL	CheckSankantsu	( const YakuData & yaku ) ;
	static BOOL	CheckSukantsu	( const YakuData & yaku ) ;
	static BOOL	CheckShousangen	( const YakuData & yaku ) ;
	static BOOL	CheckDaisangen	( const YakuData & yaku ) ;
	static BOOL	CheckShousushi	( const YakuData & yaku ) ;
	static BOOL CheckDaisushi	( const YakuData & yaku ) ;
	static BOOL	CheckIpeiko		( const YakuData & yaku ) ;
	static BOOL	CheckRyanpeiko	( const YakuData & yaku ) ;
	static BOOL	CheckRyuiso		( const YakuData & yaku ) ;
	static BOOL	CheckChinroto	( const YakuData & yaku ) ;
	static BOOL CheckChinitsu	( const YakuData & yaku ) ;
	static BOOL CheckChuren		( const YakuData & yaku ) ;
	static BOOL	CheckSansyoku	( const YakuData & yaku ) ;
	static BOOL	CheckSansyokuDoukoku	( const YakuData & yaku ) ;
	static BOOL CheckChanta		( const YakuData & yaku ) ;
	static BOOL	CheckJyunchan	( const YakuData & yaku ) ;
	static BOOL	CheckSananko	( const YakuData & yaku ) ;
	static BOOL	CheckSuanko		( const YakuData & yaku ) ;
	static BOOL	CheckIkki		( const YakuData & yaku ) ;
	static BOOL	CheckToitoi		( const YakuData & yaku ) ;
	
protected :
	static BYTE s_Bakaze ;		// ꕗ͖𔻒̂߂ɕKv
	static YakuData	s_Yaku ;	// ̖f[^
};


#endif
//////////////////////////////////////////////////////////////////////////////////////
//  EOF : Hantei.h
//////////////////////////////////////////////////////////////////////////////////////