//V~[^

#include "stdafx.h"
#include "Mahjong.h"
#include "Hantei.h"
#include "MJSim.h"

class CMJTaku : public MJTAKU{
public:
	int Yama[137];//0`3:Vv
					//4`7:\h\v
					//8`11:h\v
					//12`13:gpȂv
					//14`:cv(ŏ13~4v͔zv)
					//136:ԕB0
	int *Tsumo;	//R̃cʒu
	//pĂf[^
	//int Kyoku;	//ǁB0:1A1:2 ` 4:1 `
	//int TsumiboNum;	//ςݖ_̐
	//int RichiboNum;	//[`_̐
	//int Dora[4];	//hvBAIł̂ݎQ
	//int RestTsumoNum;	//cc AIł̂ݎQ
	//int Turn;	//N̏ԂB0:NƁ`
	//MJPLAYER Player[4];	//vC[̃f[^

	int GetZikaze(int Index){return (Index + 4 - (Kyoku % 4)) % 4;}
	int GetRestTsumo();
	int GetKawaLen(int Index);
	int GetKanNum();
	int GetDora(int Index);
	int GetDoraNum(){return GetKanNum() + 1;}
	int GetFuroNum(int Index);
	bool IsMenzen(int Index);
	int GetLastSutehai(){return Player[Turn].Kawa[GetKawaLen(Turn) - 1];}
	void SetFuroSutehai(){Player[Turn].Kawa[GetKawaLen(Turn) - 1] *= -1;}
};
int CMJTaku::GetRestTsumo()
{
	for(int i = 0; *(Tsumo + i) != 0; i++);
	return i;
}
int CMJTaku::GetKawaLen(int Index)
{
	for(int i = 0; Player[Index].Kawa[i] != 0; i++);
	return i;
}
int CMJTaku::GetKanNum()
{
	int k = 0;
	for(int i = 0; i < 4; i++){
		for(int j = 0; j < 4; j++){
			switch(Player[i].Furo[j].Type){
			case MJFORO_ANKAN:case MJFORO_MINKAN:k++;
			}
		}
	}
	return k;
}
//h擾(\vł͂Ȃ)
int CMJTaku::GetDora(int Index)
{
	int DoraFilter[] = {	0, 2, 3, 4, 5, 6, 7, 8, 9, 1,
							0,12,13,14,15,16,17,18,19,11,
							0,22,23,24,25,26,27,28,29,21,
							0,33, 0,35, 0,37, 0,31, 0, 0,
							0,43, 0,45, 0,41};
	return DoraFilter[Yama[4 + Index]];
}
//ʑOǂׂ
bool CMJTaku::IsMenzen(int Index)
{
	int j = 0;
	for(int i = 0; i < 4; i++){
		if(Player[Index].Furo[i].Type == MJFURO_NULL){break;}
		if(Player[Index].Furo[i].Type != MJFORO_ANKAN){j++;}//ÃJȊOJEg
	}
	return j == 0 ? true : false;
}
//t[擾
int CMJTaku::GetFuroNum(int Index)
{
	for(int i = 0; i < 4; i++){
		if(Player[Index].Furo[i].Type == MJFURO_NULL){break;}
	}
	return i;
}
//̎
int GetSeed()
{
	GUID guid;
	CoCreateGuid(&guid);
	int seed = guid.Data1 + guid.Data2 + guid.Data3;
	for(int i = 0; i < 8; i++){seed += guid.Data4[i];}
	return seed;
}
//オ_vZNX
//MahjongNXg
class CMJAgari{
	Mahjong m_MJ;
	bool m_IsRon;
	int m_Index;
public:
	CMJTaku *m_Taku;
private:
	void ConvertTehai(int Index, bool IsRon);
public:
	bool Calc(int Index, bool IsRon);	//vZs
	int Fu(){return (int)m_MJ.m_Yaku.fu;}
	int Han(){return (int)m_MJ.m_Yaku.fan;}
	int Score(){return (int)m_MJ.m_Yaku.score;}
	int YakuNum(){return m_MJ.m_Yaku.YakuNum();}
	string YakuName(int Index){return ::GetYakuName(m_MJ.m_Yaku.GetYaku(Index));}
	bool IsRon(){return m_IsRon;}
	int GetIndex(){return m_Index;}
	int GetShanten(int Index);	//Ve擾
};
bool CMJAgari::Calc(int Index, bool IsRon)
{
	m_IsRon = IsRon;
	m_Index = Index;
	ConvertTehai(Index, IsRon);
	return (m_MJ.YHM_YakuHantei(IsRon) && Han() > 0) ? true : false;	//_vZs
}
void CMJAgari::ConvertTehai(int Index, bool IsRon)
{
	MJPLAYER *Player = &m_Taku->Player[Index];

	m_MJ.Init();	//
	m_MJ.m_Tehai.Reset();
	
	m_MJ.m_Tehai.is_menzen = m_Taku->IsMenzen(Index) ? TRUE : FALSE;
	m_MJ.m_Tehai.is_ron = IsRon;
	m_MJ.m_Tehai.jikaze = m_Taku->GetZikaze(Index);

	//v̕ϊ
	int ConvertHai[] = {
		0,0,1,2,3,4,5,6,7,8,
		0,9,10,11,12,13,14,15,16,17,
		0,18,19,20,21,22,23,24,25,26,
		0,27,0,28,0,29,0,30,0,0,
		0,31,0,32,0,33
	};
	int TehaiNum = 0;
	int i;
	for(i = 1; i < 46; i++){
		for(int j = 0; j < Player->Tehai[i]; j++){
			m_MJ.m_Tehai.tehai[TehaiNum++] = ConvertHai[i];
		}
	}
	m_MJ.m_Tehai.tehai[13] = ConvertHai[Player->Tsumo];
	m_MJ.m_Tehai.tehai_num = TehaiNum;	//cȂ
	m_MJ.m_Tehai.leechi = Player->RichiIndex != 0 ? LEECHI_LEECHI : LEECHI_NON;
	if(Player->Ippatsu){m_MJ.m_Tehai.SetLeechiIppatsu();}
	if(Player->RichiIndex == 1){/*_u[`*/}
	
	//MahjongNXYHM_MakeChi͎gȂƁB
	//(v낤Ƃ邽)
	for(i = 0; i < 4; i++){
		switch(Player->Furo[i].Type){
		case MJFORO_CHI:	m_MJ.m_Tehai.AddChi(ConvertHai[Player->Furo[i].Hai]);break;
		case MJFORO_PON:	m_MJ.m_Tehai.AddPon(ConvertHai[Player->Furo[i].Hai]);break;
		case MJFORO_MINKAN:	m_MJ.m_Tehai.AddMinkan(ConvertHai[Player->Furo[i].Hai]);break;
		case MJFORO_ANKAN:	m_MJ.m_Tehai.AddAnkan(ConvertHai[Player->Furo[i].Hai]);break;
		}
	}

	m_MJ.m_Bakaze = m_Taku->Kyoku % 4;
	m_MJ.m_IsHaitei = m_Taku->GetRestTsumo() == 0 ? TRUE : FALSE;
	m_MJ.m_IsRinshan = m_Taku->Player[Index].Rinsyan;
	m_MJ.m_IsChankan = FALSE;

	//hǉ
	for(i = 0; i < m_Taku->GetKanNum() + 1; i++){
		m_MJ.YHM_SetDoraIndicator(i, m_Taku->GetDora(i));	//\
		m_MJ.YHM_SetDoraIndicator(i + 4, m_Taku->GetDora(i + 4));	//
	}
}
int CMJAgari::GetShanten(int Index)
{
	ConvertTehai(Index, FALSE);
	return Hantei::CalcShantenValue(m_MJ.m_Tehai);
}
//vC[AI
class CMJAI{
public:
	string m_Name;
	int m_Index;	//ǂɍĂ邩B0:NƁ`
	CMJTaku *m_Taku;
	MJTAKU m_AITaku;

	HINSTANCE m_AI;	//DLLnh
	typedef void (*AIACTION)(int, int, MJTAKU*);
	AIACTION AIAction;	//֐ւ̃|C^
	
	~CMJAI(){FreeLibrary(m_AI);}
	void Load(int Number);	//DLL[h
	void Action(int Msg);
};
void CMJAI::Action(int Msg)
{
	switch(Msg){
	case MJMSG_GAMESTART:case MJMSG_GAMEEND:
		AIAction(Msg, m_Index, &m_AITaku);return;
	}

	int i;
	//AIpMJTAKU\̂쐬
	m_AITaku = *m_Taku;
	//hZbg
	memset(m_AITaku.Dora, 0, sizeof(m_AITaku.Dora));
	for(i = 0; i < m_Taku->GetDoraNum(); i++){
		m_AITaku.Dora[i] = m_Taku->GetDora(i);
	}
	//ccZbg
	m_AITaku.RestTsumoNum = m_Taku->GetRestTsumo();
	//Ƃ̎vƃANV
	for(i = 0; i < 4; i++){
		m_AITaku.Player[i] = m_Taku->Player[i];
		if(i != m_Index){	//͎̂c
			memset(&m_AITaku.Player[i].Tehai, 0, sizeof(m_AITaku.Player[i].Tehai));
		}
		if(i != m_Taku->Turn){	//Ō̃ANV͎c
			memset(&m_AITaku.Player[i].Action, 0, sizeof(MJACTION));
		}
	}
	//Ăяo
	AIAction(Msg, m_Index, &m_AITaku);
	//ANV̂ݎ擾
	m_Taku->Player[m_Index].Action = m_AITaku.Player[m_Index].Action;
}
void CMJAI::Load(int Number)
{
	stringstream key;
	char buf[256];

	key << "AI" << Number;	//L[
	GetPrivateProfileString("AI", key.str().c_str(), "", buf, 256, ".\\MJSim.ini");
	if(buf[0] == NULL){
		cout << "init@C̓ǂݍ݂Ɏs܂B:" << key.str() << endl;
		throw;
	}
	m_AI = LoadLibrary(buf);
	if(m_AI == NULL){
		cout << "DLL[hł܂B:" << buf << endl;
		throw;
	}
	AIAction = (AIACTION)GetProcAddress(m_AI, "AIAction"); 
	if(AIAction == NULL){
		cout << "DLLAIAction֐܂B" << buf << endl;
		throw;
	}
	m_Name = buf;
	cout << buf << " OK" << endl;
}
//V~[^
class CMJSim{
	//̃f[^
	CMJTaku m_Taku;

	//̑f[^
	CMJAI *m_AI[4];	//AI͂ʂăANZXBQ[̏ꏊɑΉ邽
	CMJAI m_AIInstance[4];
	CMJAgari m_Agari;	//オ_vZNX
	fstream m_File;
	vector<int> m_Log;
	int m_AgariType;	//ǂオďIǂ
	struct MJGAMESCORE{	//Q[̌ʁBʂ̏ɕłB0:1 `
		MJPLAYER *Player;
		int Score;	//1000_Pʂ̓_BE}AIJ
	}m_GameScore[4];

	//C̊֐
	void Game();	//Jn
	void Kyoku();	//ǊJn
	void Reaction();	//̂Ĕvɑ΂郊ANV
	//ANV̏
	void Agari(int Index, bool IsRon);
	void Sutehai(int Index);
	void Richi(int Index);
	void Ankan(int Index);
	void Kakan(int Index);
	void Minkan(int Index);
	void Rinsyan(int Index);
	void Pon(int Index);
	void Chi(int Index);
	void Ryukyoku();
	void Action(int Index);
	//ANV`FbN
	void CheckActionForTsumo(int Index);
	void CheckSutehai(int Index);
	void CheckAnkan(int Index);
	void CheckKakan(int Index);
	void CheckActionForReaction(int Index);
	void CheckMinkan(int Index);
	void CheckPon(int Index);
	void CheckChi(int Index);
	//̑
	void LogStart();
	void LogGameStart();
	void LogKyokuStart();
	void LogKyokuEnd();
	void LogKyokuEndAgariInfo();
	void LogKyokuEndHaifu();
	void LogGameEnd();
	void LogHaifu(int Index,int Action, int Hosoku1 = 0, int Hosoku2 = 0);
	void InitKyoku();
	void InitGame();
	void CallAllAI(int Msg){for(int i = 0; i < 4; i++){m_AI[i]->Action(Msg);}}
	void CalcGameScore();
	bool CheckScoreOver();
	static int qsort_CalcGameScore(const void *p1, const void *p2);
	string GetTonpuHai(int Hai);
	string GetTonpuKaze(int Index);
	enum{	//オ̃^Cv
		MJAGARI_RYUKYOKU,
		MJAGARI_AGARI,
		MJAGARI_CHONBO
	};
public:
	CMJSim();
	void Run();
};
CMJSim::CMJSim()
{
	m_Agari.m_Taku = &m_Taku;

	m_File.open("MJSimScore.txt", ios::out);
	//֒ǉꍇ
	//m_File.open("MJSimScore.txt", ios::out | ios::app);
    if(m_File.is_open() == 0){
		cout << "t@CJ܂B";
		throw;
	}
	//AI[h
	for(int i = 0; i < 4; i++){m_AIInstance[i].Load(i);}
}
void CMJSim::Run()
{
	int i = 1;
	while(true){
		cout << i++;
		InitGame();
		Game();
		cout << endl;
		if(GetKeyState(VK_SHIFT) < 0){break;}
	}
}
void CMJSim::InitGame()
{
	int i;
	//f[^
	m_Taku.Kyoku = 0;
	m_Taku.RichiboNum = 0;
	m_Taku.TsumiboNum = 0;
	m_Taku.Tsumo = 0;
	m_Taku.RestTsumoNum = 0;
	m_Taku.Yama[136] = 0;

	//ꏊ
	for(i = 0; i < 4; i++){m_AI[i] = &m_AIInstance[i];}
	srand(GetSeed());
	for(i = 0; i < 4; i++){swap(m_AI[i], m_AI[rand() % 4]);}

	//ꏊ܂̂Ńf[^Zbg
	for(i = 0; i < 4; i++){
		//AĨf[^Zbg
		m_AI[i]->m_Index = i;
		m_AI[i]->m_Taku = &m_Taku;
		//MJTAKŨvC[f[^Zbg
		m_Taku.Player[i].Score = 27000;
	}
}
bool CMJSim::CheckScoreOver()
{
	for(int i = 0; i < 4; i++){
		if(m_Taku.Player[i].Score >= 30000){return true;}
	}
	return false;
}
void CMJSim::Game()
{
	LogGameStart();
	CallAllAI(MJMSG_GAMESTART);
	while(true){
		//4ǈȍ~ŁAK̓_𒴂vC[Q[I
		if(m_Taku.Kyoku > 3 && CheckScoreOver()){break;}
		
		LogKyokuStart();
		try{
			InitKyoku();
			CallAllAI(MJMSG_KYOKUSTART);
			Kyoku();
		}
		catch(int Msg){
			//オċǂIƂ̓Lb`BG[͖
			Msg = 0;	//x߂̃_~[R[h
		}
		LogKyokuEnd();
		CallAllAI(MJMSG_KYOKUEND);
		
		//AĂقȂꍇ
		m_Taku.Kyoku++;m_Taku.Kyoku %= 16;
		//AĂقꍇ
		/*
		//オvC[ełȂΎǂ
		if(m_AgariType == MJAGARI_AGARI && m_Taku.GetZikaze(m_Agari.GetIndex()) != 0){
			m_Taku.Kyoku++;m_Taku.Kyoku %= 16;
		}
		else{	//ȅオ肩ǂȂǂ̏ꍇ͘A
			m_Taku.TsumiboNum++;	//ςݖ_𑝂₷
		}
		*/		
		cout << ".";
	}
	CalcGameScore();	//Z
	LogGameEnd();
	CallAllAI(MJMSG_GAMEEND);
}
void CMJSim::InitKyoku()
{
	m_Log.clear();

	int score[4];
	int i;
	for(i = 0; i < 4; i++){
		score[i] = m_Taku.Player[i].Score;
	}
	memset(&m_Taku.Player, 0, sizeof(MJPLAYER) * 4);
	for(i = 0; i < 4; i++){
		m_Taku.Player[i].Score = score[i];
		strcpy(m_Taku.Player[i].Name, m_AI[i]->m_Name.c_str());
	}

	m_Taku.Turn = m_Taku.Kyoku % 4;	//c͒N
	m_Taku.Tsumo = &m_Taku.Yama[14];	//cJnʒu

	//Rς
	int hai[] = {	1,2,3,4,5,6,7,8,9,
					11,12,13,14,15,16,17,18,19,
					21,22,23,24,25,26,27,28,29,
					31,33,35,37,
					41,43,45};
	for(i = 0; i < 4; i++){	//34̔v4Rs[
		memcpy(m_Taku.Yama + i * 34, hai, sizeof(hai));
	}
	//܂
	srand(GetSeed());
	for(i = 0; i < 136; i++){
		swap(m_Taku.Yama[i], m_Taku.Yama[rand() % 136]);
	}
	//zv΂
	for(i = 0; i < 4; i++){
		for(int j = 0; j < 13; j++){
			m_Taku.Player[i].Tehai[*m_Taku.Tsumo]++;
			m_Taku.Tsumo++;
		}
	}
}
void CMJSim::Kyoku()
{
	//Ō̃c܂Ń[v
	while(*m_Taku.Tsumo != 0){
		MJPLAYER *Player = &m_Taku.Player[m_Taku.Turn];
		//c
		LogHaifu(m_Taku.Turn, MJACTION_TSUMO, *m_Taku.Tsumo);
		Player->Tsumo = *m_Taku.Tsumo;
		m_Taku.Tsumo++;
		
		m_AI[m_Taku.Turn]->Action(MJMSG_TSUMO);	//ʒm
		CheckActionForTsumo(m_Taku.Turn);	//ANV`FbN
		Action(m_Taku.Turn);	//ANVs
		//[`΂łȂΈꔭ
		if(Player->Action.Type != MJACTION_RICHI){Player->Ippatsu = false;}
		
		Reaction();	//̂Ĕvɑ΂ẴANV
		m_Taku.Turn++; m_Taku.Turn %= 4;	//̃vC[ɉ
	}
	//
	Ryukyoku();
}
void CMJSim::Reaction()
{
	CallAllAI(MJMSG_REACTION);	//Sɒʒm
	int i;
	//wꂽANV`FbN
	for(i = 0; i < 4; i++){CheckActionForReaction(i);}

	//v̂ĂvC[猩ċ߂ƂDɂ
	int index[4];
	//Turn̎index[0]ɂȂ悤ɂ
	for(i = 0; i < 4; i++){
		index[i] = (m_Taku.Turn + i + 1) % 4;
	}
	int r = index[0];	//̂Ĕvɑ΂ăANVNvC[
	//Dx̍ANV̗p
	for(i = 0; i < 4; i++){
		if(m_Taku.Player[r].Action.Type < m_Taku.Player[index[i]].Action.Type){
			r = index[r];
		}
	}
	//NANVH
	if(m_Taku.Player[r].Action.Type != MJACTION_NULL){
		//̗pANVs
		Action(r);
		//ꔭ
		for(i = 0; i < 4; i++){m_Taku.Player[i].Ippatsu = false;}
		m_Taku.Turn = r;	//^[AvC[ɐݒ
		Reaction();	//ċA
	}
}
void CMJSim::Action(int Index)
{
	MJPLAYER *Player = &m_Taku.Player[Index];
	switch(Player->Action.Type){
	case MJACTION_NULL:	break;
	case MJACTION_TSUMOAGARI:	Agari(Index, false);break;
	case MJACTION_ANKAN:	Ankan(Index);break;
	case MJACTION_KAKAN:	Kakan(Index);break;
	case MJACTION_RICHI:	Richi(Index);break;
	case MJACTION_SUTEHAI:	Sutehai(m_Taku.Turn);break;
	case MJACTION_RON:	Agari(Index, true);break;
	case MJACTION_PON:	Pon(Index);break;
	case MJACTION_CHI:	Chi(Index);break;
	case MJACTION_MINKAN:	Minkan(Index);break;
	}
}
void CMJSim::CheckActionForReaction(int Index)
{
	MJPLAYER *Player = &m_Taku.Player[Index];
	switch(Player->Action.Type){
	case MJACTION_NULL:	break;
	case MJACTION_RON:	break;	//ȂBオĂȂƂ̓`{
	case MJACTION_MINKAN:	CheckMinkan(Index);break;
	case MJACTION_PON:	CheckPon(Index);break;
	case MJACTION_CHI:	CheckChi(Index);break;
	default:
		Player->Action.Type = MJACTION_NULL;
	}
}
void CMJSim::CheckChi(int Index)
{
	int hai = m_Taku.GetLastSutehai();
	MJPLAYER *Player = &m_Taku.Player[Index];

	Player->Tehai[hai]++;	//vvɉ
	if(Player->Action.Hosoku < 1 ||
			Player->Action.Hosoku + 1 < 1 ||
			Player->Action.Hosoku + 2 < 1){
		//`[ɕKvȔvȂꍇAȂ
		Player->Action.Type = MJACTION_NULL;
	}
}
void CMJSim::CheckPon(int Index)
{
	int hai = m_Taku.GetLastSutehai();
	MJPLAYER *Player = &m_Taku.Player[Index];
	if(Player->Tehai[hai] < 2){
		//|ɕKvȔvȂꍇAȂ
		Player->Action.Type = MJACTION_NULL;
	}
}
void CMJSim::CheckMinkan(int Index)
{
	int hai = m_Taku.GetLastSutehai();
	MJPLAYER *Player = &m_Taku.Player[Index];
	if(Player->Tehai[hai] < 3){
		//JɕKvȔvȂꍇAȂ
		Player->Action.Type = MJACTION_NULL;
	}
}
void CMJSim::CheckActionForTsumo(int Index)
{
	MJPLAYER *Player = &m_Taku.Player[Index];
	switch(Player->Action.Type){
	case MJACTION_TSUMOAGARI:	break;	//ȂBオĂȂƂ̓`{
	case MJACTION_ANKAN:	CheckAnkan(Index);break;
	case MJACTION_KAKAN:	CheckKakan(Index);break;
	case MJACTION_RICHI:	CheckSutehai(Index);break;	//epCǂ͊mFȂBm[e[`
	case MJACTION_SUTEHAI:	CheckSutehai(Index);break;
	default:
		Player->Action.Type = MJACTION_SUTEHAI;
		Player->Action.Sutehai = 0;
	}
}
void CMJSim::CheckAnkan(int Index)
{
	MJPLAYER *Player = &m_Taku.Player[Index];
	int hai = Player->Action.Hosoku;

	Player->Tehai[Player->Tsumo]++;	//cvvɉ
	if(Player->Tehai[hai] < 4){
		//JłȂꍇAc؂ɂ
		Player->Action.Type = MJACTION_SUTEHAI;
		Player->Action.Sutehai = 0;
	}
	Player->Tehai[Player->Tsumo]--;
}
void CMJSim::CheckKakan(int Index)
{
	MJPLAYER *Player = &m_Taku.Player[Index];
	int hai = Player->Action.Hosoku;
	Player->Tehai[Player->Tsumo]++;	//cvvɉ

	//J|T
	int FuroIndex = -1;
	for(int i = 0; i < 4; i++){
		if(Player->Furo[i].Type == MJFORO_PON && Player->Furo[i].Hai == hai){
			FuroIndex = i;break;
		}
	}
	if(FuroIndex == -1 || Player->Tehai[hai] < 1){
		//JłȂꍇAc؂ɂ
		Player->Action.Type = MJACTION_SUTEHAI;
		Player->Action.Sutehai = 0;
	}
}
void CMJSim::CheckSutehai(int Index)
{
	MJPLAYER *Player = &m_Taku.Player[Index];
	if(Player->Action.Sutehai != 0 && Player->Tehai[Player->Action.Sutehai] < 1){
		//c؂ȊOŁA̔vĂȂꍇAc؂
		Player->Action.Type = MJACTION_SUTEHAI;
		Player->Action.Sutehai = 0;
	}
}
void CMJSim::Agari(int Index, bool IsRon)
{
	if(IsRon){
		//vvɉ
		int hai = m_Taku.GetLastSutehai();
		m_Taku.Player[Index].Tsumo = hai;
		LogHaifu(Index, MJACTION_RON);
	}
	else{
		LogHaifu(Index, MJACTION_TSUMOAGARI);
	}
	//オ_vZ
	//KyokuScore͒PɑȂ
	//[`œ_Ăꍇ
	if(m_Agari.Calc(Index, IsRon)){
		m_AgariType = MJAGARI_AGARI;
		m_Taku.Player[Index].KyokuScore += (m_Taku.RichiboNum * 1000);	//[`_
		m_Taku.RichiboNum = 0;
		m_Taku.Player[Index].KyokuScore += (m_Taku.TsumiboNum * 300);	//ςݖ_

		if(IsRon){	//
			m_Taku.Player[Index].KyokuScore += m_Agari.Score();
			m_Taku.Player[m_Taku.Turn].KyokuScore -= m_Agari.Score();
		}
		else{	//debug c
			for(int i = 0; i < 4; i++){
				if(Index == i){	//オvC[
					m_Taku.Player[i].KyokuScore += m_Agari.Score();
				}
				else{
					if(m_Taku.GetZikaze(Index) == 0){//オvC[e
						m_Taku.Player[i].KyokuScore -= m_Agari.Score() / 3;
					}
					else{	//q̏ꍇ
						if(m_Taku.GetZikaze(i) == 0){	//ȅꍇ
							m_Taku.Player[i].KyokuScore -= m_Agari.Score() / 2;
						}
						else{
							m_Taku.Player[i].KyokuScore -= m_Agari.Score() / 4;
						}
					}
				}
			}
		}
	}
	else{	//`{
		m_AgariType = MJAGARI_CHONBO;
	}
	//Z
	for(int i = 0; i < 4; i++){
		m_Taku.Player[i].Score += m_Taku.Player[i].KyokuScore;
	}
	throw 1;	//オƂ͗O1𑗂
}
void CMJSim::Ryukyoku()
{
	m_AgariType = MJAGARI_RYUKYOKU;
	int table[5][2] = {
		{0,0},			//epC0l
		{3000,-1000},	//1l
		{1500,-1500},
		{1000,-3000},
		{0,0},
	};
	//epCĂlJEg
	int i, TenpaiNum = 0;
	for(i = 0; i < 4; i++){
		if(m_Agari.GetShanten(i) == 0){TenpaiNum++;}
	}
	for(i = 0; i < 4; i++){
		int IsTenpai = m_Agari.GetShanten(i) == 0 ? 0 : 1;	//epCȂ0
		m_Taku.Player[i].KyokuScore += table[TenpaiNum][IsTenpai];
		m_Taku.Player[i].Score += m_Taku.Player[i].KyokuScore;
	}
}
void CMJSim::Richi(int Index)
{
	MJPLAYER *Player = &m_Taku.Player[Index];
	Player->RichiIndex = m_Taku.GetKawaLen(m_Taku.Turn);
	Player->Ippatsu = true;
	Player->KyokuScore -= 1000;	//ǃXRA1000_
	m_Taku.RichiboNum++;
	LogHaifu(Index, MJACTION_RICHI);

	Sutehai(Index);
}
void CMJSim::Pon(int Index)
{
	int hai = m_Taku.GetLastSutehai();
	m_Taku.SetFuroSutehai();	//}CiX̒lɂ
	LogHaifu(Index, MJACTION_PON);

	MJPLAYER *Player = &m_Taku.Player[Index];
	Player->Tehai[hai] -= 2;	//v폜
	int FuroIndex = m_Taku.GetFuroNum(Index);
	Player->Furo[FuroIndex].Type = MJFORO_PON;
	Player->Furo[FuroIndex].Hai = hai;
	Player->Furo[FuroIndex].Hosoku = m_Taku.Turn;	//ǂ

	Sutehai(Index);
}
void CMJSim::Minkan(int Index)
{
	int hai = m_Taku.GetLastSutehai();
	m_Taku.SetFuroSutehai();	//}CiX̒lɂ
	LogHaifu(Index, MJACTION_MINKAN, hai);

	MJPLAYER *Player = &m_Taku.Player[Index];
	Player->Tehai[hai] -= 3;	//v폜
	int FuroIndex = m_Taku.GetFuroNum(Index);
	Player->Furo[FuroIndex].Type = MJFORO_MINKAN;
	Player->Furo[FuroIndex].Hai = hai;
	Player->Furo[FuroIndex].Hosoku = m_Taku.Turn;	//ǂ

	Rinsyan(Index);
}
void CMJSim::Ankan(int Index)
{
	MJPLAYER *Player = &m_Taku.Player[Index];
	int hai = Player->Action.Hosoku;
	LogHaifu(Index, MJACTION_ANKAN, hai);

	Player->Tehai[Player->Tsumo]++;	//cvvɉ
	Player->Tehai[hai] -= 4;	//v폜
	if(hai != Player->Tsumo){	//Jvƃc֌WȂꍇAcv폜
		Player->Tehai[Player->Tsumo]--;
	}
	int FuroIndex = m_Taku.GetFuroNum(Index);
	Player->Furo[FuroIndex].Type = MJFORO_ANKAN;
	Player->Furo[FuroIndex].Hai = hai;

	Rinsyan(Index);
}
void CMJSim::Kakan(int Index)
{
	MJPLAYER *Player = &m_Taku.Player[Index];
	int hai = Player->Action.Hosoku;
	LogHaifu(Index, MJACTION_KAKAN, hai);
	Player->Tehai[Player->Tsumo]++;	//cvvɉ

	//J|T
	int FuroIndex = -1;
	for(int i = 0; i < 4; i++){
		if(Player->Furo[i].Type == MJFORO_PON && Player->Furo[i].Hai == hai){
			FuroIndex = i;break;
		}
	}
	Player->Furo[FuroIndex].Type = MJFORO_MINKAN;
	Player->Furo[FuroIndex].Hai = hai;

	Player->Tehai[hai]--;	//v폜
	if(hai != Player->Tsumo){	//Jvƃc֌WȂꍇAcv폜
		Player->Tehai[Player->Tsumo]--;
	}
	Rinsyan(Index);
}
void CMJSim::Rinsyan(int Index)
{
	MJPLAYER *Player = &m_Taku.Player[Index];
	Player->Tsumo = m_Taku.Yama[m_Taku.GetKanNum()];
	Player->Rinsyan = true;
	m_Taku.Turn = Index;	//^[JvC[ɐݒ

	m_AI[m_Taku.Turn]->Action(MJMSG_TSUMO);	//ʒm
	CheckActionForTsumo(m_Taku.Turn);	//ANV`FbN
	Action(m_Taku.Turn);	//AIɎwꂽANVs
	Player->Rinsyan = false;
}
void CMJSim::Chi(int Index)
{
	int hai = m_Taku.GetLastSutehai();
	m_Taku.SetFuroSutehai();	//}CiX̒lɂ

	//v폜
	MJPLAYER *Player = &m_Taku.Player[Index];
	int FuroIndex = m_Taku.GetFuroNum(Index);
	for(int i = 0; i < 3; i++){
		if(hai != Player->Action.Hosoku + i){
			//vȊOv폜
			Player->Tehai[Player->Action.Hosoku + i]--;
		}
		else{
			//3̔v̓AԖڂvZbg
			Player->Furo[FuroIndex].Hosoku = i;
		}
	}
	//t[Zbg
	Player->Furo[FuroIndex].Type = MJFORO_CHI;
	Player->Furo[FuroIndex].Hai = Player->Action.Hosoku;	//`[̐擪v

	//O
	switch(Player->Furo[FuroIndex].Hosoku){
	case 0:	LogHaifu(Index, MJACTION_CHI, Player->Action.Hosoku + 1, Player->Action.Hosoku + 2);break;
	case 1:	LogHaifu(Index, MJACTION_CHI, Player->Action.Hosoku + 0, Player->Action.Hosoku + 2);break;
	case 2:	LogHaifu(Index, MJACTION_CHI, Player->Action.Hosoku + 0, Player->Action.Hosoku + 1);break;
	}

	Sutehai(Index);
}
void CMJSim::Sutehai(int Index)
{
	MJPLAYER *Player = &m_Taku.Player[Index];
	
	//c؂
	if(Player->Action.Sutehai == 0){
		LogHaifu(Index, MJACTION_SUTEHAI_TSUMOGIRI, Player->Tsumo);
		Player->Kawa[m_Taku.GetKawaLen(Index)] = Player->Tsumo;
		Player->Tsumo = 0;
	}
	else{
		LogHaifu(Index, MJACTION_SUTEHAI, Player->Action.Sutehai);
		Player->Kawa[m_Taku.GetKawaLen(Index)] = Player->Action.Sutehai;
		//w肳ꂽv폜
		Player->Tehai[Player->Action.Sutehai]--;
		//cvɒǉĂ(`[Ȃǂ̂Ƃ̓c)
		if(Player->Tsumo != 0){
			Player->Tehai[Player->Tsumo]++;
			Player->Tsumo = 0;
		}
	}
}
int CMJSim::qsort_CalcGameScore(const void *p1, const void *p2)
{
	//p1,p2̓|C^ւ̃|C^
	//~ɕׂ
	return (*(MJPLAYER**)p2)->Score - (*(MJPLAYER**)p1)->Score;
}
void CMJSim::CalcGameScore()
{
	//\[g
	MJPLAYER *p[4];
	int i;
	for(i = 0; i < 4; i++){
		p[i] = &m_Taku.Player[i];
	}
	qsort((void*)p, 4, sizeof(MJPLAYER*), qsort_CalcGameScore);

	for(i = 0; i < 4; i++){
		//1000_Pʂ̓_߂
		int uma[] = {8,4,-4,-8};	//ʓ_
		int score = (p[i]->Score - 30000) / 1000 + uma[i];
		if(i == 0){score += (3 * 4);}	//1ʂɃIJ𑫂Ă

		m_GameScore[i].Player = p[i];
		m_GameScore[i].Score = score;
	}
}
string CMJSim::GetTonpuHai(int Hai)
{
	char *t[] = {
		"","1m","2m","3m","4m","5m","6m","7m","8m","9m",
		"","1p","2p","3p","4p","5p","6p","7p","8p","9p",
		"","1s","2s","3s","4s","5s","6s","7s","8s","9s",
		"","","",  "","",  "","",  "k",  "",  "",
		"","","",  "","",  ""
	};
	return t[Hai];
}
string CMJSim::GetTonpuKaze(int Index)
{
	char *t[] = {"","","","k"};
	return t[Index];
}
void CMJSim::LogGameStart()
{
	m_File	<< endl
			<< "===== FLO 300 Jn 2003/01/01 00:00 =====" << endl
			<< "  _27000 ";
	for(int i = 0; i < 4; i++){
		m_File << "[" << i + 1 << "]" << m_AI[i]->m_Name << " R1500 ";
	}
	m_File << endl;
}
void CMJSim::LogKyokuStart()
{
	//Ȃ
}
void CMJSim::LogKyokuEnd()
{
	//ǂ̌
	m_File	<< endl << "  " << GetTonpuKaze(m_Taku.Kyoku / 4) << m_Taku.Kyoku % 4 + 1 << " "
			<< m_Taku.TsumiboNum << "{([`" << m_Taku.RichiboNum << ")";
	int i;
	for(i = 0; i < 4; i++){
		if(m_Taku.Player[i].KyokuScore != 0){
			m_File	<< " " << m_Taku.Player[i].Name << " " << m_Taku.Player[i].KyokuScore;
		}
	}
	m_File << endl;

	LogKyokuEndAgariInfo();
	LogKyokuEndHaifu();
}
void CMJSim::LogKyokuEndHaifu()
{
	//zv
	int k = 0;
	for(int i = 0; i < 4; i++){
		m_File << "    [" << i + 1 << GetTonpuKaze(m_Taku.GetZikaze(i)) << "]";
		//\[gBqXgO֓
		int hist[46];
		memset(hist, 0, 46 * sizeof(int));
		for(int j = 0; j < 13; j++){
			hist[m_Taku.Yama[(i * 13 + j) + 14]]++;
		}
		//O֏o
		for(j = 1; j < 46; j++){
			for(int k = 0; k < hist[j]; k++){
				m_File << GetTonpuHai(j);
			}
		}
		m_File << endl;
	}
	
	//h
    m_File << "    [\h]";
	for(i = 0; i < m_Taku.GetDoraNum(); i++){	//ȂƂ1̓h
		m_File << GetTonpuHai(m_Taku.GetDora(i));
	}
    m_File << " [h]";
	for(i = 0; i < m_Taku.GetDoraNum(); i++){
		m_File << GetTonpuHai(m_Taku.GetDora(i + 4));
	}
	m_File << endl;

	//v
    m_File << "    * ";
	char *TompuAction[] = {"","R","d","D","C","N","K","A","A","K","K","G"};

	vector<int>::iterator it;
	for(it = m_Log.begin(); it != m_Log.end();){
		m_File << *it + 1;	//vC[ԍ
		it++;
		int action = *it;
		it++;
		m_File << TompuAction[action];	//ANV
		switch(action){
		case MJACTION_TSUMO:
		case MJACTION_SUTEHAI:
		case MJACTION_SUTEHAI_TSUMOGIRI:
		case MJACTION_ANKAN:
		case MJACTION_MINKAN:
			m_File << GetTonpuHai(*it);it++;it++;break;

		case MJACTION_CHI:
			m_File << GetTonpuHai(*it);it++;
			m_File << GetTonpuHai(*it);it++;break;

		case MJACTION_TSUMOAGARI:
		case MJACTION_RON:
		case MJACTION_PON:
		case MJACTION_RICHI:
			it++;it++;break;
		}
		m_File << " ";
	}
	m_File	<< endl;
}
void CMJSim::LogKyokuEndAgariInfo()
{
	//オ
	m_File << "    ";
	switch(m_AgariType){	//オꍇ
	case MJAGARI_AGARI:
		{
			char *agari[] = {"c",""};
			char *kansuji[] = {"","","","O","l"};
			switch(m_Agari.Han()){
			case 5:
				m_File << "";break;
			case 6:case 7:
				m_File << "nl";break;
			case 8:case 9:case 10:
				m_File << "{";break;
			case 11:case 12:
				m_File << "R{";break;
			case 13:
				m_File << "𖞊";break;
			default:
				m_File << m_Agari.Fu() << " "<< kansuji[m_Agari.Han()] << "";
			}
			m_File << agari[m_Agari.IsRon()] << " ";
			for(int i = 0; i < m_Agari.YakuNum(); i++){
				m_File << m_Agari.YakuName(i) << " ";
			}
		}
		break;
	case MJAGARI_RYUKYOKU:
		m_File << "";break;
	case MJAGARI_CHONBO:
		m_File << "`{";break;
	}
	m_File << endl;
}
void CMJSim::LogGameEnd()
{
	m_File	<< endl << "  ----  ----" << endl;
	for(int i = 0; i < 4; i++){
		m_File	<< "  " << i + 1 << " "
				<< m_GameScore[i].Player->Name << " "
				<< showpos
				<< m_GameScore[i].Score
				<< noshowpos << endl;
	}
	m_File	<< "----- 300 I 2003/01/01 00:00 -----" << endl;
}
void CMJSim::LogHaifu(int Index,int Action, int Hosoku1, int Hosoku2)
{
	m_Log.push_back(Index);
	m_Log.push_back(Action);
	m_Log.push_back(Hosoku1);
	m_Log.push_back(Hosoku2);
}
int main(int argc, char* argv[])
{
	cout << "MJSim ver 0.3.1" << endl;

	CMJSim Sim;
	Sim.Run();

	return 0;
}
//