//////////////////////////////////////////////////////////////////////////////////////
//
//  Mahjong.h
//
//////////////////////////////////////////////////////////////////////////////////////
#ifndef _MAHJONG_H_
#define _MAHJONG_H_

#include <windows.h>

#include <vector>
#include "Def.h"


#define MAHJONG_DEBUG	1		// 1:fobO[hC0:[X[h

#define DORA_MAX	10			// h10I

BOOL	is_hai( char hai ) ;			// vH
BOOL	is_suujihai( char hai ) ;		// vH
BOOL	is_wanzu( char hai ) ;			// ݎqH
BOOL	is_pinzu( char hai ) ;			// qH
BOOL	is_souzu( char hai ) ;			// qH
BOOL	is_jihai( char hai ) ;			// vH
BOOL	is_kazehai( char hai ) ;		// vH
BOOL	is_sangenhai( char hai ) ;		// OvH
BOOL	is_19jihai( char hai );			// 19vH
BOOL	is_19hai( char hai ) ;			// 19vH
BOOL	is_yakuhai( char hai, BYTE bakaze, BYTE jikaze ) ;
const char * GetYakuName( BYTE yaku ) ;	// ID𖼂𓾂D
char	GetYakuFan( BYTE yaku, BOOL is_menzen ) ;	// IDʐ𓾂D
long GetScore( BYTE fan, BYTE fu, BOOL oya ) ;		//    _𓾂D

enum
{
	HAI_1WAN,
	HAI_2WAN,
	HAI_3WAN,
	HAI_4WAN,
	HAI_5WAN,
	HAI_6WAN,
	HAI_7WAN,
	HAI_8WAN,
	HAI_9WAN,
	HAI_1PIN,
	HAI_2PIN,
	HAI_3PIN,
	HAI_4PIN,
	HAI_5PIN,
	HAI_6PIN,
	HAI_7PIN,
	HAI_8PIN,
	HAI_9PIN,
	HAI_1SOU,
	HAI_2SOU,
	HAI_3SOU,
	HAI_4SOU,
	HAI_5SOU,
	HAI_6SOU,
	HAI_7SOU,
	HAI_8SOU,
	HAI_9SOU,
	HAI_TON,
	HAI_NAN,
	HAI_SHA,
	HAI_PEI,
	HAI_HAKU,
	HAI_HATSU,
	HAI_CHUN,

	HAI_URA
};

enum
{
	YAKU_YAKUNASI,
	YAKU_LEECHI,
	YAKU_IPPATSU,
	YAKU_TSUMO,	
	YAKU_YAKUHAI,
	YAKU_DORA,
	YAKU_PINFU,				
	YAKU_TANYAO,			
	YAKU_IPEIKO,			
	YAKU_HAITEI,	
	YAKU_HOUTEI,
	YAKU_RINSHANKAIHOU,		
	YAKU_CHANKAN,			
	YAKU_SANSYOKU,			
	YAKU_IKKI,				
	YAKU_TOITOI,			
	YAKU_CHITOITSU,			
	YAKU_DOUBLEE,			
	YAKU_CHANTA,			
	YAKU_SANANKO,			
	YAKU_SANSYOKUDOUKOKU,	
	YAKU_SANKANTSU,			
	YAKU_HONITSU,			
	YAKU_JYUNCHAN,			
	YAKU_RYANPEIKO,			
	YAKU_SYOUSANGEN,		
	YAKU_HONRO,				
	YAKU_CHINITSU,			
	YAKU_KOKUSHI,			
	YAKU_SUANKO,			
	YAKU_DAISANGEN,			
	YAKU_SYOUSUSHI,				
	YAKU_DAISUSHI,			
	YAKU_TENHO,				
	YAKU_CHIHO,				
	YAKU_TSUISO,			
	YAKU_RYUISO,			
	YAKU_CHINROTO,			
	YAKU_CHUREN,			
	YAKU_SUKANTSU,			

	YAKU_MAX
};


enum
{
	MACHI_NON,	
	MACHI_RYANMEN,		// ʑ҂
	MACHI_KANCHAN,		// Ɠ҂
	MACHI_PENCHAN,		// Ӓ҂
	MACHI_SHANPON,		// o҂
	MACHI_TANKI			// PR҂
};


enum 
{
	MENTSU_NON,			// ʎq
	MENTSU_ANSHUN,		// Ïq
	MENTSU_MINSHUN,		// q
	MENTSU_ANKO,		// Íq
	MENTSU_MINKO,		// q
	MENTSU_ANKAN,		// ÞȎq
	MENTSU_MINKAN,		// Ȏq
};

enum
{
	KAZE_TON,	// 
	KAZE_NAN,	// 
	KAZE_SHA,	// 
	KAZE_PEI,	// k
};


//[ [` ̃^Cv ]
enum
{
	LEECHI_NON,					// [`
	LEECHI_LEECHI,				// [`(m[})
	LEECHI_LEECHI_IPPATSU,		// [`ꔭ
	LEECHI_DOUBLEE,				// _u[`
	LEECHI_DOUBLEE_IPPATSU		// _u[`ꔭ
};


//[ ṽ^Cv ]
enum
{
	NAKI_CHI		= MENTSU_MINSHUN ,	// `[
	NAKI_PON		= MENTSU_MINKO ,	// |
	NAKI_MINKAN		= MENTSU_MINKAN ,	// J
	NAKI_ANKAN		= MENTSU_ANKAN ,	// AJ
};

struct NakihaiData
{
	BYTE	type ;	// NAKI_...
	char	hai ;

	BOOL	IsChi()		const { return ( type == NAKI_CHI    )? TRUE : FALSE ; }
	BOOL	IsPon()		const { return ( type == NAKI_PON    )? TRUE : FALSE ; }
	BOOL	IsMinkan()	const { return ( type == NAKI_MINKAN )? TRUE : FALSE ; }
	BOOL	IsAnkan()	const { return ( type == NAKI_ANKAN  )? TRUE : FALSE ; }
};


//[ vC̎v ]
struct	TehaiData
{	
	BOOL	is_menzen ;				// TRUE:OCFALSE:
	BOOL	is_ron ;				// TRUE:cv̓œDFALSE:cv̓cĂD

	BYTE	jikaze ;				// 

	BYTE	tehai_num ;				// v
	char	tehai[14] ;				// v{(v) [13]͏Ƀcv

	BYTE	leechi ;				// [`^Cv

	char		nakihai_num ;		// v
	NakihaiData	nakihai[ 4 ] ;		// v(q͐擪vCq͂̔v)

	//[  ]
	void	Reset()
	{
		jikaze		= KAZE_TON ;
		is_menzen	= TRUE ;
		is_ron		= FALSE ;
		tehai_num	= 0 ;
		tehai[13]	= -1 ;	// cv
		nakihai_num	= 0 ;
		leechi		= LEECHI_NON ;
	}

	BOOL	IsMenzen()		const { return is_menzen ; }
	BOOL	HasTsumohai()	const { return is_hai( tehai[13] ); }
	char	Tsumohai()		const { return tehai[ 13 ] ; }
	BYTE	Jikaze()		const { return jikaze ; }
	int		NakihaiNum()	const { return nakihai_num ; }
	int		TehaiNum()		const { return tehai_num ; }
	void	SetJikaze( BYTE kaze ) { jikaze = kaze & 0x03 ; }
	void	SetTsumohai( char hai ) { tehai[ 13 ] = hai ; }
	BOOL	IsLeechied() const { return ( leechi != LEECHI_NON )? TRUE : FALSE ; }
	void	SetLeechiIppatsu( BOOL bDouble=FALSE ) { leechi = (bDouble)? LEECHI_DOUBLEE_IPPATSU : LEECHI_LEECHI_IPPATSU ; }
	void	DropIppatsu()   // ꔭ艺
	{
		if ( leechi == LEECHI_LEECHI_IPPATSU ) leechi = LEECHI_LEECHI ;
		else if ( leechi == LEECHI_DOUBLEE_IPPATSU ) leechi = LEECHI_DOUBLEE ;
	}
	BYTE	GetLeechiType() const { return leechi ; }

	//[ `[ǉ ]
	void AddChi( char hai ) 
	{ 
		if ( nakihai_num >= 4 ) { ::ErrorMessage( "AddChi:ł" ) ;	return ; }
		nakihai[ nakihai_num ].type	= NAKI_CHI ;
		nakihai[ nakihai_num ].hai	= hai ; 
		nakihai_num ++ ;

		is_menzen	= FALSE ;
	}
	//[ |ǉ ]
	void AddPon( char hai )
	{	
		if ( nakihai_num >= 4 ) { ::ErrorMessage( "AddPon:ł" ) ;	return ; }
		nakihai[ nakihai_num ].type	= NAKI_PON ;
		nakihai[ nakihai_num ].hai	= hai ;
		nakihai_num ++ ;

		is_menzen	= FALSE ;
	}
	//[ Jǉ ]
	void AddMinkan( char hai )
	{
		if ( nakihai_num >= 4 ) { ::ErrorMessage( "AddMinkan:ł" ) ;	return ; }
		nakihai[ nakihai_num ].type	= NAKI_MINKAN ;
		nakihai[ nakihai_num ].hai	= hai ;
		nakihai_num ++ ;	
		
		is_menzen	= FALSE ;
	}
	//[ AJǉ ]
	void AddAnkan( char hai )
	{
		if ( nakihai_num >= 4 ) { ::ErrorMessage( "AddAnkan:ł" ) ;	return ; }
		nakihai[ nakihai_num ].type	= NAKI_ANKAN ;
		nakihai[ nakihai_num ].hai	= hai ;
		nakihai_num ++ ;		

	}
};



// AK^(vuvƁuʎqv؂o)
// v ͊܂܂Ȃ
struct	AgariForm
{
	char	atama ;
	char	kotsu_num ;
	char	kotsu[ 4 ] ;
	char	shuntsu_num ;
	char	shuntsu[ 4 ] ;

	//[ Zbg ]
	void	Reset()
	{
		atama		= -1 ;
		kotsu_num	= 0 ;
		shuntsu_num	= 0 ;
	}

	//[ lԂn ]
	char	ShuntsuNum() const { return shuntsu_num ; }
	char	KotsuNum() const { return kotsu_num ; }

};

/*
enum MentsuType 
{
	MENTSU_NON,			// ʎq
	MENTSU_ANSHUN,		// Ïq
	MENTSU_MINSHUN,		// q
	MENTSU_ANKO,		// Íq
	MENTSU_MINKO,		// q
	MENTSU_ANKAN,		// ÞȎq
	MENTSU_MINKAN,		// Ȏq
};
*/

// f[^ł ʎq f[^D
struct MentsuData
{
	BYTE	type ;	// MENTSU_...
	char	hai ;	// 0`33

	void	Reset()	{ type = MENTSU_NON ; }
	BOOL	IsAnshun() const { return ( type == MENTSU_ANSHUN )? TRUE : FALSE ; }
	BOOL	IsChi() const { return ( type == MENTSU_MINSHUN )? TRUE : FALSE ; }
	BOOL	IsPon() const { return ( type == MENTSU_MINKO )? TRUE : FALSE ; }
	BOOL	IsAnko() const { return ( type == MENTSU_ANKO )? TRUE : FALSE ; }
	BOOL	IsAnkan() const { return ( type == MENTSU_ANKAN )? TRUE : FALSE ; }
	BOOL	IsMinkan() const { return ( type == MENTSU_MINKAN )? TRUE : FALSE ; }
};


// f[^
//	{I v{AK^ ̑gݍ킹D
//	̑ ̃Xg ʁC ̏D
struct YakuData
{
	char		atama ;			// 
	char		mentsu_num ;	// ʎq
	MentsuData	mentsu[ 4 ] ;	// ʎq{

	BYTE		anshun_num ;	// Ïq  ̕ӂ͒T̍̂
	BYTE		minshun_num ;	// q	
	BYTE		anko_num ;		// Íq
	BYTE		minko_num ;		// q
	BYTE		ankan_num ;		// ÞȎq
	BYTE		minkan_num ;	// Ȏq

	BYTE		has_pinfu ;		// aĂ(st͗OƂ邩)
	BYTE		is_kokushi_form ;	// mo ^łD
	BYTE		is_chitoi_form ;	// Ύq ^ł(ΎqOƂ邩)
	BYTE		yakuman_num ;	// 𖞐(_u𖞂ƂɕKv)
	BYTE		yakuhai_num ;	// v(OvƂv)
	BYTE		dora_num ;		// h
	BYTE		jikaze ;		// 
	BYTE		machi_type ;	// ҂̎ށD(MACHI_...)
	BOOL		is_menzen ;		// TRUE:ʑOCFALSE:
	BOOL		is_ron ;		// AK
	BYTE		fan, fu ;		// ʁC
	BYTE		base_fu, mentsh_fu, machi_fu ;	// foOp
	long		score ;			// _
	
	std::vector< BYTE >	yaku_list ;	// Xg

	//[ ܂ ]
	void	Reset()
	{
		jikaze		= KAZE_TON ;
		atama		= -1 ;
		mentsu_num	= 0 ;
		anshun_num	= minshun_num = anko_num = minko_num = ankan_num = minkan_num = 0 ;
		is_menzen	= TRUE ;
		is_ron		= FALSE ;
		is_chitoi_form	= FALSE ;
		is_kokushi_form	= FALSE ;
		has_pinfu	= FALSE ;
		yakuman_num	= 0 ;
		yakuhai_num	= 0 ;
		dora_num	= 0 ;
		machi_type	= MACHI_NON ;
		fu			= 0 ;
		fan			= 0 ;
		score		= 0 ;
		yaku_list.clear() ;

		base_fu	= mentsh_fu = machi_fu = 0 ;
	}

	//[ lԂn ]
	BOOL	IsMenzen() const { return is_menzen ; }
	BOOL	IsRon() const { return is_ron ; }
	char	MentsuNum() const { return mentsu_num ; }
	BOOL	YakuNum() const { return yaku_list.size() ; }
	BYTE	GetYaku( BYTE index ) const { return yaku_list[ index ] ; }
	BYTE	Jikaze() const { return jikaze ; }
	BOOL	IsOya() const { return ( jikaze == KAZE_TON )? TRUE : FALSE ; }
	void	SetJikaze( BYTE kaze ) { jikaze	= kaze & 0x03 ; }
	BYTE	HasPinfu() const { return has_pinfu ; }
	BYTE	IsChitoiForm() const { return is_chitoi_form ; }
	BYTE	IsKokushiForm() const { return is_kokushi_form ; }

	BYTE	AnshunNum()	const { return anshun_num ; }
	BYTE	ChiNum()	const { return minshun_num ; }
	BYTE	AnkoNum()	const { return anko_num ; }
	BYTE	PonNum()	const { return minko_num ; }
	BYTE	AnkanNum()	const { return ankan_num ; }
	BYTE	MinkanNum() const { return minkan_num ; }

	//[ ǉ ]
	void	AddYaku( BYTE yaku )	{	yaku_list.push_back( yaku ) ; }
	
	//[ 폜 ]
	void	DeleteYaku( BYTE yaku )
	{
		std::vector< BYTE >::iterator it = yaku_list.begin() ;
		for( ; it != yaku_list.end() ; ++it )
		{
			if ( yaku == (BYTE)(*it) )	yaku_list.erase( it ) ;
		}
	}


	//[ v  AK^ f[^쐬 ]
	void Create( const TehaiData & tehai, const AgariForm & agari )
	{
		int i ;
		Reset() ;

		if ( tehai.NakihaiNum() + agari.KotsuNum() + agari.ShuntsuNum() != 4 ) 
		{
			::ErrorMessage( "YakuData::Create :vAK^słD" ) ;	
			return ;
		}

		//[ v(ƂvC)f[^p ]
		jikaze		= tehai.Jikaze() ;
		is_ron		= tehai.is_ron ;

		//[ vvZbgĂ ]
	
		is_menzen	= tehai.IsMenzen() ;

		for ( i=0 ; i < tehai.NakihaiNum() ; ++i, ++mentsu_num )
		{
			// v  ʎq ̃^Cv͋
			mentsu[ mentsu_num ].type	= tehai.nakihai[ i ].type ;
			mentsu[ mentsu_num ].hai	= tehai.nakihai[ i ].hai ;
		}

		//[ AKv琝{ʎqZbgĂ ]
		atama	= agari.atama ;

		for ( i=0 ; i < agari.KotsuNum() ; ++i, ++mentsu_num )
		{
			mentsu[ mentsu_num ].type	= MENTSU_ANKO ;
			mentsu[ mentsu_num ].hai	= agari.kotsu[ i ] ;
		}
		for ( i=0 ; i < agari.ShuntsuNum() ; ++i, ++mentsu_num )
		{
			mentsu[ mentsu_num ].type	= MENTSU_ANSHUN ;
			mentsu[ mentsu_num ].hai	= agari.shuntsu[ i ] ;
		}


		//[ oオʎq炻ꂼ̖ʎq̐߂Ă ]
		for ( i=0 ; i < mentsu_num ; ++i )
		{
			switch ( mentsu[ i ].type )
			{
			case MENTSU_ANSHUN :	anshun_num ++ ;		break ;
			case MENTSU_MINSHUN :	minshun_num ++ ;	break ;
			case MENTSU_ANKO :		anko_num ++ ;		break ;
			case MENTSU_MINKO :		minko_num ++ ;		break ;
			case MENTSU_ANKAN :		ankan_num ++ ;		break ;
			case MENTSU_MINKAN :	minkan_num ++ ;		break ;
			}
		}
	}
};


typedef std::vector< BYTE >			MachiList ;
typedef std::vector< AgariForm >	AgariList ;
typedef std::vector< YakuData >		YakuList ;

//////////////////////////////////////////////////////////////////////////////////////
//
//	Mahjong NX
//
//	͖𔻒胂[h˂Ă܂ꕪ܂D
//
//	ۂɂ̃NXōśC
//
//	EvR
//	Eh
//
//	̐łD
//	킩₷΁Cv̐sɂȂȂ悤ɊǗĂ܂D
//	Ȃ̂ŁCc̎ȂǂCMahjongNXɑ΂Ė₢킹悤ɂ܂D
//
//////////////////////////////////////////////////////////////////////////////////////
class Mahjong
{
public :
	Mahjong() ;
	virtual ~Mahjong() ;

	BOOL	Init() ;

	//[ n ]
	void	Shipai() ;				// v
	char	GetHaiFromYama() ;		// vRPv𓾂܂D
	BOOL	GetHaiFromYama( char hai ) ;
	
	//[ PɒlԂn ]
	char	GetDoraIndicator( int index ) const { return s_DoraIndicator[ index ] ; }
	static	char * GetDoraIndicators() { return s_DoraIndicator ; }
	int		NokoriNum() const { return m_YamahaiNum - m_WangpaiNum ; }

	//[ lZbgn ]
	void	SetWangpaiNum( WORD wangpai_num ) { m_WangpaiNum = wangpai_num ; }
	



	//[ 𔻒胂[hp ]----------------------------
	BOOL	YHM_IsHaitei()	const { return m_IsHaitei ; }
	BOOL	YHM_IsRinshan() const { return m_IsRinshan ; }
	BOOL	YHM_IsChankan() const { return m_IsChankan ; }
	void	YHM_SetHaitei ( BOOL flag ) { m_IsHaitei = flag ; }
	void	YHM_SetRinshan( BOOL flag )	{ m_IsRinshan = flag ; }
	void	YHM_SetChankan( BOOL flag ) { m_IsChankan = flag ; }
	BOOL	YHM_SetDoraIndicator( int index, char hai ) ;
	BYTE	YHM_Jikaze() const { return m_Tehai.Jikaze() ; }
	BYTE	YHM_Bakaze() const { return m_Bakaze ; }
	void	YHM_SetJikaze( BYTE kaze ) { m_Tehai.SetJikaze( kaze ) ; }
	void	YHM_SetBakaze( BYTE kaze ) { m_Bakaze = kaze & 0x03 ; }

	BOOL	YHM_MakeChi( char hai ) ;
	BOOL	YHM_MakePon( char hai ) ;
	BOOL	YHM_MakeMinkan( char hai ) ;
	BOOL	YHM_MakeAnkan( char hai ) ;

	BOOL		YHM_YakuHantei( BOOL is_ron ) ;
	const YakuData & YHM_GetYakuData() const { return m_Yaku ; }
	BYTE		YHM_GetLeechiType() const { return m_Tehai.GetLeechiType() ; }
	void		YHM_SetLeechiType( BYTE type ) { m_Tehai.leechi = type ; }
	BOOL		YHM_Tsumo( char hai ) ;
	BOOL		YHM_Nurikae( char hai, BYTE tehai_index ) ;
	void		YHM_Leepai() ;	// v


protected :


public :
	TehaiData	m_Tehai ;			// v(𔻒胂[hp)
	YakuData	m_Yaku ;			// f[^(𔻒胂[hp)
	BYTE		m_Bakaze ;			// ꕗ(𔻒胂[hp)
	BOOL		m_IsHaitei ;		// C(𔻒胂[hpj
	BOOL		m_IsRinshan ;		// (𔻒胂[hp)
	BOOL		m_IsChankan ;		// (𔻒胂[hp)

	WORD		m_WangpaiNum ;		// v
	WORD		m_YamahaiNum ;		// Rɂv̐
	static char	s_DoraIndicator[ DORA_MAX ] ;	// h\v(5`9͗h) 
	char		m_Yama[ 34 ] ;		// Rv

};

#endif
//////////////////////////////////////////////////////////////////////////////////////
//  EOF : Mahjong.h
//////////////////////////////////////////////////////////////////////////////////////