//////////////////////////////////////////////////////////////////////////////////////
//
//  Hantei.cpp
//
//////////////////////////////////////////////////////////////////////////////////////

#include "Hantei.h"


//////////////////////////////////////////////////////////////////////////////////////
//
//	Hantei NX
//
//////////////////////////////////////////////////////////////////////////////////////


BYTE		Hantei::s_Bakaze	= KAZE_TON ;	// uꕗv𔻒ɕKv
YakuData	Hantei::s_Yaku	;


//====================================================================================
//
//	uꕗvݒ肷D
//	ꕗ́Cʐ𐳊mɋ߂邽߂ɕKvłD
//
//====================================================================================
void	Hantei::SetBakaze( BYTE kaze )
{
	s_Bakaze	= kaze & 0x03 ;
}



//====================================================================================
//
//	f[^́uvCvʐ߂D
//
//	[]
//	uvǉς݂̃Nf[^
//
//====================================================================================
void	Hantei::SumYakuFan( YakuData * pYaku )
{
	for (int i=0 ; i < pYaku->YakuNum() ; ++i )
	{
		pYaku->fan += ::GetYakuFan( pYaku->GetYaku( i ), pYaku->IsMenzen() ) ;
	}
	
	pYaku->fan	+= pYaku->yakuhai_num ;
}


//====================================================================================
//
//	f[^C ߂
//
//====================================================================================
void	Hantei::CalcFu( YakuData * pYaku )
{
	BYTE	base_fu	= 0 ;
	BYTE	mentsu_fu = 0 ;
	BYTE	machi_fu = 0 ;


	//[ {_(OȂ{10) ]
	base_fu = ( pYaku->IsMenzen()  &&  pYaku->IsRon() )? 30 : 20 ;

	
	//[ ʎqɂ ]

	for (int i=0 ; i < pYaku->MentsuNum() ; ++i )
	{
		BYTE tmp_fu = 0;

		switch ( pYaku->mentsu[ i ].type )
		{
		case MENTSU_MINKO :		tmp_fu +=  2 ;	break ;
		case MENTSU_ANKO :		tmp_fu +=  4 ;	break ;
		case MENTSU_MINKAN :	tmp_fu +=  8 ;	break ;
		case MENTSU_ANKAN :		tmp_fu += 16 ;	break ;
		}

		if ( is_19jihai( pYaku->mentsu[ i ].hai ) ) tmp_fu <<= 1 ;

		mentsu_fu	+= tmp_fu ;
	}

	//[ vȂ +2 ]
	if ( is_yakuhai( pYaku->atama, Bakaze(), pYaku->Jikaze() ) )	mentsu_fu += 2 ;



	//[ ҂ɂ ]
	switch ( pYaku->machi_type )
	{
	case MACHI_TANKI :
	case MACHI_KANCHAN :
	case MACHI_PENCHAN :	machi_fu = 2 ;	break ;
	default :				machi_fu = 0 ;
	}

	if ( ! pYaku->IsRon() )	// ̃AK+2
	{
		// st ̏ꍇ́Ć{Q ͂ȂI
		if ( ! pYaku->HasPinfu() )
		{
			machi_fu += 2 ;
		}

		// ́{PR{v ͍v U  ɂȂ悤ɂI
		if ( pYaku->machi_type == MACHI_TANKI )
		{
			if ( is_yakuhai( pYaku->atama, Bakaze(), pYaku->Jikaze() ) )
			{
				machi_fu += 2 ;
			}
		}
	}


	//[ v ] 
	pYaku->fu = base_fu + mentsu_fu + machi_fu ;
	
	// foO
	pYaku->base_fu		= base_fu ;
	pYaku->mentsh_fu	= mentsu_fu ;
	pYaku->machi_fu		= machi_fu ;
}



//====================================================================================
//
//	f[^ 瓾_𓾂D
//
//====================================================================================
long	Hantei::CalcScoreFromYakuData( const YakuData & yaku ) 
{
	// Ύq `
	if ( yaku.IsChitoiForm() )
	{
		if ( yaku.yakuman_num > 0 )	// 𖞂̏ꍇ
		{
			return ::GetScore( 13, 20, yaku.IsOya() ) * yaku.yakuman_num ;
		}

		if ( yaku.fan >= 5 ) return ::GetScore( yaku.fan, 20, yaku.IsOya() ) ;
		if ( yaku.fan == 4 ) return ( yaku.IsOya() )? 9600 : 6400 ;
		if ( yaku.fan == 3 ) return ( yaku.IsOya() )? 4800 : 3200 ;
		if ( yaku.fan == 2 ) return ( yaku.IsOya() )? 2400 : 1600 ;
	}
	// PSʎq `
	else
	{
		if ( yaku.yakuman_num > 0 )	// 𖞂̏ꍇ
		{
			return ::GetScore( 13, 20, yaku.IsOya() ) * yaku.yakuman_num ;
		}
		else
		{
			return ::GetScore( yaku.fan, yaku.fu, yaku.IsOya() ) ;
		}
	}

	return 0 ;
}


//====================================================================================
//
//	vqXgO쐬
//
//====================================================================================
void	Hantei::MakeHistogram( char * pHist, const TehaiData & tehai ) 
{
	int i ;

	for ( i=0 ; i < 34 ; ++ i )					// qXgOZbg
	{
		pHist[ i ] = 0 ;
	}
	
	for ( i=0 ; i < tehai.tehai_num ; ++i )		// vǉD
	{
		pHist[ tehai.tehai[ i ] ] ++ ;
	}

	if ( tehai.HasTsumohai() )					// cvȂ\ǉD
	{
		pHist[ tehai.Tsumohai() ] ++ ;
	}
}



//====================================================================================
//
//	vf[^AK`ɂȂĂ邩ǂ̃`FbND
//	PłAKɂȂĂ΁CÎŁC
//	Sɒׂ͑D
//	v`FbNȂ񂩂ŎgpD
//
//====================================================================================
BOOL	Hantei::FastCheckAgariForm( const TehaiData & tehai )
{
	if ( CheckKokushi( tehai ) ) return TRUE ;
	if ( CheckChitoitsu( tehai ) ) return TRUE ;
	if ( FastCheckNormalForm_KotsuMain( tehai ) ) return TRUE ;
	if ( FastCheckNormalForm_ShuntsuMain( tehai ) ) return TRUE ;

	return FALSE ;
}


//====================================================================================
//
//	𔻒sD
//
//	vf[^CłĂ邩ǂ`FbNC
//	oĂꍇ́Cō̎c܂D
//
//	[߂l]
//	TRUE	: AǨ`ɂȂĂ܂
//	FALSE	: ܂
//
//====================================================================================
BOOL	Hantei::YakuHantei( const TehaiData & inTehai, BOOL is_ron, 
							BOOL is_haitei, BOOL is_rinshan, BOOL is_chankan )
{
	MachiList	machi_list ;
	YakuList	yaku_list ;
	AgariList	agari_list ;

	machi_list.clear() ;
	yaku_list.clear() ;
	agari_list.clear() ;


	TehaiData	tehai = inTehai ;

	tehai.is_ron = is_ron ;	//[   c Ŕ肪ς邩 ]


	//[ mǒo ]
	BOOL exist_kokushi = KokushiHanteiRoutine( &yaku_list, tehai, is_ron ) ;

	//[ Ύq ̌o ]
	if ( ! exist_kokushi )
	{
		BOOL chitoi_only = ChitoiHanteiRoutine( &yaku_list, tehai, is_ron ) ;
	
		//[ PSʎq ^̌o ]
		if ( ! chitoi_only )
		{
			NormalHanteiRoutine( &yaku_list, tehai, is_ron ) ;
		}
	}

	// ܂łŁCN肤PSʎq{҂^Cv
	// 񋓂Ă͂łD

	if ( yaku_list.size() == 0 )	return FALSE ;



	//[ f[^Ƃɐmɖ𔻒 ]
	//[ ʂǉ ]
	//[ vZ ]
	//[ _oI ]
	int j, k ;

	for ( j=0 ; j < yaku_list.size() ; ++j )
	{
		YakuData * pYaku = &yaku_list[ j ] ;


		// AK̏ꍇ́CÍ𖾍ɂD
		// AKv  ÍɊ܂܂āC
		// o҂̏ꍇ̓f[^ύXĂD
		if ( pYaku->is_ron  &&  pYaku->machi_type == MACHI_SHANPON )
		{
			for ( k=0 ; k < pYaku->MentsuNum() ; ++k )
			{
				if ( pYaku->mentsu[ k ].IsAnko()  &&  
					 pYaku->mentsu[ k ].hai == tehai.Tsumohai() )
				{
					pYaku->mentsu[ k ].type = MENTSU_MINKO ;
					pYaku->minko_num ++ ;
					pYaku->anko_num -- ;
				}
			}
		}

		//[  𔻒肷 ]
		Hantei::SearchAndAddYaku( pYaku, tehai, is_haitei, is_rinshan, is_chankan ) ;

		//[ _vZ ]
		Hantei::SumYakuFan( pYaku ) ;
		Hantei::CalcFu( pYaku ) ;

		pYaku->score	= Hantei::CalcScoreFromYakuData( *pYaku ) ;
	}



	//[ ł_fJI ](_łʐႤꍇ̂ʂׂ)
	long max_score = 0 ;
	BYTE max_fan = 0 ;
	int max_index = 0 ;

	for ( j=0 ; j < yaku_list.size() ; ++j )
	{
	/*	
		char buf[256] ;
		::sprintf( buf, "=%d\nʐ=%d\n_=%d",  
						yaku_list[ j ].yaku_list.size(),
						yaku_list[ j ].fan,
						yaku_list[ j ].score ) ;
		::ErrorMessage( buf ) ;
	*/
		
		if ( max_score < yaku_list[ j ].score )
		{
			max_fan	  = yaku_list[ j ].fan ;
			max_score = yaku_list[ j ].score ;
			max_index = j ;
		}
		else if ( max_score == yaku_list[ j ].score )
		{
			if ( max_fan < yaku_list[ j ].fan )
			{
				max_fan	  = yaku_list[ j ].fan ;
				max_score = yaku_list[ j ].score ;
				max_index = j ;
			}
		}


		/*
		if ( max_score <= yaku_list[ j ].score )
		{
			max_fan	  = yaku_list[ j ].fan ;
			max_score = yaku_list[ j ].score ;
			max_index = j ;
		}
		else if ( max_score == yaku_list[ j ].score )
		{
			if ( max_fan < yaku_list[ j ].fan )
			{
				max_fan	  = yaku_list[ j ].fan ;
				max_score = yaku_list[ j ].score ;
				max_index = j ;
			}
		}
		*/
	}


	//[ łfJC hvZ(𖞂Ȃꍇ̂) ]
	// ʐčČvZD
	if ( yaku_list[ max_index ].yakuman_num == 0 )
	{
		yaku_list[ max_index ].dora_num = Hantei::CountDora( tehai, Mahjong::GetDoraIndicators() ) ;
		yaku_list[ max_index ].fan		+= yaku_list[ max_index ].dora_num ;
		yaku_list[ max_index ].score	= Hantei::CalcScoreFromYakuData( yaku_list[ max_index ] ) ; 
	}


	//[ łfJCԂ ]
	if ( yaku_list.size() > 0 )
	{
		s_Yaku	= yaku_list[ max_index ] ;
		return TRUE ;
	}
	else
	{
		return FALSE ;
	}
	return FALSE ;
}




//====================================================================================
//
//	f[^CCΒǉD
//
//	 s鎞_ŁCΎq`PSʎq`ĂȂƂ܂D
//
//	ɖ𖞂̎肩TD
//	𖞂Płꍇ́C𖞂̎肾TďID
//	𖞂܂܂Ȃꍇ̂݁C̖TD
//
//====================================================================================
void	Hantei ::SearchAndAddYaku( YakuData * pYaku, const TehaiData & tehai,
									BOOL is_haitei, BOOL is_rinshan, BOOL is_chankan )
{
	YakuData & yaku = *pYaku ;	// |C^ŏ̂hcl[


	// 𖞔][ 
	{
		// mo Fmo͊ɔ肳Ă܂D
		// ( mȍꍇ͑ɖ𖞂Ȃ͂ )
		if ( yaku.IsKokushiForm() )	
		{
			yaku.yakuman_num ++ ;
			return ;
		}

		// Va

		// na
		
		// Ύq̏ꍇ𖞂́CF̂݁D
		// CΎq`ŎF玵Ύq艺đID

		if ( yaku.IsChitoiForm() )
		{
			// F(Ύq`)
			if ( Hantei::CheckTsuiso( tehai, yaku, TRUE ) )
			{
				yaku.AddYaku( YAKU_TSUISO ) ;
				yaku.yakuman_num ++ ;

				yaku.DeleteYaku( YAKU_CHITOITSU ) ;
				return ;
			}
		}
		else
		{
			// F
			if ( Hantei::CheckTsuiso( tehai, yaku, yaku.IsChitoiForm() ) )
			{
				yaku.AddYaku( YAKU_TSUISO ) ;
				yaku.yakuman_num ++ ;
			}

			// lÍ
			if ( Hantei::CheckSuanko( yaku ) )
			{
				yaku.AddYaku( YAKU_SUANKO ) ;
				yaku.yakuman_num ++ ;
			}

			// ΈF
			if ( Hantei::CheckRyuiso( yaku ) )			
			{
				yaku.AddYaku( YAKU_RYUISO ) ;
				yaku.yakuman_num ++ ;
			}

			// laCla
			if ( Hantei::CheckDaisushi( yaku ) )
			{
				yaku.AddYaku( YAKU_DAISUSHI ) ;
				yaku.yakuman_num ++ ;
			}
			else if ( Hantei::CheckShousushi( yaku ) )
			{
				yaku.AddYaku( YAKU_SYOUSUSHI ) ;
				yaku.yakuman_num ++ ;
			}

			// O
			if ( Hantei::CheckDaisangen( yaku ) )
			{
				yaku.AddYaku( YAKU_DAISANGEN ) ;
				yaku.yakuman_num ++ ;
			}

			// @
			if ( Hantei::CheckChuren( yaku ) )
			{
				yaku.AddYaku( YAKU_CHUREN ) ;
				yaku.yakuman_num ++ ;
			}

			// V
			if ( Hantei::CheckChinroto( yaku ) )
			{
				yaku.AddYaku( YAKU_CHINROTO ) ;
				yaku.yakuman_num ++ ;
			}

			// lȎq
			if ( Hantei::CheckSukantsu( yaku ) )
			{
				yaku.AddYaku( YAKU_SUKANTSU ) ;
				yaku.yakuman_num ++ ;
			}
		}// end if ( Ύq^ȊO )
	}
	// ܂Ŗ𖞔][ 

	// 𖞂Pȏ゠ȂCc̏Ȗ͌oȂD
	if ( yaku.yakuman_num > 0 ) return ;


	// [`n
	switch ( tehai.GetLeechiType() )
	{
	case LEECHI_LEECHI_IPPATSU :
		yaku.AddYaku( YAKU_LEECHI ) ;
		yaku.AddYaku( YAKU_IPPATSU ) ;
		break ;
	case LEECHI_LEECHI :
		yaku.AddYaku( YAKU_LEECHI ) ;
		break ;
	case LEECHI_DOUBLEE_IPPATSU :	
		yaku.AddYaku( YAKU_DOUBLEE ) ;
		yaku.AddYaku( YAKU_IPPATSU ) ;
		break ;
	case LEECHI_DOUBLEE :
		yaku.AddYaku( YAKU_DOUBLEE ) ;
		break ;
	}

	// O͘a
	if ( yaku.IsMenzen()  &&  ! yaku.IsRon() )	yaku.AddYaku( YAKU_TSUMO ) ;

	// Cꝝ
	if ( is_haitei )
	{
		if ( yaku.IsRon() )	yaku.AddYaku( YAKU_HOUTEI ) ;
		else				yaku.AddYaku( YAKU_HAITEI ) ;
	}
	// J
	else if ( is_rinshan )
	{
		if ( ! yaku.IsRon() )	yaku.AddYaku( YAKU_RINSHANKAIHOU ) ;
	}
	// 
	else if ( is_chankan )
	{
		if ( yaku.IsRon() )		yaku.AddYaku( YAKU_CHANKAN ) ;
	}


	// fI
	if ( Hantei::CheckTanyao( tehai ) )			yaku.AddYaku( YAKU_TANYAO ) ;


	// ΎqṕCVCF ̔
	if ( yaku.IsChitoiForm() )
	{
		if ( Hantei::CheckHonitsu( tehai, yaku, TRUE ) )	yaku.AddYaku( YAKU_HONITSU ) ;
		if ( Hantei::CheckHonro( tehai, yaku, TRUE ) )		yaku.AddYaku( YAKU_HONRO ) ;
	}


	// Ύq `ꍇ͂܂ŁI Ƃ́CΎqł͔ȂD
	if ( yaku.IsChitoiForm() )	return ;


	// v
	yaku.yakuhai_num	= CountYakuhai( yaku ) ;


	// a
	if ( CheckPinfu( yaku ) )			
	{
		yaku.has_pinfu	= TRUE ;	// st͔肪ꂾD	
		yaku.AddYaku( YAKU_PINFU ) ;
	}

	// tCt
	if ( Hantei::CheckRyanpeiko( yaku ) )		yaku.AddYaku( YAKU_RYANPEIKO ) ;
	else if ( Hantei::CheckIpeiko( yaku ) )		yaku.AddYaku( YAKU_IPEIKO ) ;


	// OF
	if ( Hantei::CheckSansyoku( yaku ) )		yaku.AddYaku( YAKU_SANSYOKU ) ;

	// OF
	if ( Hantei::CheckSansyokuDoukoku( yaku ) )	yaku.AddYaku( YAKU_SANSYOKUDOUKOKU ) ;

	// Cʊ
	if ( Hantei::CheckIkki( yaku ) )			yaku.AddYaku( YAKU_IKKI ) ;

	// ΁Xa (+V) 
	if ( Hantei::CheckToitoi( yaku ) )	
	{
		yaku.AddYaku( YAKU_TOITOI ) ;

		if ( Hantei::CheckHonro( tehai, yaku, FALSE ) )	yaku.AddYaku( YAKU_HONRO ) ;
	}

	// F or F
	if ( Hantei::CheckChinitsu( yaku ) )					yaku.AddYaku( YAKU_CHINITSU ) ;
	else if ( Hantei::CheckHonitsu( tehai, yaku, FALSE ) )	yaku.AddYaku( YAKU_HONITSU ) ;

	// S or S
	if ( Hantei::CheckJyunchan( yaku ) )		yaku.AddYaku( YAKU_JYUNCHAN ) ;
	else if ( Hantei::CheckChanta( yaku ) )		yaku.AddYaku( YAKU_CHANTA ) ;

	// O
	if ( Hantei::CheckShousangen( yaku ) )	
	{
		yaku.AddYaku( YAKU_SYOUSANGEN ) ;
		yaku.yakuhai_num	-= 2 ;	
	}

	// OÍ
	if ( Hantei::CheckSananko( yaku ) )			yaku.AddYaku( YAKU_SANANKO ) ;

	// OȎq
	if ( Hantei::CheckSankantsu( yaku ) )		yaku.AddYaku( YAKU_SANKANTSU ) ;


/*
	char str[500] ="" ;
	char buf[256];

	for ( int i=0 ; i < yaku.YakuNum() ; ++i)
	{
		::sprintf( buf, "%s\n", ::GetYakuName( yaku.GetYaku( i ) ) ) ;
		::strcat( str, buf ) ;
	}
	ErrorMessage( str ) ;
*/
}



//------------------------------------------------------------------------------------
//
//	mo̔Tu[`
//
//	moȂCXgɖf[^ǉD
//
//	[߂l]
//	TRUE	Fmo
//	FALSE	Fmo
//
//------------------------------------------------------------------------------------
BOOL	Hantei::KokushiHanteiRoutine( YakuList * pYakuList, const TehaiData & tehai, BOOL is_ron )
{
	if ( ! tehai.IsMenzen() ) return FALSE ;

	if ( ! CheckKokushi( tehai ) )	return FALSE ;

	// 19vQƗp̃e[u
	BYTE tbl[13] = { 0, 8, 9, 17, 18, 26, 27, 28, 29, 30, 31, 32, 33 } ;

	// pqXgO
	char hist[ 34 ] ;
	Hantei::MakeHistogram( hist, tehai ) ;

	// 
	BYTE i, atama ;
	for ( i=0 ; i < 13 ; ++i )
	{
		if ( hist[ tbl[ i ] ] >= 2 )  
		{
			atama = i ;
			hist[ tbl[ i ] ] -- ;
			break ;
		}
	}
	if ( i == 13 ) return FALSE ;

	// Pł0̂̂_[
	for ( i=0 ; i < 13 ; ++i )
	{
		if ( hist[ tbl[ i ] ] <= 0 ) return FALSE ;
	}

	//[ ܂ł΍moII ]


	YakuData yaku ;
	yaku.Reset() ;

	//[ mo p̓ȃf[^Ă ]
	{
		yaku.atama			= atama ;			
		yaku.machi_type		= ( atama == tehai.Tsumohai() )? MACHI_TANKI : MACHI_TANKI ;
		yaku.is_menzen		= TRUE ;				// OȂƃ_D
		yaku.is_ron			= is_ron ;
		yaku.is_kokushi_form= TRUE ;
		yaku.jikaze			= tehai.Jikaze() ;
		yaku.yaku_list.push_back( YAKU_KOKUSHI ) ;

		pYakuList->push_back( yaku ) ;	// XgɒǉII
	}

	return TRUE ;
}


//------------------------------------------------------------------------------------
//
//	Ύq p胋[`
//
//	ΎqȂCXgɖf[^ǉD
//	܂CΎq݂̂̏ꍇ́C
//	PSʎq̃[`͔΂Ă悢D
//
//	[߂l]
//	TRUE   : Ύq̂
//	FALSE  : ΎqȊO܂ނCΎqȂD
//
//------------------------------------------------------------------------------------
BOOL	Hantei::ChitoiHanteiRoutine( YakuList * pYakuList, const TehaiData & tehai, BOOL is_ron )
{


	//[ ΎqłȂ̂ŁCIII]
	if ( ! tehai.IsMenzen() ) return FALSE ;

	if ( ! CheckChitoitsu( tehai ) ) return FALSE ;


	// ܂łΎΎq
	YakuData yaku ;
	yaku.Reset() ;


	//[ Ύqp̓ȃf[^Ă ]
	{
		yaku.atama			= tehai.Tsumohai() ;	// ̓AKvɌ܂ĂII
		yaku.machi_type		= MACHI_TANKI ;			// PR҂Ɍ܂ĂI
		yaku.is_menzen		= TRUE ;				// OȂƃ_D
		yaku.is_ron			= is_ron ;
		yaku.is_chitoi_form	= TRUE ;				// Ύq͗O邩D
		yaku.jikaze			= tehai.Jikaze() ;
		yaku.yaku_list.push_back( YAKU_CHITOITSU ) ;


		pYakuList->push_back( yaku ) ;	// XgɒǉII
	}


	//
	//	Ύqp^[̂ɁC
	//	qĈPSʎqPȂꍇ́C
	//	SɏqXgAbvKv͖Ɣf܂D
	//
	if ( ! FastCheckNormalForm_ShuntsuMain( tehai ) ) return TRUE ;



	return FALSE ;
}



//------------------------------------------------------------------------------------
//
//	uPSʎqv^Cv̖𔻒胋[`
//
//------------------------------------------------------------------------------------
BOOL	Hantei::NormalHanteiRoutine( YakuList * pYakuList, const TehaiData & tehai, BOOL is_ron )
{
	AgariList	agari_list ;

	// qCƂAK^̒ǉ
	AddAgariForm_KotsuMain( &agari_list, tehai ) ;

	// qCƂAK^̒ǉ
	AddAgariForm_ShuntsuMain( &agari_list, tehai ) ;
	

	if ( agari_list.size() == 0 ) return FALSE ;


	//[ foreach( AK^ ) ]
	for (int j=0 ; j < agari_list.size() ; ++j )
	{
		MachiList	machi_list ;
		machi_list.clear() ;

		MakeMachiList( &machi_list, agari_list[ j ], tehai.Tsumohai() ) ;

		if ( machi_list.size() == 0 )
		{
			::ErrorMessage( "AK^Ȃ̂ɁC҂oł܂ł" ) ;
			return FALSE ;
		}

		//[ foreach( ҂ ) ]
		for (int k=0 ; k < machi_list.size() ; ++k )
		{
			// f[^쐬II
			YakuData	yaku ;
			yaku.Reset() ;

			yaku.Create( tehai, agari_list[ j ] ) ;
			yaku.machi_type	= machi_list[ k ] ;

			// XgɒǉD
			pYakuList->push_back( yaku ) ;
		}
	}

	return TRUE ;

}

//------------------------------------------------------------------------------------
//
//	oꂽPSʎq`uAK^vXgɒǉD(qC)
//
//------------------------------------------------------------------------------------
void	Hantei::AddAgariForm_KotsuMain( AgariList * pAgariList, const TehaiData & tehai )
{
	int i , times ;
	char	atama = -1 ;
	char	kotsu_num=0, shuntsu_num=0 ;
	char	kotsu[ 4 ],  shuntsu[ 4 ] ;
	char	hist[ 34 ] ;

	// ߂
	// q𔲂o
	// q𔲂o

	for (char atama_kouho = 0 ; atama_kouho < 34 ; ++atama_kouho )
	{
		MakeHistogram( hist, tehai ) ;

		atama		= -1 ;
		kotsu_num	= 0 ;
		shuntsu_num	= 0 ;

		// ܂͐̌
		if ( hist[ atama_kouho ] < 2 ) continue ;

		// ɂȂ肻ȂꉞɂĂ
		hist[ atama_kouho ] -= 2 ;
		atama	= atama_kouho ;

		for ( i=0 ; i < 34 ; ++ i )
		{
			//[ ܂ q ̌o ]
			if ( hist[ i ] >= 3 )			
			{
				hist[ i ] -= 3 ;
				kotsu[ kotsu_num++ ] = i ;
			}

			//[  q ̌o ]
			if ( i >= 27 ) continue ;
			if ( i % 9 >= 7 ) continue ;

			for ( times=0 ; times < 2 ; ++times )
			{	
				if ( ( hist[ i + 0 ] > 0 ) &&
					 ( hist[ i + 1 ] > 0 ) &&
					 ( hist[ i + 2 ] > 0 )    )
				{
					hist[ i + 0 ] -- ;
					hist[ i + 1 ] -- ;
					hist[ i + 2 ] -- ;

					shuntsu[ shuntsu_num++ ] = i ;
				}
			}	
		}

		// CqCq𒲂ׁCɂȂĂ邩`FbN
		if ( ( atama != -1 ) && ( kotsu_num + shuntsu_num  == 4 - tehai.NakihaiNum() ) ) 
		{	
			AgariForm	agari ;
			agari.Reset() ;

			agari.atama			= atama ;

			agari.kotsu_num		= kotsu_num ;
			for ( i=0 ; i < kotsu_num ; ++i )
			{
				agari.kotsu[ i ] = kotsu[ i ] ;
			}

			agari.shuntsu_num	= shuntsu_num ;
			for ( i=0 ; i < shuntsu_num ; ++i )
			{
				agari.shuntsu[ i ] = shuntsu[ i ] ;
			}


			//[ AK^ǉ ]

			pAgariList->push_back( agari ) ;
		}
	}
}

//------------------------------------------------------------------------------------
//
//	oꂽPSʎq`uAK^vXgɒǉD(qC)
//
//------------------------------------------------------------------------------------
void	Hantei::AddAgariForm_ShuntsuMain( AgariList * pAgariList, const TehaiData & tehai ) 
{

	int i , times ;
	char	atama = -1 ;
	char	kotsu_num = 0 ;
	char	kotsu[ 4 ] ;
	char	shuntsu_num = 0;
	char	shuntsu[ 4 ] ;
	char	hist[ 34 ] ;

	// ߂
	// q𔲂o
	// q𔲂o

	for (char atama_kouho = 0 ; atama_kouho < 34 ; ++atama_kouho )
	{
		MakeHistogram( hist, tehai ) ;

		atama		= -1 ;
		kotsu_num	= 0 ;
		shuntsu_num	= 0 ;

		// ܂͐̌
		if ( hist[ atama_kouho ] < 2 ) continue ;

		// ɂȂ肻ȂꉞɂĂ
		hist[ atama_kouho ] -= 2 ;
		atama	= atama_kouho ;


		for ( i=0 ; i < 34 ; ++ i )
		{
			if ( hist[ i ] <= 0 ) continue ;

			// ɏq
			if ( ( i <= HAI_9SOU ) && ( i % 9 <=6 ) )
			{
				for ( times=0 ; times < 4 ; ++times )
				{	
					if ( ( hist[ i + 0 ] > 0 ) &&
						 ( hist[ i + 1 ] > 0 ) &&
						 ( hist[ i + 2 ] > 0 )    )
					{
						hist[ i + 0 ] -- ;
						hist[ i + 1 ] -- ;
						hist[ i + 2 ] -- ;

						shuntsu[ shuntsu_num++ ] = i ;
					}
				}	
			}

			// ܂ōq
			if ( hist[ i ] >= 3 )			
			{
				hist[ i ] -= 3 ;
				kotsu[ kotsu_num++ ] = i ;
			}
		}


		// CqCq𒲂ׁCɂȂĂ邩`FbN
		if ( ( atama != -1 ) && ( kotsu_num + shuntsu_num  == 4 - tehai.NakihaiNum() ) ) 
		{	
			AgariForm	agari ;
			agari.Reset() ;

			agari.atama			= atama ;

			agari.kotsu_num		= kotsu_num ;
			for ( i=0 ; i < kotsu_num ; ++i )
			{
				agari.kotsu[ i ] = kotsu[ i ] ;
			}

			agari.shuntsu_num	= shuntsu_num ;
			for ( i=0 ; i < shuntsu_num ; ++i )
			{
				agari.shuntsu[ i ] = shuntsu[ i ] ;
			}


			//[ AK^ǉ ]

			pAgariList->push_back( agari ) ;
		}
	}

}






//====================================================================================
//
//	PSʎq̌`ɂȂĂ邩𒲂ׂD
//	Płꍇ͑ID
//	uvvǂׂƂɖɗD
//
//====================================================================================
//------------------------------------------------------------------------------------
//
//	qCŒׂ
//
//------------------------------------------------------------------------------------
BOOL	Hantei::FastCheckNormalForm_KotsuMain( const TehaiData & tehai )
{
	int i , times ;
	char	atama = -1 ;
	char	kotsu_num=0, shuntsu_num=0 ;
	char	kotsu[ 4 ],  shuntsu[ 4 ];
	char	hist[ 34 ] ;

	// ߂
	// q𔲂o
	// q𔲂o

	for (char atama_kouho = 0 ; atama_kouho < 34 ; ++atama_kouho )
	{
		Hantei::MakeHistogram( hist, tehai ) ;

		atama		= -1 ;
		kotsu_num	= 0 ;
		shuntsu_num	= 0 ;

		// ܂͐̌
		if ( hist[ atama_kouho ] < 2 ) continue ;

		// ɂȂ肻ȂꉞɂĂ
		hist[ atama_kouho ] -= 2 ;
		atama	= atama_kouho ;


		for ( i=0 ; i < 34 ; ++ i )
		{
			if ( hist[ i ] <= 0 ) continue ;

			//[ ܂ q ̌o ]
			if ( hist[ i ] >= 3 )			
			{
				hist[ i ] -= 3 ;
				kotsu[ kotsu_num++ ] = i ;
			}

			//[  q ̌o ]
			if ( i >= 27 ) continue ;
			if ( i % 9 >= 7 ) continue ;

			for ( times=0 ; times < 2 ; ++times )
			{	
				if ( ( hist[ i + 0 ] > 0 ) &&
					 ( hist[ i + 1 ] > 0 ) &&
					 ( hist[ i + 2 ] > 0 )    )
				{
					hist[ i + 0 ] -- ;
					hist[ i + 1 ] -- ;
					hist[ i + 2 ] -- ;

					shuntsu[ shuntsu_num++ ] = i ;
				}
			}	
		}


		// CqCq𒲂ׁCɂȂĂ邩`FbN
		if ( ( atama != -1 ) && ( kotsu_num + shuntsu_num  == 4 - tehai.NakihaiNum() ) ) 
		{	
			return TRUE ;
		}
	}

	return FALSE ;
}
//------------------------------------------------------------------------------------
//
//	qCŒׂD
//
//------------------------------------------------------------------------------------
BOOL	Hantei::FastCheckNormalForm_ShuntsuMain( const TehaiData & tehai )
{
	int i , times ;
	char	atama = -1 ;
	char	kotsu_num = 0 ;
	char	kotsu[ 4 ] ;
	char	shuntsu_num = 0;
	char	shuntsu[ 4 ] ;
	char	hist[ 34 ] ;

	// ߂
	// q𔲂o
	// q𔲂o

	for (char atama_kouho = 0 ; atama_kouho < 34 ; ++atama_kouho )
	{
		Hantei::MakeHistogram( hist, tehai ) ;

		atama		= -1 ;
		kotsu_num	= 0 ;
		shuntsu_num	= 0 ;

		// ܂͐̌
		if ( hist[ atama_kouho ] < 2 ) continue ;

		// ɂȂ肻ȂꉞɂĂ
		hist[ atama_kouho ] -= 2 ;
		atama	= atama_kouho ;


		for ( i=0 ; i < 34 ; ++ i )
		{
			if ( hist[ i ] <= 0 ) continue ;

			// ɏq
			if ( ( i <= HAI_9SOU ) && ( i % 9 <=6 ) )
			{
				for ( times=0 ; times < 4 ; ++times )
				{	
					if ( ( hist[ i + 0 ] > 0 ) &&
						 ( hist[ i + 1 ] > 0 ) &&
						 ( hist[ i + 2 ] > 0 )    )
					{
						hist[ i + 0 ] -- ;
						hist[ i + 1 ] -- ;
						hist[ i + 2 ] -- ;

						shuntsu[ shuntsu_num++ ] = i ;
					}
				}	
			}

			// ܂ōq
			if ( hist[ i ] >= 3 )			
			{
				hist[ i ] -= 3 ;
				kotsu[ kotsu_num++ ] = i ;
			}
		}


		// CqCq𒲂ׁCɂȂĂ邩`FbN
		if ( ( atama != -1 ) && ( kotsu_num + shuntsu_num  == 4 - tehai.NakihaiNum() ) ) 
		{	
			return TRUE ;
		}
	}

	return FALSE ;
}

//------------------------------------------------------------------------------------
//
//	qCŃ`FbN
//
//------------------------------------------------------------------------------------


//====================================================================================
//
//	h̐𐔂
//
//====================================================================================
BYTE	Hantei::CountDora( const TehaiData & tehai, const char * pDoraIndicator ) 
{
	char dora_hist[ 34 ], tehai_hist[ 34 ] ;
	::memset(  dora_hist, 0, sizeof(char)*34 ) ;
	::memset( tehai_hist, 0, sizeof(char)*34 ) ;

	const tbl[ 34 ] = // h\v  hv  ւ̕ϊe[u
	{
		 1,  2,  3,  4,  5,  6,  7,  8,  0,
		10, 11, 12, 13, 14, 15, 16, 17,  9,
		19, 20, 21, 22, 23, 24, 25, 26, 18,
		28, 29, 30, 27,
		32, 33, 31
	};

	// h\vf[^Ch̃qXgO߂D
	int i ;
	for ( i=0 ; i < DORA_MAX ; ++i )
	{
		if ( pDoraIndicator[ i ] >= 0 )
		{
			dora_hist[ tbl[ pDoraIndicator[ i ] ] ] ++ ;
		}
	}

	// vf[^CṽqXgOD
	if ( tehai.HasTsumohai() ) tehai_hist[ tehai.Tsumohai() ] ++ ;
	
	for ( i=0 ; i < tehai.tehai_num ; ++i )
	{
		tehai_hist[ tehai.tehai[i] ] ++ ;
	}

	for ( i=0 ; i < tehai.NakihaiNum() ; ++i )
	{
		char hai = tehai.nakihai[i].hai ;

		switch ( tehai.nakihai[ i ].type )
		{
		case NAKI_ANKAN :
		case NAKI_MINKAN :
			tehai_hist[ hai ] ++ ;
		case NAKI_PON :
			tehai_hist[ hai ] += 3;
			break ;
		case NAKI_CHI :
			tehai_hist[ hai + 0 ] ++ ;
			tehai_hist[ hai + 1 ] ++ ;
			tehai_hist[ hai + 2 ] ++ ;
			break ;
		}
	}

	// h߂
	char dora_count = 0 ;

	for ( i=0 ; i < 34 ; ++i )
	{
		if ( dora_hist[i] > 0  &&  tehai_hist[i] > 0 )
		{
			dora_count += dora_hist[i] * tehai_hist[i] ;
		}
	}

	return dora_count ;
}



//====================================================================================
//
//	҂Xg쐬n
//
//====================================================================================
//------------------------------------------------------------------------------------
//
//	AK^ƃAKvC҂Xg쐬D
//
//	[]
//	pMachiList		: ҂Xgւ̃|C^
//	agari_form		: AK^
//	agari_hai		: ̔v or vD
//
//------------------------------------------------------------------------------------
void	Hantei ::MakeMachiList( MachiList * pMachiList, 
								 const AgariForm & agari_form, 
								 const char agari_hai ) 
{
	int i ;

	if ( is_suujihai( agari_hai ) )
	{
		// ʑ҂ OR Ӓ҂ OR Ɠ҂ ̌o
		for ( i=0 ; i < agari_form.ShuntsuNum() ; ++i )
		{
			// ̒iKŁC shuntsu ɂ WvCXv܂ނ̂͂Ȃł傤ˁD

			if ( agari_form.shuntsu[ i ] == agari_hai - 2 )
			{
				if ( 0 == agari_form.shuntsu[ i ] % 9 )		// Ӓ(PQRv)
				{
					pMachiList->push_back( MACHI_PENCHAN ) ;
				}
				else									// 
				{
					pMachiList->push_back( MACHI_RYANMEN ) ;
				}
			}
			if( agari_form.shuntsu[ i ] == agari_hai - 0 )
			{
				if ( 6 == agari_form.shuntsu[ i ] % 9 )		// Ӓ(VWXv)
				{
					pMachiList->push_back( MACHI_PENCHAN ) ;
				}
				else									// 
				{
					pMachiList->push_back( MACHI_RYANMEN ) ;
				}
			}
			if ( agari_form.shuntsu[ i ] == agari_hai - 1 )	// Ɠ
			{
				pMachiList->push_back( MACHI_KANCHAN ) ;
			}
		}
	}
	// o҂ ̌o
	for ( i=0 ; i < agari_form.KotsuNum() ; ++i )
	{
		if ( agari_form.kotsu[ i ] == agari_hai )
		{
			pMachiList->push_back( MACHI_SHANPON ) ;
		}
	}
	// PR҂ ̌o
	if ( agari_form.atama == agari_hai ) pMachiList->push_back( MACHI_TANKI ) ;



	//[ d̂҂菜 ]
	Hantei::RemoveOverlappedMachi( pMachiList ) ;

}



//------------------------------------------------------------------------------------
//
//	҂Xgd҂
//
//	҂̎ނ́C҂CʁCƓCӒCoCPRĈUށD
//
//------------------------------------------------------------------------------------
void Hantei::RemoveOverlappedMachi( MachiList * pMachiList )
{
	BYTE	i, hist[ 6 ] ;
	::memset( hist, 0, sizeof(BYTE)*6 ) ;

	for ( i=0 ; i < pMachiList->size() ; ++i )
	{
		if ( (*pMachiList)[i] >= 6 ) (*pMachiList)[i] = MACHI_NON ;
		
		hist[ (*pMachiList)[i] ] ++ ;
	}

	pMachiList->clear() ;

	for (int machi_type=1 ; machi_type < 6 ; ++machi_type )
	{
		if ( hist[ machi_type ] != 0 )
		{
			pMachiList->push_back( machi_type ) ;
		}
	}	
}







//====================================================================================
//
//	Ƃɂ̖邩ǂ`FbND
//
//	ΎqƕĐȊÓC
//	Plʎq̌`ɂȂĂƔ肳ꂽƂ
//	̃`FbNsƁD
//
//====================================================================================


//------------------------------------------------------------------------------------
//
//	umoṽ`FbN
//	́CPSʎqƂ͕ʂɒׂ
//
//	PDOł邱ƁD
//	QD19vꂼPȏ܂ł邱ƁD
//	RD̂1ނ͓ɂȂ邱ƁD
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckKokushi( const TehaiData & tehai )
{
	if ( ! tehai.IsMenzen() ) return FALSE ;

	// 19vQƗp̃e[u
	BYTE tbl[13] = { 0, 8, 9, 17, 18, 26, 27, 28, 29, 30, 31, 32, 33 } ;

	// pqXgO
	char hist[ 34 ] ;
	Hantei::MakeHistogram( hist, tehai ) ;

	// 
	int i ;
	for ( i=0 ; i < 13 ; ++i )
	{
		if ( hist[ tbl[ i ] ] >= 2 )  hist[ tbl[ i ] ] -- ;
	}

	// Pł0̂̂_[
	for ( i=0 ; i < 13 ; ++i )
	{
		if ( hist[ tbl[ i ] ] <= 0 ) return FALSE ;
	}

	// ܂ŗOKI
	return TRUE ;
}

//------------------------------------------------------------------------------------
//
//	uΎqṽ`FbN
//	́CPSʎqƂ͕ʂɃ`FbND
//
//	PDOł邱ƁD
//	QDSĂQ邱ƁD
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckChitoitsu( const TehaiData & tehai )
{
	if ( ! tehai.IsMenzen() ) return FALSE ;
	if ( ( tehai.tehai_num != 13 ) || ( ! is_hai( tehai.Tsumohai() ) ) ) return FALSE ;

	// pqXgO
	char hist[ 34 ] ;
	Hantei::MakeHistogram( hist, tehai ) ;


	for (int i=0 ; i < 34 ; ++i )
	{
		if ( !( ( hist[ i ] == 0 ) || ( hist[ i ] == 2 ) ) ) return FALSE ;
	}

	return TRUE ;
}




//------------------------------------------------------------------------------------
//
//	ufIvɂȂĂ邩
//
//	ufIv́uΎqvƓɋN肤D
//
//	PDv܂܂Ȃ
//	QDPCXv܂܂Ȃ
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckTanyao( const TehaiData & tehai )
{
	int i ;
	
	// v̕ɂPXv܂łȂH
	for ( i=0 ; i < tehai.tehai_num ; ++i )
	{
		if ( is_19jihai( tehai.tehai[ i ] )	)	return FALSE ;
	}

	// v̕ɂPXv܂łȂH
	for ( i=0 ; i < tehai.NakihaiNum() ; ++i )
	{
		if ( tehai.nakihai[ i ].IsChi() )	// `[̏ꍇ	
		{
			char hai = tehai.nakihai[ i ].hai % 9 ;

			if ( ! ( hai == 0 || hai == 6 ) ) return FALSE ;
		}
		else								// |CJ̏ꍇ
		{
			if ( is_19jihai( tehai.nakihai[ i ].hai ) ) return FALSE ;	
		}
	}

	return TRUE ;
}




//------------------------------------------------------------------------------------
//
//	uVṽ`FbN
//
//	̎śCΎq 邢 ΁Xa ɍsƁD
// 
//	PDKCΎq  ΁Xa ƕȂ̂ PXvȊO܂ނǂŔ
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckHonro( const TehaiData & tehai, const YakuData & yaku, BOOL chitoi ) 
{
	int i ;

	if ( chitoi )	// Ύq ̏ꍇ
	{
		for ( i=0 ; i < tehai.tehai_num ; ++i )
		{
			if ( ! is_19jihai( tehai.tehai[ i ] ) ) return FALSE ;
		}
		return TRUE ;
	}

	else // ΁Xa ̏ꍇ
	{
		if ( ! is_19jihai( yaku.atama ) ) return FALSE ;

		for ( i=0 ; i < yaku.MentsuNum() ; ++i )
		{
			if ( ! is_19jihai( yaku.mentsu[ i ].hai ) ) return FALSE ;
		}

		return TRUE ;
	}
}


//------------------------------------------------------------------------------------
//
//	uFvǂ`FbND
//
//	
//	PDv  v͂Pނ̂݁I
//	
//	Ύq`̏ꍇ́CɎΎq^ɂȂĂ邱ƂOɂĂ܂D
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckHonitsu( const TehaiData & tehai, const YakuData & yaku, BOOL chitoi )
{
	char hist[ 34 ], i ;
	::memset( hist, 0, sizeof(char)*34 ) ;

	//[ Ύq ^̏ꍇ ]
	if ( chitoi )
	{
		Hantei::MakeHistogram( hist, tehai ) ;
	}
	//[ Ύq ^łȂꍇ ]
	else
	{
		// q낤q낤ƂɂqXgOɓ˂ށD
		for ( i=0 ; i < yaku.MentsuNum() ; ++i )
		{
			hist[ yaku.mentsu[ i ].hai ] ++ ;
		}
		hist[ yaku.atama ] ++ ;
	}


	// ꂼ̐߂
	char	jihai_num = 0 ;
	char	wanzu_num = 0 ;
	char	pinzu_num = 0 ;
	char	souzu_num = 0 ;

	for ( i=HAI_1WAN ; i <= HAI_9WAN ; ++i )	wanzu_num += hist[ i ] ;
	for ( i=HAI_1PIN ; i <= HAI_9PIN ; ++i )	pinzu_num += hist[ i ] ;
	for ( i=HAI_1SOU ; i <= HAI_9SOU ; ++i )	souzu_num += hist[ i ] ;
	for ( i=HAI_TON  ; i <= HAI_CHUN ; ++i )	jihai_num += hist[ i ] ;

	// v͂PނȁH
	if ( wanzu_num > 0 )
	{
		if ( ( pinzu_num == 0 ) && ( souzu_num == 0 ) )	return TRUE ;
	}
	else if ( pinzu_num > 0 )
	{
		if ( ( wanzu_num == 0 ) && ( souzu_num == 0 ) ) return TRUE ;
	}
	else if ( souzu_num > 0 )
	{
		if ( ( wanzu_num == 0 ) && ( pinzu_num == 0 ) ) return TRUE ;
	}

	return FALSE ;
}


//------------------------------------------------------------------------------------
//
//	uFṽ`FbN
//
//	Ύq{F̏ꍇ́CΎq ɍsƁD
//
//	PD΁Xa  Ύq nłD
//	QDvSĎvłD
//	
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckTsuiso( const TehaiData & tehai, const YakuData & yaku, BOOL chitoi )
{
	//[ Ύq ^̌ ]
	if ( chitoi )
	{
		if ( ! is_jihai( tehai.Tsumohai() ) ) return FALSE ;

		for (int k=0 ; k < tehai.tehai_num ; ++k )
		{
			if ( ! is_jihai( tehai.tehai[ k ] ) ) return FALSE ;
		}

		return TRUE ;
	}


	//[ ΁Xa ^̌ ]

	if ( yaku.AnkoNum() + yaku.PonNum() + 
		 yaku.AnkanNum() + yaku.MinkanNum() != 4 ) return FALSE ;
	
	if ( ! is_jihai( yaku.atama ) ) return FALSE ;

	for (int i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		if ( ! is_jihai( yaku.mentsu[ i ].hai ) ) return FALSE ;
	}

	return TRUE ;
}





//------------------------------------------------------------------------------------
//
//	uvṽ`FbND
//
//	߂ĺCBOOL ł͂ȂāCv̐łII ӁII
//
//------------------------------------------------------------------------------------
BYTE	Hantei::CountYakuhai( const YakuData & yaku )
{
	BYTE count = 0 ;

	for (int i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		const MentsuData * pMen = &( yaku.mentsu[ i ] );

		if ( pMen->IsPon()    ||
			 pMen->IsAnko()   ||
			 pMen->IsMinkan() ||
			 pMen->IsAnkan() )
		{

			if ( is_yakuhai( pMen->hai, Bakaze(), yaku.Jikaze() ) )
			{
				++count ;

				if ( ( Bakaze() == yaku.Jikaze() )  &&  ( Bakaze() == pMen->hai )  ) 
				{
					++count ;	// _uC_u l
				}
			}
		}
	}

	return count ;
}



//------------------------------------------------------------------------------------
//
//	uavǂ̃`FbN	
//
//	PDOł邱ƁD
//	QDSqł邱ƁD
//	RDvłȂƁD
//	SDʑ҂ł邱 
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckPinfu( const YakuData & yaku )
{
	if ( ! yaku.IsMenzen() )				return FALSE ; // 1
	if ( MACHI_RYANMEN != yaku.machi_type )	return FALSE ; // 4
	if ( yaku.AnshunNum() != 4 )			return FALSE ; // 2 

	
	if ( is_yakuhai( yaku.atama, Bakaze(), yaku.Jikaze() )	) return FALSE ;	// 3

	return TRUE ;
}





//------------------------------------------------------------------------------------
//
//	ulȎqvǂ`FbND
//
//	PDÞȁ{ S!
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckSukantsu( const YakuData & yaku )
{
	if ( yaku.AnkanNum() + yaku.MinkanNum() != 4 ) return FALSE ;

	return TRUE ;
}


//------------------------------------------------------------------------------------
//
//	uOȎqvǂ`FbND
//
//	PDÞȁ{ RI
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckSankantsu( const YakuData & yaku )
{
	if ( yaku.AnkanNum() + yaku.MinkanNum() != 3 ) return FALSE ;

	return TRUE ;
}


//------------------------------------------------------------------------------------
//
//	uOvǂ̃`FbN
//
//	PDOv
//	QDqQȏ
//	RDĂ̍qOv
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckShousangen( const YakuData & yaku ) 
{
	if ( ! is_sangenhai( yaku.atama ) ) return FALSE ;

	if ( yaku.AnkanNum() + yaku.MinkanNum() + yaku.PonNum() + yaku.AnkoNum() < 2 ) return FALSE ;

	// qqXgOɓ˂ށD
	char hist[ 34 ], i ;
	::memset( hist, 0, sizeof(char)*34 ) ;

	for ( i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		if ( yaku.mentsu[ i ].IsAnkan()   ||
			 yaku.mentsu[ i ].IsMinkan()  ||
			 yaku.mentsu[ i ].IsPon()     ||
			 yaku.mentsu[ i ].IsAnko()  )
		{
			hist[ yaku.mentsu[ i ].hai ] ++ ;
		}
	}


	if ( hist[ HAI_HAKU ] + hist[ HAI_HATSU ] + hist[ HAI_CHUN ] >= 2 )	return TRUE ;

	return FALSE ;
}

//------------------------------------------------------------------------------------
//
//	uOvǂ̃`FbN
//
//	PDqRȏ
//	QDĂ̍qOv
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckDaisangen( const const YakuData & yaku ) 
{
	if ( is_sangenhai( yaku.atama ) ) return FALSE ;

	if ( yaku.AnkanNum() + yaku.MinkanNum() + yaku.PonNum() + yaku.AnkoNum() < 3 ) return FALSE ;

	// qqXgOɓ˂ށD
	char hist[ 34 ], i ;
	::memset( hist, 0, sizeof(char)*34 ) ;

	for ( i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		if ( yaku.mentsu[ i ].IsAnkan()   ||
			 yaku.mentsu[ i ].IsMinkan()  ||
			 yaku.mentsu[ i ].IsPon()     ||
			 yaku.mentsu[ i ].IsAnko()  )
		{
			hist[ yaku.mentsu[ i ].hai ] ++ ;
		}
	}

	if ( hist[ HAI_HAKU ] + hist[ HAI_HATSU ] + hist[ HAI_CHUN ] >= 3 )	return TRUE ;

	return FALSE ;
}


  
//------------------------------------------------------------------------------------
//
//	ulṽ`FbN
//
//	PDv
//	QDv̍qR
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckShousushi( const YakuData & yaku )
{
	if ( ! is_kazehai( yaku.atama ) ) return FALSE ;
	if ( yaku.AnkanNum() + yaku.MinkanNum() + yaku.PonNum() + yaku.AnkoNum() < 3 ) return FALSE ;


	// qqXgOɓ˂ށD
	char hist[ 34 ], i ;
	::memset( hist, 0, sizeof(char)*34 ) ;

	for ( i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		if ( yaku.mentsu[ i ].IsAnkan()   ||
			 yaku.mentsu[ i ].IsMinkan()  ||
			 yaku.mentsu[ i ].IsPon()     ||
			 yaku.mentsu[ i ].IsAnko()  )
		{
			hist[ yaku.mentsu[ i ].hai ] ++ ;
		}
	}

	// Ƃ͕vłR邩H
	if ( hist[ HAI_TON ] + hist[ HAI_NAN ] + hist[ HAI_SHA ] + hist[ HAI_PEI ] == 3 ) return TRUE ;

	return FALSE ;
}


//------------------------------------------------------------------------------------
//
//	ulṽ`FbN
//
//	PDqS
//	QD̍qSĕvłłĂD
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckDaisushi( const YakuData & yaku )
{
	if ( yaku.AnkanNum() + yaku.MinkanNum() + yaku.PonNum() + yaku.AnkoNum() != 4 ) return FALSE ;

	// qqXgOɓ˂ށD
	char hist[ 34 ], i ;
	::memset( hist, 0, sizeof(char)*34 ) ;

	for ( i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		if ( yaku.mentsu[ i ].IsAnkan()   ||
			 yaku.mentsu[ i ].IsMinkan()  ||
			 yaku.mentsu[ i ].IsPon()     ||
			 yaku.mentsu[ i ].IsAnko()  )
		{
			hist[ yaku.mentsu[ i ].hai ] ++ ;
		}
	}


	// Ƃ͕vłR邩H
	if ( hist[ HAI_TON ] + hist[ HAI_NAN ] + hist[ HAI_SHA ] + hist[ HAI_PEI ] == 4 ) return TRUE ;

	return FALSE ;
}


//------------------------------------------------------------------------------------
//
//	utvɂȂĂ邩D
//
//	PDOł邱ƁD
//	QDqQȏ゠邱ƁD
//	RD̏qƁD
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckIpeiko( const YakuData & yaku )
{
	if ( ! yaku.IsMenzen() ) return FALSE ;
	
	int		j, k ;
	char	shuntsu_num=0, shuntsu[ 4 ] ;

	// q𒊏o
	for ( j=0 ; j < yaku.MentsuNum() ; ++j )
	{
		if ( yaku.mentsu[ j ].IsAnshun() )
		{
			shuntsu[ shuntsu_num++ ] = yaku.mentsu[ j ].hai ;
		}
	}

	// qQȉȂtł킯Ȃ
	if ( shuntsu_num < 2 ) return FALSE ;

	// ou\[gȂ瓯̂΂ňtoD
	for ( j=0 ; j < shuntsu_num -1 ; ++j )
	{
		for ( k=j+1 ; k < shuntsu_num ; ++k )
		{
			if ( shuntsu[ j ] == shuntsu[ k ] ) return TRUE ;
		}
	}


	return FALSE ;
}


//------------------------------------------------------------------------------------
//
//	utvɂȂĂ邩`FbN
//
//	PDOł邱ƁD
//	QDqS邱ƁD
//	RD炪Qł邱ƁD
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckRyanpeiko( const YakuData & yaku ) 
{
	if ( ! yaku.IsMenzen() )	 return FALSE ;
	if ( yaku.AnshunNum() != 4 ) return FALSE ;

	char buf[ 4 ] ;
	char tmp ;

	// f[^擾
	for (int i=0 ; i < 4 ; ++i )
	{
		buf[ i ] = yaku.mentsu[ i ].hai ;	// qł傤D(ȂG[)
	}

	// ou\[g
	for (int j=0 ; j < 3 ; ++j )
	{
		for (int k=j+1 ; k < 4 ; ++k )
		{
			if ( buf[ j ] > buf[ k ] )
			{
				tmp		 = buf[ k ] ;
				buf[ k ] = buf[ j ] ;
				buf[ j ] = tmp ;
			}
		}
	}

	if ( ( buf[ 0 ] == buf[ 1 ] ) && ( buf[ 2 ] == buf[ 3 ] ) ) return TRUE ;

	return FALSE ;
}



//------------------------------------------------------------------------------------
//
//	uΈFṽ`FbN
//
//	PD2C3C4C6C8C ݂̂ōĂ邱ƁD
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckRyuiso( const YakuData & yaku ) 
{
	WORD		data = 0 ;
	const WORD	mask = 0xbf51 ; // _ȔvɃtOĂĂ܂D(̂P)

	//[  ̃`FbN ]
	if ( yaku.atama < HAI_1SOU ) return FALSE ;

	data = 0x01 << ( yaku.atama - HAI_1SOU ) ;

	if ( ( data & mask ) != 0 ) return FALSE ;



	//[ ʎq ̃`FbN ]
	for (int i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		const MentsuData * pMentsu = & yaku.mentsu[ i ] ;

		// qn 2qn܂̂肦ȂD

		if ( pMentsu->IsChi() || pMentsu->IsAnshun() )
		{
			if ( pMentsu->hai != HAI_2SOU ) return FALSE ;
		}

		// qn͂ƃhC
		else 
		{
			// Ƃ肠CP݁`X ܂ł̓_I
			if ( pMentsu->hai < HAI_1SOU ) return FALSE ;

			// ȏ̂̂ͥ [
			// P` ܂ŁC傤ǂPUȂCPUrbg}XNł邼II
			// P˂OC˂XC˂PR ɂȂ΂H POKD
			data = 0x01 << ( pMentsu->hai - HAI_1SOU ) ;
			
			if ( ( data & mask ) != 0 ) return FALSE ;
		}
	}



	return TRUE ;

}


//------------------------------------------------------------------------------------
//
//	uVṽ`FbN
//
//	ł́C19vǂ𒲂ׂ邾łD
//	CVC΁XaƂԂȂƁII
//
//	PD΁Xa `ł邱ƁD
//	QDPXvōĂ邱ƁD
//	RD(KRI)҂́Co҂CPR҂
//
//------------------------------------------------------------------------------------
BOOL	Hantei ::CheckChinroto( const YakuData & yaku )
{
	if ( yaku.AnkoNum() + yaku.PonNum() + 
		 yaku.AnkanNum() + yaku.MinkanNum() != 4 ) return FALSE ;

	for (int i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		// ʎqPłPXvȂ΁CŃ_[I

		if ( ! is_19hai( yaku.mentsu[ i ].hai ) ) return FALSE ;
	}

	return TRUE ;
}


//------------------------------------------------------------------------------------
//
//	uFvǂ̃`FbN
//
//	PDvނłłĂ邱ƁD
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckChinitsu( const YakuData & yaku ) 
{
	// q낤q낤ƂɂqXgOɓ˂ށD
	char hist[ 34 ] ;
	::memset( hist, 0, sizeof(char)*34 ) ;

	int i ;
	for ( i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		hist[ yaku.mentsu[ i ].hai ] ++ ;
	}
	hist[ yaku.atama ] ++ ;

	// ꂼ̐߂
	char	jihai_num = 0 ;
	char	wanzu_num = 0 ;
	char	pinzu_num = 0 ;
	char	souzu_num = 0 ;

	for ( i=HAI_1WAN ; i <= HAI_9WAN ; ++i )	wanzu_num += hist[ i ] ;
	for ( i=HAI_1PIN ; i <= HAI_9PIN ; ++i )	pinzu_num += hist[ i ] ;
	for ( i=HAI_1SOU ; i <= HAI_9SOU ; ++i )	souzu_num += hist[ i ] ;
	for ( i=HAI_TON  ; i <= HAI_CHUN ; ++i )	jihai_num += hist[ i ] ;

	// v܂ނȁH
	// CFƂ̈Ⴂ
	if ( jihai_num != 0 ) return FALSE ;

	// v͂PނȁH
	if ( wanzu_num > 0 )
	{
		if ( ( pinzu_num == 0 ) && ( souzu_num == 0 ) )	return TRUE ;
	}
	else if ( pinzu_num > 0 )
	{
		if ( ( wanzu_num == 0 ) && ( souzu_num == 0 ) ) return TRUE ;
	}
	else if ( souzu_num > 0 )
	{
		if ( ( wanzu_num == 0 ) && ( pinzu_num == 0 ) ) return TRUE ;
	}

	return FALSE ;
}








//------------------------------------------------------------------------------------
//
//	uA󓕁ṽ`FbN ()
//
//
//	PDOł邱ƁD
//	QD(KRI)FD
//	RDPvƂXvRCQ`WPD
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckChuren( const YakuData & yaku ) 
{
	int i ;

	if ( ! yaku.IsMenzen() ) return FALSE ;

	if ( ! is_suujihai( yaku.atama ) ) return FALSE ;

	// \ƂđIԁD
	// {IɐƈႤނ̂̂oĂ_I
	const BYTE suujihai_type = yaku.atama / 9 ;

	for ( i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		if ( suujihai_type != ( yaku.mentsu[ i ].hai / 9 ) ) return FALSE ;
	}

	// ̒iKŁCʎqׂēނ̐vł邱Ƃmς݁D

	// qXgO̍쐬D
	BYTE const base = suujihai_type * 9 ;
	BYTE hist[ 9 ] ;
	::memset( hist, 0, sizeof(BYTE)*9 ) ;

	hist[ yaku.atama - base ] += 2 ;

	for ( i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		BYTE index = yaku.mentsu[ i ].hai - base ;

		switch ( yaku.mentsu[ i ].type )
		{
		case MENTSU_ANSHUN :
		case MENTSU_MINSHUN :
			hist[ index + 0 ] ++ ;
			hist[ index + 1 ] ++ ;
			hist[ index + 2 ] ++ ;
			break ;
		case MENTSU_ANKO :
		case MENTSU_MINKO :
			hist[ index ] += 3 ;
			break ;
		case MENTSU_ANKAN :
		case MENTSU_MINKAN :
			hist[ index ] += 4 ;
			break ;
		}
	}

	// qXgOC
	// uPvƁuXvRȏCȊOPȏ゠邱ƂD
	if ( hist[ 0 ] < 3  || hist[ 8 ] < 3 ) return FALSE ;
	for ( i=1 ; i <= 7 ; ++i )
	{
		if ( hist[ i ] == 0 ) return FALSE ;
	}


	// ܂ŗ΋A󓕊m
	return TRUE ;
}




//------------------------------------------------------------------------------------
//
//	uOFvɂȂĂ邩`FbN
//
//	PDqRȏ゠邱ƁD
//	QDȂԍ̑gݍ킹ɂȂĂ邱
//	RDāCݎqCqCqł邱ƁD
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckSansyoku( const YakuData & yaku ) 
{
	int i ;

	BYTE	hist[ 27 ], count=0 ;
	::memset( hist, 0, sizeof(BYTE)*27 ) ;

	for ( i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		if ( ( yaku.mentsu[i].IsChi() ) || ( yaku.mentsu[i].IsAnshun() ) )
		{
			hist[ yaku.mentsu[i].hai ] ++ ;
			count ++ ;
		}
	}

	// q3ȉȂOF͂肦ȂD
	if ( count < 3 ) return FALSE ;
		
	// ݎqP`V܂Ń`FbNC
	// ݎq΁CqCqƃ`FbND
	// SĂɗL΂RFI
	for ( i=HAI_1WAN ; i <= HAI_7WAN ; ++i )
	{
		if ( hist[ i + 0 ] == 0 ) continue ;		// ݎq
		if ( hist[ i + 9 ] == 0 ) continue ;		// q
		if ( hist[ i + 18 ] != 0 ) return TRUE ;	// q  3FI
	}

	return FALSE ;
}


//------------------------------------------------------------------------------------
//
//	uOFv
//
//	PDq{Ȏq Rȏ
//	QDݎqCqCqɂꂼꓯ̂
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckSansyokuDoukoku( const YakuData & yaku )
{
	char hist[ 34 ] ;
	::memset( hist, 0, sizeof(char)*34 ) ;

	// ȎqCqqXgOɃZbgD
	int i, count=0 ;
	for ( i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		if ( ( yaku.mentsu[i].IsPon() )    ||
			 ( yaku.mentsu[i].IsAnko() )   ||
			 ( yaku.mentsu[i].IsAnkan() )  ||
			 ( yaku.mentsu[i].IsMinkan() )  )
		{
			hist[ yaku.mentsu[i].hai ] ++ ;
			count ++ ;
		}
	}

	// qRȉȂ瓯ł肦ȂD
	if ( count < 3 ) return FALSE ;

	// ݎq 璲ׂĂ
	for ( i=HAI_1WAN ; i <= HAI_9WAN ; ++i )
	{
		if ( hist[ i + 0  ] == 0 ) continue ;		// ݎq
		if ( hist[ i + 9  ] == 0 ) continue ;		// q
		if ( hist[ i + 18 ] >= 1 ) return TRUE ;	// q  RF|!!
	}

	return FALSE ;
}

//------------------------------------------------------------------------------------
//
//	uSсvɂȂĂ邩`FbN
//
//	PDPXv
//	QDqPXv
//	RDqPXv ܂ށD
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckChanta( const YakuData & yaku ) 
{
	//[  ̃`FbN ]
	if ( ! is_19jihai( yaku.atama ) ) return FALSE ;

	BOOL	has_shuntsu = FALSE ;
	
	for (int i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		//[ q̃`FbN ]
		if ( ( yaku.mentsu[i].IsChi() ) || ( yaku.mentsu[i].IsAnshun() ) )
		{
			has_shuntsu = TRUE ;

			char tmp = yaku.mentsu[i].hai % 9 ;
			if ( ( tmp != 0 ) && ( tmp != 6 ) ) return FALSE ;
		}
		//[ q̃`FbN ]
		else
		{
			if ( ! is_19jihai( yaku.mentsu[i].hai ) ) return FALSE ;
		}
	}

	return ( has_shuntsu )? TRUE : FALSE ;
}



//------------------------------------------------------------------------------------
//
//	uSсvɂȂĂ邩̃`FbN
//
//	PDSĂ̖ʎqPXv܂ł邱ƁD
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckJyunchan( const YakuData & yaku ) 
{
	//[  ̃`FbN ]
	if ( ! is_19hai( yaku.atama ) ) return FALSE ;

	//[ ʎq ̃`FbN ]
	for (int i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		//[ qn ]
		if ( yaku.mentsu[ i ].IsChi() || yaku.mentsu[ i ].IsAnshun() )
		{
			BYTE	hai = yaku.mentsu[ i ].hai % 9 ;
			if ( ( hai != 0 ) && ( hai != 6 ) ) return FALSE ;
		}
		//[ qn (SтƈႤ̂͂[) ]
		else 
		{
			if ( ! is_19hai( yaku.mentsu[ i ].hai ) ) return FALSE ;
		}
	}
	
	return TRUE ;
}


//------------------------------------------------------------------------------------
//
//	uOÍvǂ`FbN
//
//	lÍs̏ꍇC`FbN邱ƁD
//	AK̏ꍇCAKv܂ވÍ́C
//	炩߁uqvɕϊĂ̂Ƃ܂D
//
//	PDÞȁ{Í R
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckSananko( const YakuData & yaku )
{
	BYTE kotu_num = yaku.AnkoNum() + yaku.AnkanNum() ;

	if ( kotu_num == 3 ) return TRUE ;
	
	return FALSE ;
}

//------------------------------------------------------------------------------------
//
//	ulÍvǂ`FbND
//
//	AK̏ꍇCAKv܂ވÍ́C
//	炩߁uqvɕϊĂ̂Ƃ܂D
//
//	PDÞȁ{Í S
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckSuanko( const YakuData & yaku )
{
	if ( yaku.AnkoNum() + yaku.AnkanNum() != 4 ) return FALSE ;

	return TRUE ;
}

//------------------------------------------------------------------------------------
//
//	uCʊсvɂȂĂ邩
//
//	PDqRȏ゠邱ƁD
//	QDɂPCSCVŎn܂鏇q1ȏ㎝ƁD
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckIkki( const YakuData & yaku )
{
	int i, count=0 ;

	BYTE	hist[ 27 ] ;
	::memset( hist, 0, sizeof(BYTE)*27 ) ;	// [Zbg

	for ( i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		if ( ( yaku.mentsu[i].IsChi() ) || ( yaku.mentsu[i].IsAnshun() ) )
		{
			hist[ yaku.mentsu[i].hai ] ++ ;
			count ++ ;
		}
	}

	// q͂Rȏ゠͂
	if ( count < 3 ) return FALSE ;

	// ݎqqqꂼɂĒׂ
	for ( i=HAI_1WAN ; i <= HAI_1SOU ; i += 9 )
	{
		if (
			( hist[ i + 0 ] >= 1 ) &&	// 1 ݁CC
			( hist[ i + 3 ] >= 1 ) &&	// 4 ݁CC
			( hist[ i + 6 ] >= 1 )  )	// 7 ݁CC
		{
			return TRUE ; // Cʊ!!
		}
	}

	return FALSE ;

}


//------------------------------------------------------------------------------------
//
//	u΁XvɂȂĂ邩`FbN
//
//	PDqS(qPłƃ_I)
//
//------------------------------------------------------------------------------------
BOOL	Hantei::CheckToitoi( const YakuData & yaku )
{
	for (int i=0 ; i < yaku.MentsuNum() ; ++i )
	{
		if ( yaku.mentsu[i].IsChi() )		return FALSE ;
		if ( yaku.mentsu[i].IsAnshun() )	return FALSE ;
	}

	return TRUE ;
}




//====================================================================================
//
//
//	 ߂
//
//	v͍lȂD
//
//====================================================================================
int		Hantei::CalcShantenValue( const TehaiData & tehai )
{
	char hist[ 34 ] ;


	MakeHistogram( hist, tehai ) ;	// qXgO쐬


	if ( is_hai( tehai.Tsumohai() ) )
	{
		hist[ tehai.Tsumohai() ] -- ;		// v܂܂Ăꍇ̓qXgO珜Ă
	}



	int j, times ;

	// ̏l
	
	//int shanten_value = 8 - ( 2 * tehai.NakihaiNum() ) ;
	char	mentsu_num = tehai.NakihaiNum() ;
	char	toitsu_num = 0 ;
	char	tahtsu_num = 0 ;

	// ʎq𔲂
	for ( j=0 ; j < 34 ; ++j )
	{
		// q ʂ
		if ( hist[j] >= 3 ) 
		{
			hist[ j ] -= 3 ;
			//shanten_value -= 2 ;
			mentsu_num++ ;
		}

		if ( j >= 27 ) continue ;
		if ( j % 9 >= 7 ) continue ;

		// q𔲂
		for ( times=0 ; times < 2 ; ++times )
		{	
			if ( ( hist[ j+0 ] > 0 ) &&  ( hist[ j+1 ] > 0 ) &&  ( hist[ j+2 ] > 0 )  )
			{
				hist[ j+0 ] -- ;
				hist[ j+1 ] -- ;
				hist[ j+2 ] -- ;

				//shanten_value	-= 2 ;
				mentsu_num ++ ;
			}
		}	
	}

	// Ύq𔲂
	for ( j=0 ; j < 34 ; ++j )
	{
		if ( hist[ j ] >= 2 )
		{
			hist[ j ] -= 2 ;
		//	shanten_value -- ;
			toitsu_num ++ ;
		}
	}

	// q𔲂
	int h, k ;
	for ( k=0 ; k < 3 ; ++k )
	{
		j = k*9 ;

		for ( h=0 ; h < 7 ; ++h, ++j )
		{
			if ( hist[ j ] == 0 ) continue ;

			if ( hist[ j+1 ] )
			{
				hist[ j+0 ]-- ;
				hist[ j+1 ]-- ;
				//shanten_value-- ;
				tahtsu_num ++ ;

			}
			else if ( hist[ j+2 ] )
			{
				hist[ j+0 ]-- ;
				hist[ j+2 ]-- ;
				//shanten_value-- ;
				tahtsu_num ++ ;
			}
		}
	}

	//return shanten_value ;

	// PQWX
	//                
	//   Q { Q { Q {P{P   | W  O
	// cƌ[ɂȂ̂ɁCvȂI
	// ĉŁCO遫
	
	if ( mentsu_num == 3 && tahtsu_num == 2 )
		return 8 - ( 2*3 + 1 ) ;
	else
		return 8 - ( 2*mentsu_num + tahtsu_num + toitsu_num ) ;

}



//////////////////////////////////////////////////////////////////////////////////////
//  EOF : Hantei.cpp
//////////////////////////////////////////////////////////////////////////////////////