//V~[^

#include "stdafx.h"
#include "Mahjong.h"
#include "Hantei.h"
#include "MJSim.h"

//擾
//Kyoku:ǁAIndex:ʒu
int GetZikaze(int Index, int Kyoku){return (Index + 4 - (Kyoku % 4)) % 4;}
//z̍Ō̈ʒu擾
// * ͂̍Ō̈ʒu/擾 GetLastIndex(MJGAME::Kawa)
// * R̎cc擾 GetLastIndex(MJGAME::Tsumo)
int GetLastIndex(int *Data)
{
	for(int i = 0; Data[i] != 0; i++);
	return i;
}
//J̐擾
int GetKanNum(MJGAME *Game)
{
	int k = 0;
	for(int i = 0; i < 4; i++){
		for(int j = 0; j < 4; j++){
			switch(Game->Player[i].Furo[j].Type){
			case MJFORO_ANKAN:case MJFORO_MINKAN:k++;
			}
		}
	}
	return k;
}
//t[擾
int GetFuroNum(MJFURO *Furo)
{
	for(int i = 0; i < 4; i++){
		if(Furo[i].Type == MJFURO_NULL){break;}
	}
	return i;
}
//h擾(\vł͂Ȃ)
int GetDora(int Index, int *Yama)
{
	int DoraFilter[] = {	0, 2, 3, 4, 5, 6, 7, 8, 9, 1,
							0,12,13,14,15,16,17,18,19,11,
							0,22,23,24,25,26,27,28,29,21,
							0,33, 0,35, 0,37, 0,31, 0, 0,
							0,43, 0,45, 0,41};
	return DoraFilter[Yama[4 + Index]];
}
//̎
int GetSeed()
{
	GUID guid;
	CoCreateGuid(&guid);
	int seed = guid.Data1 + guid.Data2 + guid.Data3;
	for(int i = 0; i < 8; i++){seed += guid.Data4[i];}
	return seed;
}
//オ_vZNX
//MahjongNXg
class CMJAgari{
	Mahjong m_MJ;
	bool m_IsRon;
public:
	MJGAME *m_Game;
private:
	void ConvetTehai(int Index, bool IsRon);
public:
	BOOL Calc(int Index, bool IsRon);	//vZs
	int Fu(){return (int)m_MJ.m_Yaku.fu;}
	int Han(){return (int)m_MJ.m_Yaku.fan;}
	int Score(){return (int)m_MJ.m_Yaku.score;}
	int YakuNum(){return m_MJ.m_Yaku.YakuNum();}
	string YakuName(int Index){return ::GetYakuName(m_MJ.m_Yaku.GetYaku(Index));}
	bool IsRon(){return m_IsRon;}
	int GetShanten(int Index);	//Ve擾
};
BOOL CMJAgari::Calc(int Index, bool IsRon)
{
	m_IsRon = IsRon;
	m_MJ.Init();	//
	ConvetTehai(Index, IsRon);
	return m_MJ.YHM_YakuHantei(IsRon);	//_vZs
}
void CMJAgari::ConvetTehai(int Index, bool IsRon)
{
	MJPLAYER *Player = &m_Game->Player[Index];

	m_MJ.m_Tehai.Reset();
	
	m_MJ.m_Tehai.is_menzen = GetFuroNum(Player->Furo) == 0 ? TRUE : FALSE;
	m_MJ.m_Tehai.is_ron = IsRon;
	m_MJ.m_Tehai.jikaze = GetZikaze(Index, m_Game->Kyoku);

	//v̕ϊ
	int ConvertHai[] = {
		0,0,1,2,3,4,5,6,7,8,
		0,9,10,11,12,13,14,15,16,17,
		0,18,19,20,21,22,23,24,25,26,
		0,27,0,28,0,29,0,30,0,0,
		0,31,0,32,0,33
	};
	int TehaiNum = 0;
	int i;
	for(i = 1; i < 46; i++){
		for(int j = 0; j < Player->Tehai[i]; j++){
			m_MJ.m_Tehai.tehai[TehaiNum++] = ConvertHai[i];
		}
	}
	m_MJ.m_Tehai.tehai[13] = ConvertHai[Player->Tsumo];
	m_MJ.m_Tehai.tehai_num = TehaiNum + 1;	//c̕
	m_MJ.m_Tehai.leechi = Player->RichiIndex != 0 ? LEECHI_LEECHI : LEECHI_NON;
	if(Player->Ippatsu){m_MJ.m_Tehai.SetLeechiIppatsu();}
	if(Player->RichiIndex == 1){/*_u[`*/}
	
	//MahjongNXYHM_MakeChi͎gȂƁB
	//(v낤Ƃ邽)
	for(i = 1; i < 4; i++){
		switch(Player->Furo[i].Type){
		case MJFORO_CHI:	m_MJ.m_Tehai.AddChi(Player->Furo[i].Hai);break;
		case MJFORO_PON:	m_MJ.m_Tehai.AddPon(Player->Furo[i].Hai);break;
		case MJFORO_MINKAN:	m_MJ.m_Tehai.AddMinkan(Player->Furo[i].Hai);break;
		case MJFORO_ANKAN:	m_MJ.m_Tehai.AddAnkan(Player->Furo[i].Hai);break;
		}
	}

	m_MJ.m_Bakaze = m_Game->Kyoku % 4;
	m_MJ.m_IsHaitei = FALSE;
	m_MJ.m_IsRinshan = FALSE;
	m_MJ.m_IsChankan = FALSE;

	for(i = 0; i < GetKanNum(m_Game); i++){
		m_MJ.YHM_SetDoraIndicator(i, m_Game->Yama[4 + i]);
	}
}
int CMJAgari::GetShanten(int Index)
{
	ConvetTehai(Index, FALSE);
	return Hantei::CalcShantenValue(m_MJ.m_Tehai);
}
//vC[AI
class CMJAI{
public:
	string m_Name;
	int m_Index;	//ǂɍĂ邩B0:NƁ`
	MJGAME *m_Game;
	MJGAME m_GameCopy;

	HINSTANCE m_AI;	//DLLnh
	typedef void (*AIACTION)(int, int, MJGAME*);
	AIACTION AIAction;	//֐ւ̃|C^
	
	~CMJAI(){FreeLibrary(m_AI);}
	void Load(int Number);	//DLL[h
	void Action(int Msg);
};
void CMJAI::Action(int Msg)
{
	memcpy(&m_GameCopy, m_Game, sizeof(MJGAME));
	AIAction(Msg, m_Index, &m_GameCopy);
	memcpy(&m_Game->Player[m_Index].Action,
		&m_GameCopy.Player[m_Index].Action, sizeof(MJACTION));
}
void CMJAI::Load(int Number)
{
	stringstream key;
	char buf[256];

	key << "AI" << Number;	//L[
	GetPrivateProfileString("AI", key.str().c_str(), "", buf, 256, ".\\MJSim.ini");
	if(buf[0] == NULL){
		cout << "init@C̓ǂݍ݂Ɏs܂B:" << key.str() << endl;
		throw;
	}
	m_AI = LoadLibrary(buf);
	if(m_AI == NULL){
		cout << "DLL[hł܂B:" << buf << endl;
		throw;
	}
	AIAction = (AIACTION)GetProcAddress(m_AI, "AIAction"); 
	if(AIAction == NULL){
		cout << "DLLAIAction֐܂B" << buf << endl;
		throw;
	}
	m_Name = buf;
}
//V~[^
class CMJSim{
	MJGAME m_Game;
	CMJAI *m_AI[4];
	CMJAI m_AIInstance[4];
	CMJAgari m_Agari;
	fstream m_File;
	vector<int> m_Log;
	//C̊֐
	void Game();	//Jn
	void Kyoku();	//ǊJn
	void ReAction();	//̂Ĕvɑ΂郊ANV
	//ANV̏
	void Agari(int Index, bool IsRon);
	void Sutehai(int Index);
	void Richi(int Index);
	void Ankan(int Index);
	void Kakan(int Index);
	void Minkan(int Index);
	void Pon(int Index);
	void Chi(int Index);
	void Ryukyoku();
	void Action(int Index, int ActionType);
	//̑
	void LogStart();
	void LogGameStart();
	void LogKyokuStart();
	void LogKyokuEnd();
	void LogGameEnd();
	void LogHaifu(int Index,int Action, int Hosoku1 = 0, int Hosoku2 = 0);
	void InitKyoku();
	void CallAllAI(int Msg){for(int i = 0; i < 4; i++){m_AI[i]->Action(Msg);}}
	void CalcGameScore();
	static int qsort_CalcGameScore(const void *p1, const void *p2);
	string GetTonpuHai(int Hai);
	string GetTonpuKaze(int Index);
public:
	CMJSim();
	void Run();
};
CMJSim::CMJSim()
{
	m_Agari.m_Game = &m_Game;

	m_File.open("MJSimScore.txt", ios::out);
	//debug {͌֒ǉ
	//m_File.open("MJSimScore.txt", ios::out | ios::app);
    if(m_File.is_open() == 0){
		cout << "t@CJ܂B";
		throw;
	}
	//AI[h
	for(int i = 0; i < 4; i++){m_AIInstance[i].Load(i);}
}
void CMJSim::Run()
{
	int i = 1;
	while(1){
		cout << i++;
		Game();
		cout << endl;
		if(GetKeyState(VK_SHIFT) < 0){break;}
	}
}
void CMJSim::Game()
{
	int i;
	//Q[f[^
	memset(&m_Game, 0, sizeof(m_Game));
	//ꏊ
	for(i = 0; i < 4; i++){m_AI[i] = &m_AIInstance[i];}
	srand(GetSeed());
	for(i = 0; i < 4; i++){swap(m_AI[i], m_AI[rand() % 4]);}

	//ꏊ܂̂Ńf[^Zbg
	for(i = 0; i < 4; i++){
		//AĨf[^Zbg
		m_AI[i]->m_Index = i;
		m_AI[i]->m_Game = &m_Game;
		//MJGAMẼvC[f[^Zbg
		m_Game.Player[i].Score = 27000;
	}

	LogGameStart();
	CallAllAI(MJMSG_GAMESTART);
	while(m_Game.Kyoku < 4){
		LogKyokuStart();
		try{
			Kyoku();
		}
		catch(int Msg){
			//オċǂIƂ̓Lb`B
			//G[͖
			Msg = 0;	//x߂̃_~[R[h
		}
		LogKyokuEnd();
		CallAllAI(MJMSG_KYOKUEND);
		m_Game.Kyoku++;
		cout << ".";
	}
	CalcGameScore();
	LogGameEnd();
	CallAllAI(MJMSG_GAMEEND);
}
void CMJSim::InitKyoku()
{
	m_Log.clear();

	int score[4];
	int i;
	for(i = 0; i < 4; i++){
		score[i] = m_Game.Player[i].Score;
	}
	memset(&m_Game.Player, 0, sizeof(MJPLAYER) * 4);
	for(i = 0; i < 4; i++){
		m_Game.Player[i].Score = score[i];
		strcpy(m_Game.Player[i].Name, m_AI[i]->m_Name.c_str());
	}

	m_Game.IsAgari = false;
	m_Game.Turn = m_Game.Kyoku % 4;	//c͒N
	m_Game.Tsumo = &m_Game.Yama[14];	//cJnʒu

	//Rς
	int hai[] = {	1,2,3,4,5,6,7,8,9,
					11,12,13,14,15,16,17,18,19,
					21,22,23,24,25,26,27,28,29,
					31,33,35,37,
					41,43,45};
	for(i = 0; i < 4; i++){	//34̔v4Rs[
		memcpy(m_Game.Yama + i * 34, hai, sizeof(hai));
	}
	//܂
	srand(GetSeed());
	for(i = 0; i < 136; i++){
		swap(m_Game.Yama[i], m_Game.Yama[rand() % 136]);
	}
	//zv΂
	for(i = 0; i < 4; i++){
		for(int j = 0; j < 13; j++){
			m_Game.Player[i].Tehai[*m_Game.Tsumo]++;
			m_Game.Tsumo++;
		}
	}
}
void CMJSim::Action(int Index, int ActionType)
{
	switch(ActionType){
	case MJACTION_NULL:	break;
	case MJACTION_TSUMOAGARI:	Agari(Index, false);break;
	case MJACTION_ANKAN:	Ankan(Index);break;
	case MJACTION_KAKAN:	Kakan(Index);break;
	case MJACTION_RICHI:	Richi(Index);break;
	case MJACTION_SUTEHAI:	Sutehai(m_Game.Turn);break;
	case MJACTION_RON:	Agari(Index, true);break;
	case MJACTION_PON:	Pon(Index);break;
	case MJACTION_CHI:	Chi(Index);break;
	case MJACTION_MINKAN:	Minkan(Index);break;
	default:
		cout << "ȃANVw肳܂B";
		throw;
	}
}
void CMJSim::Kyoku()
{
	InitKyoku();
	CallAllAI(MJMSG_KYOKUSTART);

	//Ō̃c܂Ń[v
	while(*m_Game.Tsumo != 0){
		MJPLAYER *Player = &m_Game.Player[m_Game.Turn];
		//c
		LogHaifu(m_Game.Turn, MJACTION_TSUMO, *m_Game.Tsumo);
		Player->Tsumo = *m_Game.Tsumo;
		m_Game.Tsumo++;
		m_AI[m_Game.Turn]->Action(MJMSG_TSUMO);	//ʒm

		//AIɎwꂽANVs
		Action(m_Game.Turn, Player->Action.Type);
		//[`΂łȂΈꔭ
		if(Player->Action.Type != MJACTION_RICHI){Player->Ippatsu = false;}
		ReAction();	//̂Ĕvɑ΂ẴANV
		m_Game.Turn++; m_Game.Turn %= 4;	//̃vC[ɉ
	}
	//
	Ryukyoku();
}
void CMJSim::ReAction()
{
	CallAllAI(MJMSG_REACTION);	//Sɒʒm

	//v̂ĂvC[猩ċ߂ƂDɂ邽߂ɁA
	//|C^z
	MJACTION *a[4];
	int i;
	for(i = 0; i < 4; i++){
		a[i] = &m_Game.Player[(m_Game.Turn + i + 1) % 4].Action;
	}
	int ReActionPalyer = 0;	//̂Ĕvɑ΂ăANVNvC[
	//Dx̍ANV̗p
	for(i = 0; i < 4; i++){
		if(a[ReActionPalyer]->Type < a[i]->Type){
			ReActionPalyer = i;
		}
	}
	//NANVH
	if(a[ReActionPalyer]->Type != MJACTION_NULL){
		//ꔭ
		for(i = 0; i < 4; i++){m_Game.Player[i].Ippatsu = false;}
		//̗pANVs
		Action(ReActionPalyer, m_Game.Player[ReActionPalyer].Action.Type);
		m_Game.Turn = ReActionPalyer;	//^[AvC[ɐݒ
		ReAction();	//ċA
	}
}
void CMJSim::Agari(int Index, bool IsRon)
{
	if(IsRon){
		//vvɉ
		int hai = m_Game.Player[m_Game.Turn].Kawa[GetLastIndex(m_Game.Player[m_Game.Turn].Kawa) - 1];
		m_Game.Player[Index].Tehai[hai]++;
		LogHaifu(Index, MJACTION_RON);
	}
	else{
		LogHaifu(Index, MJACTION_TSUMOAGARI);
	}
	//オ_vZ
	if(m_Agari.Calc(Index, IsRon) == FALSE){
		cout << "`{łB";
		throw;
	}
	//KyokuScore͒PɑȂ
	//[`œ_Ăꍇ
	if(IsRon){
		m_Game.Player[Index].KyokuScore += m_Agari.Score();
		m_Game.Player[m_Game.Turn].KyokuScore -= m_Agari.Score();
	}
	else{	//debug ĉƂB{̓e[ug
		for(int i = 0; i < 4; i++){
			if(Index == i){	//オvC[
				m_Game.Player[i].KyokuScore += m_Agari.Score();
			}
			else{
				if(GetZikaze(Index, m_Game.Kyoku) == 0){//オvC[e
					m_Game.Player[i].KyokuScore -= m_Agari.Score() / 3;
				}
				else{	//q̏ꍇ
					if(GetZikaze(i, m_Game.Kyoku) == 0){	//ȅꍇ
						m_Game.Player[i].KyokuScore -= m_Agari.Score() / 2;
					}
					else{
						m_Game.Player[i].KyokuScore -= m_Agari.Score() / 4;
					}
				}
			}
		}
	}
	//Z
	for(int i = 0; i < 4; i++){
		m_Game.Player[i].Score += m_Game.Player[i].KyokuScore;
	}
	m_Game.IsAgari = true;
	throw 1;	//オƂ͗O1𑗂
}
void CMJSim::Ryukyoku()
{
}
void CMJSim::Richi(int Index)
{
	MJPLAYER *Player = &m_Game.Player[Index];
	Player->RichiIndex = GetLastIndex(m_Game.Player[m_Game.Turn].Kawa);
	Player->Ippatsu = true;
	Player->KyokuScore -= 1000;	//ǃXRA1000_
	m_Game.RichiboNum++;
	LogHaifu(Index, MJACTION_RICHI);

	Sutehai(Index);
}
void CMJSim::Pon(int Index)
{
	int hai = m_Game.Player[m_Game.Turn].Kawa[GetLastIndex(m_Game.Player[m_Game.Turn].Kawa) - 1];
	LogHaifu(Index, MJACTION_PON);

	MJPLAYER *Player = &m_Game.Player[Index];
	if(Player->Tehai[hai] < 2){
		cout << "|ł܂B";
		throw;
	}
	Player->Tehai[hai] -= 2;	//v폜
	int FuroIndex = GetFuroNum(Player->Furo);
	Player->Furo[FuroIndex].Type = MJFORO_PON;
	Player->Furo[FuroIndex].Hai = hai;
	Player->Furo[FuroIndex].Hosoku = m_Game.Turn;	//ǂ

	Sutehai(Index);
}
void CMJSim::Minkan(int Index)
{
	int hai = m_Game.Player[m_Game.Turn].Kawa[GetLastIndex(m_Game.Player[m_Game.Turn].Kawa) - 1];
	LogHaifu(Index, MJACTION_MINKAN, hai);

	MJPLAYER *Player = &m_Game.Player[Index];
	if(Player->Tehai[hai] < 3){
		cout << "Jł܂B";
		throw;
	}
	Player->Tehai[hai] -= 3;	//v폜
	int FuroIndex = GetFuroNum(Player->Furo);
	Player->Furo[FuroIndex].Type = MJFORO_MINKAN;
	Player->Furo[FuroIndex].Hai = hai;
	Player->Furo[FuroIndex].Hosoku = m_Game.Turn;	//ǂ

	//V
	Player->Tsumo = m_Game.Yama[GetKanNum(&m_Game)];
	Player->Rinsyan = true;

	m_Game.Turn = Index;
	m_AI[m_Game.Turn]->Action(MJMSG_TSUMO);	//ʒm
	//AIɎwꂽANVs
	Action(m_Game.Turn, m_Game.Player[m_Game.Turn].Action.Type);
	Player->Rinsyan = false;
}
void CMJSim::Ankan(int Index)
{
	MJPLAYER *Player = &m_Game.Player[Index];
	int hai = Player->Action.Hosoku;
	LogHaifu(Index, MJACTION_ANKAN, hai);

	int tsumo = Player->Tsumo;	//cvۑ
	Player->Tehai[tsumo]++;	//cvvɉ
	if(Player->Tehai[hai] < 4){
		cout << "ÃJł܂B";
		throw;
	}
	Player->Tehai[hai] -= 4;	//v폜
	if(hai != tsumo){	//Jvƃc֌WȂꍇAcv폜
		Player->Tehai[tsumo]--;
	}
	int FuroIndex = GetFuroNum(Player->Furo);
	Player->Furo[FuroIndex].Type = MJFORO_ANKAN;
	Player->Furo[FuroIndex].Hai = hai;

	//V
	Player->Tsumo = m_Game.Yama[GetKanNum(&m_Game)];
	Player->Rinsyan = true;

	m_AI[m_Game.Turn]->Action(MJMSG_TSUMO);	//ʒm
	//AIɎwꂽANVs
	Action(m_Game.Turn, m_Game.Player[m_Game.Turn].Action.Type);
	Player->Rinsyan = false;
}
void CMJSim::Kakan(int Index)
{
	MJPLAYER *Player = &m_Game.Player[Index];
	int hai = Player->Action.Hosoku;
	LogHaifu(Index, MJACTION_KAKAN, hai);

	int tsumo = Player->Tsumo;	//cvۑ
	Player->Tehai[tsumo]++;	//cvvɉ

	//J|T
	int FuroIndex = -1;
	for(int i = 0; i < 4; i++){
		if(Player->Furo[i].Type == MJFORO_PON && Player->Furo[i].Hai == hai){
			FuroIndex = i;break;
		}
	}
	if(FuroIndex == -1 || Player->Tehai[hai] < 1){
		cout << "Jł܂B";
		throw;
	}
	Player->Furo[FuroIndex].Type = MJFORO_MINKAN;
	Player->Furo[FuroIndex].Hai = hai;

	Player->Tehai[hai]--;	//v폜
	if(hai != tsumo){	//Jvƃc֌WȂꍇAcv폜
		Player->Tehai[tsumo]--;
	}

	//V
	Player->Tsumo = m_Game.Yama[GetKanNum(&m_Game)];
	Player->Rinsyan = true;

	m_AI[m_Game.Turn]->Action(MJMSG_TSUMO);	//ʒm
	//AIɎwꂽANVs
	Action(m_Game.Turn, m_Game.Player[m_Game.Turn].Action.Type);
	Player->Rinsyan = false;
}
void CMJSim::Chi(int Index)
{
	int hai = m_Game.Player[m_Game.Turn].Kawa[GetLastIndex(m_Game.Player[m_Game.Turn].Kawa) - 1];

	//v폜
	MJPLAYER *Player = &m_Game.Player[Index];
	int FuroIndex = GetFuroNum(Player->Furo);
	for(int i = 0; i < 3; i++){
		if(hai != Player->Action.Hosoku + i){
			//vȊOv폜
			if(Player->Tehai[Player->Action.Hosoku + i] < 1){
				cout << "`[ł܂B";
				throw;
			}
			Player->Tehai[Player->Action.Hosoku + i]--;
		}
		else{
			//3̔v̓AԖڂvZbg
			Player->Furo[FuroIndex].Hosoku = i;
		}
	}
	//t[Zbg
	Player->Furo[FuroIndex].Type = MJFORO_CHI;
	Player->Furo[FuroIndex].Hai = Player->Action.Hosoku;	//`[̐擪v

	//O
	switch(Player->Furo[FuroIndex].Hosoku){
	case 0:	LogHaifu(Index, MJACTION_CHI, Player->Action.Hosoku + 1, Player->Action.Hosoku + 2);break;
	case 1:	LogHaifu(Index, MJACTION_CHI, Player->Action.Hosoku + 0, Player->Action.Hosoku + 2);break;
	case 2:	LogHaifu(Index, MJACTION_CHI, Player->Action.Hosoku + 0, Player->Action.Hosoku + 1);break;
	}

	Sutehai(Index);
}
void CMJSim::Sutehai(int Index)
{
	MJPLAYER *Player = &m_Game.Player[Index];
	
	//c؂
	if(Player->Action.Sutehai == 0){
		LogHaifu(Index, MJACTION_SUTEHAI_TSUMOGIRI, Player->Tsumo);
		Player->Kawa[GetLastIndex(Player->Kawa)] = Player->Tsumo;
		Player->Tsumo = 0;
	}
	else{
		LogHaifu(Index, MJACTION_SUTEHAI, Player->Action.Sutehai);
		Player->Kawa[GetLastIndex(Player->Kawa)] = Player->Action.Sutehai;
		//w肳ꂽv폜
		Player->Tehai[Player->Action.Sutehai]--;
		//cvɒǉĂ(`[Ȃǂ̂Ƃ̓c)
		if(Player->Tsumo != 0){
			Player->Tehai[Player->Tsumo]++;
			Player->Tsumo = 0;
		}
	}
}
int CMJSim::qsort_CalcGameScore(const void *p1, const void *p2)
{
	//p1,p2̓|C^ւ̃|C^
	//~ɕׂ
	return (*(MJPLAYER**)p2)->Score - (*(MJPLAYER**)p1)->Score;
}
void CMJSim::CalcGameScore()
{
	//\[g
	MJPLAYER *p[4];
	int i;
	for(i = 0; i < 4; i++){
		p[i] = &m_Game.Player[i];
	}
	qsort((void*)p, 4, sizeof(MJPLAYER*), qsort_CalcGameScore);

	for(i = 0; i < 4; i++){
		//1000_Pʂ̓_߂
		int uma[] = {8,4,-4,-8};	//ʓ_
		int score = (p[i]->Score - 30000) / 1000 + uma[i];
		if(i == 0){score += (3 * 4);}	//1ʂɃIJ𑫂Ă

		m_Game.GameScore[i].Player = p[i];
		m_Game.GameScore[i].Score = score;
	}
}
string CMJSim::GetTonpuHai(int Hai)
{
	char *t[] = {
		"","1m","2m","3m","4m","5m","6m","7m","8m","9m",
		"","1p","2p","3p","4p","5p","6p","7p","8p","9p",
		"","1s","2s","3s","4s","5s","6s","7s","8s","9s",
		"","","",  "","",  "","",  "k",  "",  "",
		"","","",  "","",  ""
	};
	return t[Hai];
}
string CMJSim::GetTonpuKaze(int Index)
{
	char *t[] = {"","","","k"};
	return t[Index];
}
void CMJSim::LogGameStart()
{
	m_File	<< endl
			<< "===== FLO 300 Jn 2003/01/01 00:00 =====" << endl
			<< "  _27000 ";
	for(int i = 0; i < 4; i++){
		m_File << "[" << i + 1 << "]" << m_AI[i]->m_Name << " R1500 ";
	}
	m_File << endl;
}
void CMJSim::LogKyokuStart()
{
	//Ȃ
}
void CMJSim::LogKyokuEnd()
{
	//ǂ̌
	m_File	<< endl << "  " << GetTonpuKaze(m_Game.Kyoku / 4) << m_Game.Kyoku % 4 + 1 << " "
			<< m_Game.TsumiboNum << "{([`" << m_Game.RichiboNum << ")";
	int i;
	for(i = 0; i < 4; i++){
		if(m_Game.Player[i].KyokuScore != 0){
			m_File	<< " " << m_Game.Player[i].Name << " " << m_Game.Player[i].KyokuScore;
		}
	}
	m_File << endl;

	//オ
	m_File << "    ";
	if(m_Game.IsAgari){
		char *agari[] = {"c",""};
		char *kansuji[] = {"","","","O","l"};
		switch(m_Agari.Han()){
		case 5:
			m_File << "";break;
		case 6:case 7:
			m_File << "";break;
		case 8:case 9:case 10:
			m_File << "{";break;
		case 11:case 12:
			m_File << "";break;
		case 13:
			m_File << "𖞊";break;
		default:
			m_File << m_Agari.Fu() << " "<< kansuji[m_Agari.Han()] << "";
			break;
		}
		m_File << agari[m_Agari.IsRon()] << " ";
		for(i = 0; i < m_Agari.YakuNum(); i++){
			m_File << m_Agari.YakuName(i) << " ";
		}
	}
	else{
		m_File << "";
	}
	m_File << endl;

	//zv
	int k = 0;
	for(i = 0; i < 4; i++){
		m_File << "    [" << i + 1 << GetTonpuKaze(GetZikaze(i, m_Game.Kyoku)) << "]";
		//\[gBqXgO֓
		int hist[46];
		memset(hist, 0, 46 * sizeof(int));
		for(int j = 0; j < 13; j++){
			hist[m_Game.Yama[(i * 13 + j) + 14]]++;
		}
		//O֏o
		for(j = 1; j < 46; j++){
			for(int k = 0; k < hist[j]; k++){
				m_File << GetTonpuHai(j);
			}
		}
		m_File << endl;
	}
	
	//h
    m_File << "    [\h]";
	for(i = 0; i < GetKanNum(&m_Game) + 1; i++){	//ȂƂ1̓h
		m_File << GetTonpuHai(GetDora(i, m_Game.Yama));
	}
    m_File << " [h]";
	for(i = 0; i < GetKanNum(&m_Game) + 1; i++){
		m_File << GetTonpuHai(GetDora(i + 4, m_Game.Yama));
	}
	m_File << endl;

	//v
    m_File << "    * ";
	char *TompuAction[] = {"","R","d","D","C","N","K","A","A","K","K","G"};

	vector<int>::iterator it;
	for(it = m_Log.begin(); it != m_Log.end();){
		m_File << *it + 1;	//vC[ԍ
		it++;
		int action = *it;
		it++;
		m_File << TompuAction[action];	//ANV
		switch(action){
		case MJACTION_TSUMO:
		case MJACTION_SUTEHAI:
		case MJACTION_SUTEHAI_TSUMOGIRI:
		case MJACTION_ANKAN:
		case MJACTION_MINKAN:
			m_File << GetTonpuHai(*it);it++;it++;break;

		case MJACTION_CHI:
			m_File << GetTonpuHai(*it);it++;
			m_File << GetTonpuHai(*it);it++;break;

		case MJACTION_TSUMOAGARI:
		case MJACTION_RON:
		case MJACTION_PON:
		case MJACTION_RICHI:
			it++;it++;break;
		}
		m_File << " ";
	}
	m_File	<< endl;
}
void CMJSim::LogGameEnd()
{
	m_File	<< endl << "  ----  ----" << endl;
	for(int i = 0; i < 4; i++){
		m_File	<< "  " << i + 1 << " "
				<< m_Game.GameScore[i].Player->Name << " "
				<< showpos
				<< m_Game.GameScore[i].Score
				<< noshowpos << endl;
	}
	m_File	<< "----- 300 I 2003/01/01 00:00 -----" << endl;
}
void CMJSim::LogHaifu(int Index,int Action, int Hosoku1, int Hosoku2)
{
	m_Log.push_back(Index);
	m_Log.push_back(Action);
	m_Log.push_back(Hosoku1);
	m_Log.push_back(Hosoku2);
}
int main(int argc, char* argv[])
{
	cout << "MJSim ver 0.1.1" << endl;

	CMJSim Sim;
	Sim.Run();

	return 0;
}
//