<?php
require_once("../require.php");

$session=new Mysession("CONTINUE",false,false);


if(isset($_SESSION['username'])) {

try {
	$dbh = new PDO(PDO_DNS, PDO_USER,PDO_PASS);

	$sql = 'SELECT userid,book_name,date,rental_id FROM rental WHERE userid LIKE :ID  AND rental_flag IS NULL ORDER BY date';
	$sth = $dbh->prepare($sql);
	$sth->bindValue(':ID',$_SESSION['userid']);
	$sth->execute();
	$book_array = $sth->fetchAll(PDO::FETCH_ASSOC);
	
	$sql = 'SELECT username FROM person WHERE userid LIKE :ID'; 
	$sth = $dbh->prepare($sql);
	$sth->bindValue(':ID',$_SESSION['userid']);
	$sth->execute();
	$username = $sth->fetch(PDO::FETCH_ASSOC);
	

	$day = new Myday();
	
	$today = $day->getdate(array("day"=>-4));
	

	 $over_array = array();
	$book_count = count($book_array);

	//借りられる日付がオーバーしていないかを見る
	 for($i=0;$i<$book_count;$i++){
	 	
	$over_day = $day -> date_compared($today,$book_array[$i]['date'] ); 

		if($over_day > 0) {
		$book_array[$i]['over'] = 'true';
		$book_array[$i]['period'] = $over_day;
		$over_book = true;
	
	}	else {

		$book_array[$i]['over'] = 'false';
		$book_array[$i]['period'] = -1 * $over_day."日以内に返却";
		
	}
	}


}

catch (PDOException $e)  {
	echo $e->getMessage();

}

$dbh = null;
}

/*smarty*/

$smarty->assign("title","TOP"); //headerのtitle
$smarty->assign("pagename","index");//pageの名前
$smarty->assign("book_count",$book_count);
$smarty->assign("book_data",$book_array);//DBから取得した本のレンタルデータ

$smarty->assign("session_status",$session->getstatus());
$smarty->assign("over_book",$over_book);
$smarty->assign("username",$username['username']);

$smarty->display("index.tpl");

?>

