<?php
/**	TODO
 *	オブジェクトの呼び出し
 *	DBの場合の呼び出し
 *	データを取得する
 *	セッションをはじめる
 *	セッションにデータを渡す
 *	セッションを終了する
 *	状態を確認する
 *	セッションの名前を変更する
 *	PDOを呼び出す
 *	ユーザ名とパスワードをデータベースから取得する
*	エラーメッセージを作る
*	セッションにユーザ名をセットする	
 *	ログイン画面を作る
 *	ログアウト画面を作る
 *	状態変化画面を作る
 *	ログインする
 *	状態変化画面でメッセージが切り替わるかを見る
*	ログアウトする
*	状態変化画面でメッセージが切り替わって、クッキーが消されているかを見る
?	中継ページか、リロードをした方がよいかもしれない
*	チケットをつける
*	MD5で暗号化する(できればMD5以外)
*       セットセッションに関連するデータ以外を消去する		

 **/

require_once("Mysession_db.php");



class Mysession	 {
	
	//セッションの状態
	protected  $status='none';
	
	//認証時のエラーメッセージ
	protected  $errmsg;
	
	//セッションにセットするユーザid
	protected  $username  ;

	protected $userid;

	//セッションのチケット
	#protected $tiket = MySESSION::SESSION_PASS;
	protected $tiket = SESSIONPASS;
	
	const ERROR_MISS = "パスワードかIDが違います";
	


	function __construct($var,$parms,$flag) {

		if($flag == true) {
		$parms['userpass'] = md5($parms['userpass']);
		}

		if($var != 'LOGINED'){
		$this->start();
		}

		if($var == 'DB') {
		$this->db_controller($parms);
		} elseif ($var == 'LOGINED') {
		
		$this->session_empty();
		}
	}

	function __destruct() {
		
			
	}



	//セッションを始める
	function start() {

		session_start();
		session_regenerate_id();


	}



	//セッションを終了させる
	function stop() {

		$_SESSION = array();

		if (isset($_COOKIE[session_name()])) {
			setcookie(session_name(),'',time()-3600, '/');

		}

		session_destroy();



	}	




	//usernameとtiket以外を空にする
	function session_empty() {

		$this->username = $_SESSION['username'];
		$this->userid   = $_SESSION['userid'];
		
		$_SESSION = array();
		$this->setsession($this->userid,$this->username);
	}


		

	//セッションにユーザ名などをセットする
	function setsession($id,$name) {
		
		$_SESSION['userid'] = $id;
		$_SESSION['username'] = $name;
		$_SESSION['tiket'] = $this->tiket;

	}
	
	//セッションにデータをセットする
	function setdata($name,$data) {

		$_SESSION[$name] = $data;

	}

	//sessionの名前を変更する 

	function setname($name) {

		session_name($name);

	}

	//セッションの状態を確認する
	function getstatus() {

		if ($_SESSION['tiket'] == SESSIONPASS) {

			$this->status = true;

		} else { 

			$this->status = false;

		}

		return $this->status;

	}
	
	function geterrmsg() {
		
		if($this->errmsg !== true) {
			return $this->errmsg;
		}
	}

}


