/*
 * Decompiled with CFR 0.152.
 */
import com.docomostar.StarApplication;
import com.docomostar.opt.ui.TouchDevice;
import com.docomostar.ui.Canvas;
import com.docomostar.ui.Component;
import com.docomostar.ui.Dialog;
import com.docomostar.ui.Display;
import com.docomostar.ui.Frame;
import com.docomostar.ui.Graphics;
import com.docomostar.ui.HTMLLayout;
import com.docomostar.ui.LayoutManager;
import com.docomostar.ui.Panel;
import com.docomostar.ui.SoftKeyListener;
import com.docomostar.ui.TextBox;

public class FlickPrototype
extends StarApplication {
    static int X = 480;
    static int Y = 854;
    FlickPrototypeCanvas flickPrototypeCanvas;
    FlickPrototypePanel flickPrototypePanel;
    String inputString = "";

    public void started(int launchType) {
        this.flickPrototypeCanvas = new FlickPrototypeCanvas();
        this.flickPrototypePanel = new FlickPrototypePanel();
        Display.setCurrent((Frame)this.flickPrototypeCanvas);
        try {
            if (TouchDevice.isAvailable()) {
                TouchDevice.setEnabled((boolean)true);
            }
        }
        catch (Exception e) {
            Dialog d = new Dialog(1, "error");
            d.setText("\u30bf\u30c3\u30c1\u30c7\u30d0\u30a4\u30b9\u3092\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\uff0e");
            d.show();
            this.terminate();
        }
    }

    class FlickPrototypePanel
    extends Panel
    implements SoftKeyListener {
        HTMLLayout lm;
        private TextBox textBox;

        public FlickPrototypePanel() {
            this.setTitle("FlickPrototype");
            this.textBox = new TextBox("", 20, 10, 0);
            this.textBox.setInputMode(2);
            this.lm = new HTMLLayout();
            this.setLayoutManager((LayoutManager)this.lm);
            this.lm.begin("CENTER");
            this.add((Component)this.textBox);
            this.lm.end();
            this.setSoftLabel(0, "\u623b\u308b");
            this.setSoftKeyListener(this);
        }

        public void setText(String string) {
            this.textBox.setText(string);
        }

        public void softKeyPressed(int softKey) {
        }

        public void softKeyReleased(int softKey) {
            if (softKey == 0) {
                FlickPrototype.this.inputString = this.textBox.getText();
                Display.setCurrent((Frame)FlickPrototype.this.flickPrototypeCanvas);
            }
        }
    }

    class FlickPrototypeCanvas
    extends Canvas {
        int buttonWidth = 96;
        int buttonHeight = 96;
        int buttonNumCol = 5;
        int buttonNumRow = 5;
        int buttonOffsetX = 0;
        int buttonOffsetY = Y - this.buttonHeight * this.buttonNumRow - 1;
        String[][][] buttonStr = new String[][][]{{{"", "", "", "", ""}, {"", "\u3042", "\u304b", "\u3055", ""}, {"", "\u305f", "\u306a", "\u306f", ""}, {"", "\u307e", "\u3084", "\u3089", ""}, {"", "", "\u308f", "", ""}}, {{"", "\u3046", "", "", ""}, {"\u3044", "\u3042", "\u3048", "", ""}, {"", "\u304a", "", "", ""}, {"", "", "", "", ""}, {"", "", "", "", ""}}, {{"", "", "\u304f", "", ""}, {"", "\u304d", "\u304b", "\u3051", ""}, {"", "", "\u3053", "", ""}, {"", "", "", "", ""}, {"", "", "", "", ""}}, {{"", "", "", "\u3059", ""}, {"", "", "\u3057", "\u3055", "\u305b"}, {"", "", "", "\u305d", ""}, {"", "", "", "", ""}, {"", "", "", "", ""}}, {{"", "", "", "", ""}, {"", "\u3064", "", "", ""}, {"\u3061", "\u305f", "\u3066", "", ""}, {"", "\u3068", "", "", ""}, {"", "", "", "", ""}}, {{"", "", "", "", ""}, {"", "", "\u306c", "", ""}, {"", "\u306b", "\u306a", "\u306d", ""}, {"", "", "\u306e", "", ""}, {"", "", "", "", ""}}, {{"", "", "", "", ""}, {"", "", "", "\u3075", ""}, {"", "", "\u3072", "\u306f", "\u3078"}, {"", "", "", "\u307b", ""}, {"", "", "", "", ""}}, {{"", "", "", "", ""}, {"", "", "", "", ""}, {"", "\u3080", "", "", ""}, {"\u307f", "\u307e", "\u3081", "", ""}, {"", "\u3082", "", "", ""}}, {{"", "", "", "", ""}, {"", "", "", "", ""}, {"", "", "\u3086", "", ""}, {"", "", "\u3084", "", ""}, {"", "", "\u3088", "", ""}}, {{"", "", "", "", ""}, {"", "", "", "", ""}, {"", "", "", "\u308b", ""}, {"", "", "\u308a", "\u3089", "\u308c"}, {"", "", "", "\u308d", ""}}, {{"", "", "", "", ""}, {"", "", "", "", ""}, {"", "", "", "", ""}, {"", "", "", "", ""}, {"", "\u3093", "\u308f", "\u3092", ""}}};
        int[][] toFace;
        boolean touchPressed;
        int touchRow;
        int touchCol;
        int face;

        public FlickPrototypeCanvas() {
            int[][] nArrayArray = new int[5][];
            nArrayArray[0] = new int[5];
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArrayArray[1] = nArray;
            int[] nArray2 = new int[5];
            nArray2[1] = 4;
            nArray2[2] = 5;
            nArray2[3] = 6;
            nArrayArray[2] = nArray2;
            int[] nArray3 = new int[5];
            nArray3[1] = 7;
            nArray3[2] = 8;
            nArray3[3] = 9;
            nArrayArray[3] = nArray3;
            int[] nArray4 = new int[5];
            nArray4[2] = 10;
            nArrayArray[4] = nArray4;
            this.toFace = nArrayArray;
            this.touchPressed = false;
            this.touchRow = 0;
            this.touchCol = 0;
            this.face = 0;
            this.setSoftLabel(0, "\u7de8\u96c6");
            this.setSoftLabel(1, "\u7d42\u4e86");
            this.setSoftLabel(4, "\u6d88\u53bb");
        }

        public void paint(Graphics g) {
            g.lock();
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            int row = 0;
            while (row < this.buttonNumRow) {
                int col = 0;
                while (col < this.buttonNumCol) {
                    this.paintButton(g, row, col, this.buttonStr[this.face][row][col], false);
                    ++col;
                }
                ++row;
            }
            int length = FlickPrototype.this.inputString.length();
            int i = 0;
            while (i < 10) {
                int j = 0;
                while (j < 20) {
                    int index = i * 20 + j;
                    if (index < length) {
                        g.drawString(FlickPrototype.this.inputString.substring(index, index + 1), j * 24, i * 30 + 30);
                    }
                    ++j;
                }
                ++i;
            }
            g.unlock(true);
        }

        private void paintButton(Graphics g, int row, int col, String s, boolean fill) {
            int x = this.buttonOffsetX + col * this.buttonWidth;
            int y = this.buttonOffsetY + row * this.buttonHeight;
            if (fill) {
                g.fillRect(x, y, this.buttonWidth, this.buttonHeight);
                g.setColor(Graphics.getColorOfName((int)7));
                g.drawString(s, x + 20, y + 60);
                g.setColor(Graphics.getColorOfName((int)0));
            } else {
                g.drawRect(x, y, this.buttonWidth, this.buttonHeight);
                g.drawString(s, x + 35, y + 60);
            }
        }

        private int xToCol(int x) {
            return (x - this.buttonOffsetX) / this.buttonWidth;
        }

        private int yToRow(int y) {
            return (y - this.buttonOffsetY) / this.buttonHeight;
        }

        private int toNextFace(int row, int col) {
            return this.toFace[row][col];
        }

        public void processEvent(int type, int param) {
            try {
                if (type == 1) {
                    switch (param) {
                        case 21: {
                            FlickPrototype.this.flickPrototypePanel.setText(FlickPrototype.this.inputString);
                            Display.setCurrent((Frame)FlickPrototype.this.flickPrototypePanel);
                            break;
                        }
                        case 22: {
                            FlickPrototype.this.terminate();
                            break;
                        }
                        case 20: {
                            FlickPrototype.this.inputString = "";
                            this.repaint();
                        }
                    }
                } else if (type == 67) {
                    this.touchPressed = true;
                    this.face = this.toNextFace(this.yToRow(TouchDevice.getY()), this.xToCol(TouchDevice.getX()));
                    this.repaint();
                } else if (type != 69 && type != 70 && type == 68) {
                    this.touchCol = this.xToCol(TouchDevice.getX());
                    this.touchRow = this.yToRow(TouchDevice.getY());
                    FlickPrototype.this.inputString = String.valueOf(FlickPrototype.this.inputString) + this.buttonStr[this.face][this.touchRow][this.touchCol];
                    this.face = 0;
                    this.touchPressed = false;
                    this.repaint();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

