#ifndef __XFILETRANSLATOR_H__
#define __XFILETRANSLATOR_H__

#include <windows.h>
#include <dxfile.h>
#include <maya/MPxFileTranslator.h>

//---- inserted by djmartin (12/13/2001) --------------------------------------
//#define KAYA
//-----------------------------------------------------------------------------

#ifdef KAYA
const PCHAR g_szCamera_c = "camera1";
const PCHAR g_szFace_c = "FaceSmoothShape";
const PCHAR g_szLeftShoulder_c = "nurbsToPolyShape36";
const PCHAR g_szRightShoulder_c = "nurbsToPolyShape35";
const PCHAR g_szCollar_c = "nurbsToPolyShape34";
const PCHAR g_szLeftEyeball_c = "nurbsToPolyShape42";
const PCHAR g_szRightEyeball_c = "nurbsToPolyShape43";
const PCHAR g_szBackground_c = "nurbsToPolyShape39";
const PCHAR g_szCapLoop_c = "nurbsToPolyShape29";
const PCHAR g_szCap_c = "nurbsToPolyShape28";
const PCHAR g_szCapLining_c = "nurbsToPolyShape27";
const PCHAR g_szTongue_c = "linguaShape";
const PCHAR g_szOuterHair_c = "nurbsToPolyShape40";
const PCHAR g_szInnerHair_c = "nurbsToPolyShape41";
#endif

#define WRITE(type, pb, val)	do { *((type*)pb) = val;	pb = (PBYTE)(((type*)pb) + 1); } while(0)

#define SAFE_RELEASE(p)         do { if (NULL != (p)) { (p)->Release(); (p) = NULL; } } while(0)
#define SAFE_DELETE(p)          do { if (NULL != (p)) { delete (p); (p) = NULL; } } while(0)
#define SAFE_DELETE_ARRAY(p)    do { if (NULL != (p)) { delete[] (p); (p) = NULL; } } while(0)

#define	SCENE_ROOT	"SCENE_ROOT"

typedef FLOAT FLOAT2[2];
typedef FLOAT FLOAT3[3];
typedef FLOAT FLOAT4[4];


//-----------------------------------------------------------------------------
// Name: xfileTranslator (class)
// Desc: An interface class for our Maya XFile Exporter
//-----------------------------------------------------------------------------

class xfileTranslator: public MPxFileTranslator 
{
private:
	HRESULT ParseOptions(MString msOptions);

public:
	xfileTranslator(){};	// constructor
   ~xfileTranslator(){};	// destructor

	static void *creator()	
		{ return new xfileTranslator(); };
	MStatus reader(const MFileObject& file, const MString& optionsString, MPxFileTranslator::FileAccessMode mode)
		{ return MS::kSuccess; };
	MStatus writer(const MFileObject& file, const MString& optionsString, MPxFileTranslator::FileAccessMode mode);
	bool haveReadMethod() const 
		{ return false; };
	bool haveWriteMethod() const 
		{ return true; };
	bool canBeOpened() const 
		{ return false; };
	MString defaultExtension() const 
		{ return ""; };
	MFileKind identifyFile (const MFileObject& fileName, const char *buffer, short size) const 
		{ return kIsMyFileType; };
};



//-----------------------------------------------------------------------------
// Name: SRep (struct)
// Desc: Stores a list of vertex duplication indices (a.k.a. "point reps")
//-----------------------------------------------------------------------------

struct SRep 
{
	DWORD m_iUV;	// index into lump of texture coordinates 
	DWORD m_iNorm;	// index into lump of normals
	DWORD m_iNext;	// next repetition
	DWORD m_iFirst;	// can also be thought of as "index into lump of vertices";

	// IMPORTANT: the following members are only valid in the instances corresponding to the first rep's.
	DWORD m_cReps;					
};



//-----------------------------------------------------------------------------
// Name: SFace (struct)
// Desc: Stores the vertex indices and the material of a polygon
//-----------------------------------------------------------------------------

struct SFace 
{
	DWORD  m_cIndices;  // number of vertices in this face
	DWORD *m_pIndices;  // array of indices
	DWORD  m_iGroup;    // material group

	SFace();
   ~SFace();
};



//-----------------------------------------------------------------------------
// Name: SGroup (struct)
// Desc: Stores the surface attributes of a material
//-----------------------------------------------------------------------------

struct SGroup 
{
	PCHAR  m_szName;        // material name
	PCHAR  m_szTextureFile;	// texture file name
	FLOAT3 m_f3Diffuse;     // diffuse
	FLOAT3 m_f3Specular;    // specular
	FLOAT3 m_f3Emissive;    // emissive
	FLOAT  m_fShininess;    // specular power
	FLOAT  m_fTransparency; // transparency

    SGroup();
   ~SGroup();
};



//-----------------------------------------------------------------------------
// Name: SBone (struct)
// Desc: Stores the vertices affected by a bone and the corresponding weights
//-----------------------------------------------------------------------------

struct SBone 
{
	PCHAR  m_szName;            // bone name
	DWORD  m_cReps;             // number of reps influenced
	DWORD  m_cWeights;          // number of points influenced
	DWORD *m_piPoints;          // array of indices of affected vertices
	FLOAT *m_pfWeights;         // array of weights of affected vertices
	FLOAT  m_ppfOffset[4][4];   // inverse of bone's world coordinate transform at the time of binding

	SBone();
   ~SBone();
};



//-----------------------------------------------------------------------------
// Name: SShape (struct)
// Desc: Stores the data for a various shape types (such as poly mesh)
//-----------------------------------------------------------------------------

struct SShape 
{
	enum Type
	{
		UNKNOWN,
		MESH,		// polygon mesh
		PATCHES,	// bi-cubic bezier patch mesh
		NURBS,		// NURBS surface
		SUBD		// subdivision surface
	};

	Type    m_kType;
	PCHAR   m_szName;

    // control point info
	DWORD   m_cReps;
	SRep   *m_pReps;            // point reps (vertex duplication indices)
	DWORD   m_cPoints;
	FLOAT3 *m_pPoints;          // positions
	DWORD   m_cNormals;
	FLOAT3 *m_pNormals;         // normals
	DWORD   m_cUVs;
	FLOAT2 *m_pUVs;             // texture coordinates
	DWORD   m_cVertexColors;
	FLOAT4 *m_pVertexColors;    // vertex colors

    // face info
	DWORD   m_cFaces;
	SFace  *m_pFaces;           // face indices (indexed into the point rep array)
	DWORD   m_cFaceIndices;		// total number of face indices (over all faces).

    // material info
	DWORD   m_cGroups;
	SGroup *m_pGroups;		    // materials

    // skinning info
	DWORD   m_cBones;
	SBone  *m_pBones;           // bones
	DWORD   m_cMaxBonesPerFace;
	DWORD   m_cMaxBonesPerPoint;

	SShape();
   ~SShape();
};



//-----------------------------------------------------------------------------
// Name: SKey (struct)
// Desc: Stores the values of a particular TRS animation key
//-----------------------------------------------------------------------------

struct SKey 
{
#ifdef KAYA
    SKey();
   ~SKey();

    DWORD   m_cBlendWts;        // number of blend weights (from a blendShape node)
    PFLOAT  m_rgfBlendWts;      // list of blend weights
#endif
	DWORD   m_iFrame;           // time (in frames)
	FLOAT3  m_f3Translation;    // translation
	FLOAT3  m_f3Scale;          // scale
	FLOAT4  m_f4Orientation;    // quaternion rotation
	FLOAT3  m_f3Euler;		    // euler angles (in radians)
	DWORD   m_dwEulerOrder;	    // order of euler rotations (XYZ = 0, YZX = 1, ZXY = 2, XZY = 3, YXZ = 4, ZYX = 5)
	bool    m_pbDOFs[3];		// DOFs for euler rotations
};



//-----------------------------------------------------------------------------
// Name: SAnim (struct)
// Desc: Stores a sequence of TRS animation keys for a frame
//-----------------------------------------------------------------------------

struct SAnim 
{
    SAnim();
   ~SAnim();

	PCHAR m_szName;	// name of the frame that's being animated
	DWORD m_cKeys;	// number of keys
	SKey *m_pKeys;	// TRS keys (see SKey)
};



//-----------------------------------------------------------------------------
// Name: CArrayTable (class)
// Desc: Used to keep arrays persistent for the duration of the export
//-----------------------------------------------------------------------------

class CArrayTable
{
private:
	PBYTE *m_ppbTable;
	DWORD  m_cUsed;
	DWORD  m_cSize;

public:
	CArrayTable();	// contstructor
   ~CArrayTable();	// destructor

	HRESULT Init();
	HRESULT Nuke();
	HRESULT Add(PVOID pb);
};


#endif