(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42988,       1001]
NotebookOptionsPosition[     42335,        974]
NotebookOutlinePosition[     42689,        990]
CellTagsIndexPosition[     42646,        987]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "DyGeom.m"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MyTeXFileName", "=", "\"\<pascal_fig.tex\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KetpicPictureSize", "=", "\"\<3cm\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MakeConstruction", "[", "xx_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "g1", ",", "g2", ",", "p1", ",", "p2", ",", "p3", ",", "p4", ",", "p5", 
      ",", "p6", ",", "l1", ",", "l2", ",", "q1", ",", "l3", ",", "l4", ",", 
      "q2", ",", "l5", ",", "l6", ",", "q3", ",", "ll"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"g1", "=", 
      RowBox[{"FunctionGraph", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"0.5", "*", 
           RowBox[{"x", "^", "2"}]}], "+", "1"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"target", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.5"}], ",", "4"}], "}"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"g2", "=", 
      RowBox[{"FunctionGraph", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"0.5", "*", 
            RowBox[{"x", "^", "2"}]}], "+", "1"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"target", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.5"}], ",", "4"}], "}"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p1", "=", 
      RowBox[{"PointOnFunctionGraph", "[", 
       RowBox[{"g1", ",", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{"xx", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p2", "=", 
      RowBox[{"PointOnFunctionGraph", "[", 
       RowBox[{"g1", ",", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{"xx", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p3", "=", 
      RowBox[{"PointOnFunctionGraph", "[", 
       RowBox[{"g1", ",", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{"xx", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p4", "=", 
      RowBox[{"PointOnFunctionGraph", "[", 
       RowBox[{"g2", ",", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{"xx", "[", 
           RowBox[{"[", "6", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p5", "=", 
      RowBox[{"PointOnFunctionGraph", "[", 
       RowBox[{"g2", ",", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{"xx", "[", 
           RowBox[{"[", "5", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p6", "=", 
      RowBox[{"PointOnFunctionGraph", "[", 
       RowBox[{"g2", ",", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{"xx", "[", 
           RowBox[{"[", "4", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"l1", "=", 
      RowBox[{"\:7dda\:5206", "[", 
       RowBox[{"p1", ",", "p5"}], "]"}]}], ";", 
     RowBox[{"l2", "=", 
      RowBox[{"\:7dda\:5206", "[", 
       RowBox[{"p2", ",", "p4"}], "]"}]}], ";", 
     RowBox[{"q1", "=", 
      RowBox[{"\:4ea4\:70b9", "[", 
       RowBox[{"l1", ",", "l2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"l3", "=", 
      RowBox[{"\:7dda\:5206", "[", 
       RowBox[{"p1", ",", "p6"}], "]"}]}], ";", 
     RowBox[{"l4", "=", 
      RowBox[{"\:7dda\:5206", "[", 
       RowBox[{"p3", ",", "p4"}], "]"}]}], ";", 
     RowBox[{"q2", "=", 
      RowBox[{"\:4ea4\:70b9", "[", 
       RowBox[{"l3", ",", "l4"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"l5", "=", 
      RowBox[{"\:7dda\:5206", "[", 
       RowBox[{"p2", ",", "p6"}], "]"}]}], ";", 
     RowBox[{"l6", "=", 
      RowBox[{"\:7dda\:5206", "[", 
       RowBox[{"p3", ",", "p5"}], "]"}]}], ";", 
     RowBox[{"q3", "=", 
      RowBox[{"\:4ea4\:70b9", "[", 
       RowBox[{"l5", ",", "l6"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ll", "=", 
      RowBox[{"\:7dda\:5206", "[", 
       RowBox[{"q1", ",", "q3", ",", 
        RowBox[{"clipping", "\[Rule]", 
         RowBox[{"{", "q2", "}"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "p1", ",", "p2", ",", "p3", ",", "p4", ",", "p5", ",", "p6", ",", "l1", 
       ",", "l2", ",", "l3", ",", "l4", ",", "l5", ",", "l6", ",", "ll", ",", 
       "q1", ",", "q2", ",", "q3", ",", "g1", ",", "g2"}], "}"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"MakeGraphics", "[", 
      RowBox[{"MakeConstruction", "[", "pts", "]"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pts", ",", 
       RowBox[{"NewPoints", "[", "6", "]"}]}], "}"}], ",", "Locator"}], "}"}],
    ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Save the figure\>\"", ",", 
     RowBox[{"DrawConstruction", "[", 
      RowBox[{"MakeConstruction", "[", "pts", "]"}], "]"}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.49880566537*^9, 3.4988059892939997`*^9}, {
   3.498806022236*^9, 3.498806063929*^9}, {3.498806126487*^9, 
   3.4988061277019997`*^9}, {3.4988061723719997`*^9, 
   3.4988061931219997`*^9}, {3.5228438222066016`*^9, 3.522843977590602*^9}, 
   3.5228440570886016`*^9, {3.5228440933196015`*^9, 3.522844119366602*^9}, {
   3.522878112479602*^9, 3.5228781597376013`*^9}, {3.5228782015276017`*^9, 
   3.5228782045876017`*^9}, {3.522879686913602*^9, 3.5228797074046016`*^9}, {
   3.5228800679546013`*^9, 3.5228800686796017`*^9}, {3.5228808636436014`*^9, 
   3.5228808644156017`*^9}, {3.5228809063266015`*^9, 3.522880915901602*^9}, {
   3.5228809677546015`*^9, 3.522880969611602*^9}, {3.5358787916387672`*^9, 
   3.5358788221797667`*^9}, {3.5358788987387667`*^9, 3.535878952627767*^9}, {
   3.535879092153767*^9, 3.535879097706767*^9}, {3.535879156244767*^9, 
   3.535879161137767*^9}, {3.5358794284597673`*^9, 3.535879447434767*^9}, {
   3.535879753809767*^9, 3.535879820534767*^9}, {3.535879865515767*^9, 
   3.535879954854767*^9}, {3.5358801665147667`*^9, 3.535880167825767*^9}, {
   3.5358802139667673`*^9, 3.535880227310767*^9}, {3.535880714475767*^9, 
   3.535880742633767*^9}, {3.535880775343767*^9, 3.535880776670767*^9}, {
   3.535881281719767*^9, 3.535881293829767*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pts$$ = {{0.6234898018587335, 
    0.7818314824680298}, {-0.2225209339563144, 
    0.9749279121818236}, {-0.8899999999999999, 
    0.8300000000000001}, {-0.9009688679024191, -0.4338837391175581}, \
{-0.2225209339563144, -0.9749279121818236}, {
    0.6234898018587335, -0.7818314824680298}}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`pts$$], {{
         Sin[Rational[3, 14] Pi], 
         Cos[Rational[3, 14] Pi]}, {-Sin[Rational[1, 14] Pi], 
         Cos[Rational[1, 14] Pi]}, {-Cos[Rational[1, 7] Pi], 
         Sin[Rational[1, 7] Pi]}, {-Cos[Rational[1, 7] Pi], -
         Sin[Rational[1, 7] Pi]}, {-Sin[Rational[1, 14] Pi], -
         Cos[Rational[1, 14] Pi]}, {
         Sin[Rational[3, 14] Pi], -Cos[Rational[3, 14] Pi]}}}, Automatic}, {
      Hold[
       Button["Save the figure", 
        $CellContext`DrawConstruction[
         $CellContext`MakeConstruction[$CellContext`pts$$]]]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`pts$$ = {{
           Sin[Rational[3, 14] Pi], 
           Cos[Rational[3, 14] Pi]}, {-Sin[Rational[1, 14] Pi], 
           Cos[Rational[1, 14] Pi]}, {-Cos[Rational[1, 7] Pi], 
           Sin[Rational[1, 7] Pi]}, {-Cos[Rational[1, 7] Pi], -
           Sin[Rational[1, 7] Pi]}, {-Sin[Rational[1, 14] Pi], -
           Cos[Rational[1, 14] Pi]}, {
           Sin[Rational[3, 14] Pi], -Cos[Rational[3, 14] Pi]}}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        $CellContext`MakeGraphics[
         $CellContext`MakeConstruction[$CellContext`pts$$]], PlotRange -> 2], 
      "Specifications" :> {{{$CellContext`pts$$, {{
            Sin[Rational[3, 14] Pi], 
            Cos[Rational[3, 14] Pi]}, {-Sin[Rational[1, 14] Pi], 
            Cos[Rational[1, 14] Pi]}, {-Cos[Rational[1, 7] Pi], 
            Sin[Rational[1, 7] Pi]}, {-Cos[Rational[1, 7] Pi], -
            Sin[Rational[1, 7] Pi]}, {-Sin[Rational[1, 14] Pi], -
            Cos[Rational[1, 14] Pi]}, {
            Sin[Rational[3, 14] Pi], -Cos[Rational[3, 14] Pi]}}}, Automatic, 
         ControlType -> Locator}, 
        Button["Save the figure", 
         $CellContext`DrawConstruction[
          $CellContext`MakeConstruction[$CellContext`pts$$]]]}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{408., {225., 230.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.498805976234*^9, 3.498805989553*^9}, 
   3.4988060344519997`*^9, 3.4988060662799997`*^9, 3.498806129028*^9, 
   3.498806194802*^9, 3.5228439801576014`*^9, 3.522844060743602*^9, {
   3.5228440941126013`*^9, 3.522844120932602*^9}, 3.522878046552602*^9, 
   3.522878128828602*^9, 3.522878160420602*^9, 3.5228782057386017`*^9, 
   3.522880069387602*^9, {3.5228808499076014`*^9, 3.522880865342602*^9}, 
   3.5228809170896015`*^9, {3.5228809704756017`*^9, 3.5228809941406016`*^9}, 
   3.5358788230547667`*^9, {3.535878922097767*^9, 3.535878958137767*^9}, {
   3.535879075258767*^9, 3.535879117373767*^9}, 3.5358791618017673`*^9, {
   3.5358794299807673`*^9, 3.535879448746767*^9}, 3.535879488022767*^9, 
   3.5358795311917667`*^9, 3.535879757270767*^9, {3.535879794985767*^9, 
   3.5358799564887667`*^9}, 3.535880169147767*^9, 3.535880228476767*^9, 
   3.5358805438747673`*^9, 3.5358806788167667`*^9, {3.535880725608767*^9, 
   3.535880743745767*^9}, 3.535880778229767*^9, 3.535881001524767*^9, 
   3.535881294739767*^9, 3.535916766010767*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.535879840503767*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeConstruction", "[", 
  RowBox[{"NewPoints", "[", "6", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.535880012699767*^9, 3.5358800249627666`*^9}, {
  3.5358801062317667`*^9, 3.5358801126137667`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.6234898018587335`", ",", "1.092872255348685`"}], "}"}], ",", 
     "0.05`"}], "]"}], ",", 
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2225209339563144`"}], ",", "1.0123032070602143`"}], 
      "}"}], ",", "0.05`"}], "]"}], ",", 
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9009688679024191`"}], ",", "1.1856949230154792`"}], 
      "}"}], ",", "0.05`"}], "]"}], ",", 
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.6234898018587335`", ",", 
       RowBox[{"-", "1.092872255348685`"}]}], "}"}], ",", "0.05`"}], "]"}], 
   ",", 
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2225209339563144`"}], ",", 
       RowBox[{"-", "1.0123032070602143`"}]}], "}"}], ",", "0.05`"}], "]"}], 
   ",", 
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9009688679024191`"}], ",", 
       RowBox[{"-", "1.1856949230154792`"}]}], "}"}], ",", "0.05`"}], "]"}], 
   ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.6234898018587335`", ",", "1.092872255348685`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.2225209339563144`"}], ",", 
        RowBox[{"-", "1.0123032070602143`"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.2225209339563144`"}], ",", "1.0123032070602143`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.6234898018587335`", ",", 
        RowBox[{"-", "1.092872255348685`"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.6234898018587335`", ",", "1.092872255348685`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.9009688679024191`"}], ",", 
        RowBox[{"-", "1.1856949230154792`"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.9009688679024191`"}], ",", "1.1856949230154792`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.6234898018587335`", ",", 
        RowBox[{"-", "1.092872255348685`"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.2225209339563144`"}], ",", "1.0123032070602143`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.9009688679024191`"}], ",", 
        RowBox[{"-", "1.1856949230154792`"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.9009688679024191`"}], ",", "1.1856949230154792`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.2225209339563144`"}], ",", 
        RowBox[{"-", "1.0123032070602143`"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5349848118638751`"}], ",", "0.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.1842952181248834`", ",", "0.`"}], "}"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.1842952181248834`", ",", "0.`"}], "}"}], ",", "0.05`"}], 
    "]"}], ",", 
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.10768837029584591`"}], ",", "0.`"}], "}"}], ",", 
     "0.05`"}], "]"}], ",", 
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5349848118638751`"}], ",", "0.`"}], "}"}], ",", 
     "0.05`"}], "]"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.`"}], ",", "1.7320508075688772`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.9`"}], ",", "1.6748134224444224`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.8`"}], ",", "1.6186414056238645`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.7`"}], ",", "1.563649577111189`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.6`"}], ",", "1.50996688705415`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5`"}], ",", "1.4577379737113252`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.4`"}], ",", "1.407124727947029`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.3`"}], ",", "1.3583077707206126`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.2`"}], ",", "1.3114877048604001`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.0999999999999999`"}], ",", "1.2668859459319928`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.`"}], ",", "1.224744871391589`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.8999999999999999`"}], ",", "1.1853269591129698`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.7999999999999999`"}], ",", "1.1489125293076057`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.7`"}], ",", "1.1157956802210698`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5999999999999999`"}], ",", "1.0862780491200215`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.4999999999999999`"}], ",", "1.0606601717798212`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.3999999999999999`"}], ",", "1.0392304845413265`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.29999999999999993`"}], ",", "1.0222524150130436`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.1999999999999999`"}], ",", "1.0099504938362078`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.0999999999999999`"}], ",", "1.002496882788171`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.1102230246251565`*^-16", ",", "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.10000000000000012`", ",", "1.002496882788171`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.20000000000000012`", ",", "1.0099504938362078`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.30000000000000016`", ",", "1.0222524150130436`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.40000000000000013`", ",", "1.0392304845413265`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.5000000000000001`", ",", "1.0606601717798212`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.6000000000000001`", ",", "1.0862780491200217`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.7000000000000002`", ",", "1.11579568022107`"}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"0.8000000000000002`", ",", "1.1489125293076057`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.9000000000000001`", ",", "1.1853269591129698`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"1.0000000000000002`", ",", "1.2247448713915892`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"1.1`", ",", "1.2668859459319928`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.2000000000000002`", ",", "1.3114877048604001`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"1.3000000000000003`", ",", "1.3583077707206126`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"1.4000000000000001`", ",", "1.407124727947029`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"1.5000000000000002`", ",", "1.4577379737113252`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"1.6`", ",", "1.50996688705415`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.7000000000000002`", ",", "1.5636495771111891`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"1.8000000000000003`", ",", "1.6186414056238647`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"1.9000000000000001`", ",", "1.6748134224444227`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", "1.7320508075688772`"}], "}"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.`"}], ",", 
        RowBox[{"-", "1.7320508075688772`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.9`"}], ",", 
        RowBox[{"-", "1.6748134224444224`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.8`"}], ",", 
        RowBox[{"-", "1.6186414056238645`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.7`"}], ",", 
        RowBox[{"-", "1.563649577111189`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.6`"}], ",", 
        RowBox[{"-", "1.50996688705415`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5`"}], ",", 
        RowBox[{"-", "1.4577379737113252`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.4`"}], ",", 
        RowBox[{"-", "1.407124727947029`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.3`"}], ",", 
        RowBox[{"-", "1.3583077707206126`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.2`"}], ",", 
        RowBox[{"-", "1.3114877048604001`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.0999999999999999`"}], ",", 
        RowBox[{"-", "1.2668859459319928`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.`"}], ",", 
        RowBox[{"-", "1.224744871391589`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.8999999999999999`"}], ",", 
        RowBox[{"-", "1.1853269591129698`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.7999999999999999`"}], ",", 
        RowBox[{"-", "1.1489125293076057`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.7`"}], ",", 
        RowBox[{"-", "1.1157956802210698`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5999999999999999`"}], ",", 
        RowBox[{"-", "1.0862780491200215`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.4999999999999999`"}], ",", 
        RowBox[{"-", "1.0606601717798212`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.3999999999999999`"}], ",", 
        RowBox[{"-", "1.0392304845413265`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.29999999999999993`"}], ",", 
        RowBox[{"-", "1.0222524150130436`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.1999999999999999`"}], ",", 
        RowBox[{"-", "1.0099504938362078`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.0999999999999999`"}], ",", 
        RowBox[{"-", "1.002496882788171`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.1102230246251565`*^-16", ",", 
        RowBox[{"-", "1.`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.10000000000000012`", ",", 
        RowBox[{"-", "1.002496882788171`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.20000000000000012`", ",", 
        RowBox[{"-", "1.0099504938362078`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.30000000000000016`", ",", 
        RowBox[{"-", "1.0222524150130436`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.40000000000000013`", ",", 
        RowBox[{"-", "1.0392304845413265`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.5000000000000001`", ",", 
        RowBox[{"-", "1.0606601717798212`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.6000000000000001`", ",", 
        RowBox[{"-", "1.0862780491200217`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.7000000000000002`", ",", 
        RowBox[{"-", "1.11579568022107`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.8000000000000002`", ",", 
        RowBox[{"-", "1.1489125293076057`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.9000000000000001`", ",", 
        RowBox[{"-", "1.1853269591129698`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.0000000000000002`", ",", 
        RowBox[{"-", "1.2247448713915892`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.1`", ",", 
        RowBox[{"-", "1.2668859459319928`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.2000000000000002`", ",", 
        RowBox[{"-", "1.3114877048604001`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.3000000000000003`", ",", 
        RowBox[{"-", "1.3583077707206126`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.4000000000000001`", ",", 
        RowBox[{"-", "1.407124727947029`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.5000000000000002`", ",", 
        RowBox[{"-", "1.4577379737113252`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.6`", ",", 
        RowBox[{"-", "1.50996688705415`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.7000000000000002`", ",", 
        RowBox[{"-", "1.5636495771111891`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.8000000000000003`", ",", 
        RowBox[{"-", "1.6186414056238647`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.9000000000000001`", ",", 
        RowBox[{"-", "1.6748134224444227`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", 
        RowBox[{"-", "1.7320508075688772`"}]}], "}"}]}], "}"}], "]"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.535879993154767*^9, 3.535880025560767*^9}, 
   3.5358801153347673`*^9, 3.535880174820767*^9, 3.535880249310767*^9, 
   3.535880500578767*^9, {3.535880729531767*^9, 3.535880747685767*^9}, 
   3.535880809167767*^9, 3.5358810055587673`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.5358800502567673`*^9, 3.535880055936767*^9}, {
  3.535880812773767*^9, 3.5358808174927673`*^9}, {3.535881053543767*^9, 
  3.5358810560147667`*^9}}],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0.6234898018587335, 1.092872255348685}, 0.05], 
   CircleBox[{-0.2225209339563144, 1.0123032070602143`}, 0.05], 
   CircleBox[{-0.9009688679024191, 1.1856949230154792`}, 0.05], 
   CircleBox[{0.6234898018587335, -1.092872255348685}, 0.05], 
   CircleBox[{-0.2225209339563144, -1.0123032070602143`}, 0.05], 
   CircleBox[{-0.9009688679024191, -1.1856949230154792`}, 0.05], 
   LineBox[{{0.6234898018587335, 
    1.092872255348685}, {-0.2225209339563144, -1.0123032070602143`}}], 
   LineBox[{{-0.2225209339563144, 1.0123032070602143`}, {
    0.6234898018587335, -1.092872255348685}}], 
   LineBox[{{0.6234898018587335, 
    1.092872255348685}, {-0.9009688679024191, -1.1856949230154792`}}], 
   LineBox[{{-0.9009688679024191, 1.1856949230154792`}, {
    0.6234898018587335, -1.092872255348685}}], 
   LineBox[{{-0.2225209339563144, 
    1.0123032070602143`}, {-0.9009688679024191, -1.1856949230154792`}}], 
   LineBox[{{-0.9009688679024191, 
    1.1856949230154792`}, {-0.2225209339563144, -1.0123032070602143`}}], 
   LineBox[{{-0.5349848118638751, 0.}, {0.1842952181248834, 0.}}], 
   CircleBox[{0.1842952181248834, 0.}, 0.05], 
   CircleBox[{-0.10768837029584591`, 0.}, 0.05], 
   CircleBox[{-0.5349848118638751, 0.}, 0.05], 
   LineBox[{{-2., 1.7320508075688772`}, {-1.9, 1.6748134224444224`}, {-1.8, 
    1.6186414056238645`}, {-1.7, 1.563649577111189}, {-1.6, 
    1.50996688705415}, {-1.5, 1.4577379737113252`}, {-1.4, 
    1.407124727947029}, {-1.3, 1.3583077707206126`}, {-1.2, 
    1.3114877048604001`}, {-1.0999999999999999`, 1.2668859459319928`}, {-1., 
    1.224744871391589}, {-0.8999999999999999, 
    1.1853269591129698`}, {-0.7999999999999999, 1.1489125293076057`}, {-0.7, 
    1.1157956802210698`}, {-0.5999999999999999, 
    1.0862780491200215`}, {-0.4999999999999999, 
    1.0606601717798212`}, {-0.3999999999999999, 
    1.0392304845413265`}, {-0.29999999999999993`, 
    1.0222524150130436`}, {-0.1999999999999999, 
    1.0099504938362078`}, {-0.0999999999999999, 1.002496882788171}, {
    1.1102230246251565`*^-16, 1.}, {0.10000000000000012`, 
    1.002496882788171}, {0.20000000000000012`, 1.0099504938362078`}, {
    0.30000000000000016`, 1.0222524150130436`}, {0.40000000000000013`, 
    1.0392304845413265`}, {0.5000000000000001, 1.0606601717798212`}, {
    0.6000000000000001, 1.0862780491200217`}, {0.7000000000000002, 
    1.11579568022107}, {0.8000000000000002, 1.1489125293076057`}, {
    0.9000000000000001, 1.1853269591129698`}, {1.0000000000000002`, 
    1.2247448713915892`}, {1.1, 1.2668859459319928`}, {1.2000000000000002`, 
    1.3114877048604001`}, {1.3000000000000003`, 1.3583077707206126`}, {
    1.4000000000000001`, 1.407124727947029}, {1.5000000000000002`, 
    1.4577379737113252`}, {1.6, 1.50996688705415}, {1.7000000000000002`, 
    1.5636495771111891`}, {1.8000000000000003`, 1.6186414056238647`}, {
    1.9000000000000001`, 1.6748134224444227`}, {2., 1.7320508075688772`}}], 
   LineBox[{{-2., -1.7320508075688772`}, {-1.9, -1.6748134224444224`}, {-1.8, \
-1.6186414056238645`}, {-1.7, -1.563649577111189}, {-1.6, -1.50996688705415}, \
{-1.5, -1.4577379737113252`}, {-1.4, -1.407124727947029}, {-1.3, \
-1.3583077707206126`}, {-1.2, -1.3114877048604001`}, {-1.0999999999999999`, \
-1.2668859459319928`}, {-1., -1.224744871391589}, {-0.8999999999999999, \
-1.1853269591129698`}, {-0.7999999999999999, -1.1489125293076057`}, {-0.7, \
-1.1157956802210698`}, {-0.5999999999999999, -1.0862780491200215`}, \
{-0.4999999999999999, -1.0606601717798212`}, {-0.3999999999999999, \
-1.0392304845413265`}, {-0.29999999999999993`, -1.0222524150130436`}, \
{-0.1999999999999999, -1.0099504938362078`}, {-0.0999999999999999, \
-1.002496882788171}, {1.1102230246251565`*^-16, -1.}, {
    0.10000000000000012`, -1.002496882788171}, {
    0.20000000000000012`, -1.0099504938362078`}, {
    0.30000000000000016`, -1.0222524150130436`}, {
    0.40000000000000013`, -1.0392304845413265`}, {
    0.5000000000000001, -1.0606601717798212`}, {
    0.6000000000000001, -1.0862780491200217`}, {
    0.7000000000000002, -1.11579568022107}, {
    0.8000000000000002, -1.1489125293076057`}, {
    0.9000000000000001, -1.1853269591129698`}, {
    1.0000000000000002`, -1.2247448713915892`}, {1.1, -1.2668859459319928`}, {
    1.2000000000000002`, -1.3114877048604001`}, {
    1.3000000000000003`, -1.3583077707206126`}, {
    1.4000000000000001`, -1.407124727947029}, {
    1.5000000000000002`, -1.4577379737113252`}, {1.6, -1.50996688705415}, {
    1.7000000000000002`, -1.5636495771111891`}, {
    1.8000000000000003`, -1.6186414056238647`}, {
    1.9000000000000001`, -1.6748134224444227`}, {
    2., -1.7320508075688772`}}]}]], "Output",
 CellChangeTimes->{3.5358810570807667`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytXQuQpcVV/pn7mpk7752ZnX3NzrLLPtiwD5asgRAeIo+AEOQdFGWzIeyG
kCywIZuQQHgoWYkhkhAiRBawDIhSlBaIWFQIRoNGDZiKATUGjKkQY5SoMcT4
GOfr06e7v3u/mVCWFHfv3L/79Dnn69OnH//p7tN37N11yeU79u7euWPm5Ct3
7Nm1e+dVMye968q5R7WDquqgXXOfI2cq/D1bVf7P7Nz/s7vxD5783/9uha/a
cU8++eTUSy+9FH6F9PMsYeTll18+5bHHHgu/miVNHTQvzMzMfPC6667rfeWV
VwLZOUa259Zbb0XaBffff3/MX/UaGbKCxJMD2U9ZGjg9t379+lv37NkDzkZS
9VsqBLz/ggsuePp1c/89/fTTgfJ0S1v/3HPPPXbKKafgg7+NpBqwVOQGFahR
SqB8o6WBD/iBL/gbSTVkqZCwS8mTWEl8x/zV8AJKnqCVNJJqdAElj7W0Lc88
80yppJFUi1jJh88888yZF154IVC+Ppd6x65du57ZsmUL+BtJNWGpZz788MOQ
6OZ9+/ZBokD5Y1mTfTfffDPSd91xxx1GUk12pwKGQPnaDF1ZqpFUU1kiIACE
wD9Qbs2WBUmBAzQxkmqppeIJdHzyuOOOSwgdls3A04CWkVTLc7ldCG1ghCAx
5DGSajojBEkhcTKgQ7IBeV0DISOpZiwVqKBM5EjYrgppDaBXpuN3tdLIV3Hh
BPBKBtiFMpJqdTfAyQSXZRMsATaS6pAMMFLcWALl4mxkABcmCICNpFrHBurw
B8pFXDWoAFSEkVQbuMqRI1EOZ3kOXHzxxV41RlJtzFUDSuRIldruxuDiAwcO
GEkVjQVPkIJqT5XaYq/g7dtIqs2WimruMoeaVWppDqAMlbrJyLfoegdJ9T+c
5k4npBlddXg3h5Tlh93k7mAiXXXEAuTf1+ShTzC6avsC5P+6ALnRVa9bgPyf
FyA3uuqoBci/vQC50VVHd5PDL4Us38xp8GVEbnTVMQtk+foCRRtddZwWEOZa
fc3SkL1LMaOrfrybHNaOFlX9taWhKLfXRG501YnZ3GFxaGJoxl8xSpSC0she
f8IoT85NDM0WzRoO4UvZF6AwFIrCLXf1xtyi4QvQNuF/vphdD8pBeSjXclen
mTBo+nA9LkxQ44+z+q4DCgaDSFed3o1CqoM/7K67hJ7RVW/iLC9NTU0hC6Sp
PpuLhqNAWira6KqzMsDQ1mF6wighJ2Dy/iEAbAOe6pycBSqR2r/brTZKBmiR
rjqP1Xa5g2q/s0Ca0VUXaA7FoC2kQToIju8g2X2WBh1dsSS1lVn9dFYM9emo
BYs3R9mC+ThcQBbfECHU6925VXilAaCgvJVdXRS+ejuzQHooiaLxbdxqyAYO
ofS7sgJd0lmx1cWc5YeNRuOB888/P8BXtyKRHQKHCr0jw+3N2KWJZVU7TG9I
8g+Tk5PeA6AlfGL37t0Bvh4r2kd/4dfHwr9NsEFxbihgA3ZvKUtv+ygw/Jr7
4Pd/9/T0vDwyMgJFgCC+g2C35VqCbQAHpIUB/yVlsWEegCLCLxOy9ZvnnHMO
SC667777YAfACM9Cs/mICQ28AC0EBvywM5R1qZVusg+BOVJcaAj57ObNm2EW
EO6PjjrqKFgg6hSQob6h+oeMCRBVyW8vmfSBLXI4I+AJlb502GGH/eWhhx4a
ar+nW2zQoK6QvneBVtHHwkBboAMdgMjlJsxOs1pQQGvM5iAyvr+8cePGv1mz
Zg1Kb1hhIHSHVsqx51U0ocb88iDdiqjelnsBAAOZkBu54oxNCoH87zDTKBtb
bNv91NrmnkBmJcRVJsSlubUjFb8SdT8LAfV80AYz2S0ajLXP5s/dc889/zQ2
Nvb8unXrnARFXm1MdxlTZ0St2SaBLRcb1v1Kb28vvvE7mMpbrcGVQuOD3x+5
4oorHjrrrLNgXmiuL65cufL8Bx54oHovsYadwsrwK4Fug95eiAH98AzCQzTX
GcZjPqV9zFNPPeVzAFQCHAua+zU33XRTsMq5XKm5E/dg4yB1wR2IMRMAya47
9EDpEBbOAcK92VoVKOCJUAE/aLVacAIwENTXZ4899lg042gVNRQRnAN+7TNh
rP6aECQYUDQWrwmbbvaCCmgBTFQEZAVXoAHAxxZol0eaj/GVDJB1FuOW434I
aP398uXLUXz0yCgO2cOv95LsQAXCOZBelUsyJZgAyKonmEodf+MZ0iD0wKto
z0dkwMHNh0luYyjO6ya2gODy4FW+sWzZsq+vWLEipM2lIB8qLNjx+0platR/
RN3Lllwtyy0c8IAt0gGnjy5dFBTfnNdJcJd8WC7WAfM5KHwj8gFn1AyKNa/Q
QiP72qpVq0o3CjDC6OwaU8x6gRaAz0tcbGVxsj4I6Vwp72adO+oDuEM6mGPy
OA0xGlhrrRPlBV871yDQQh0oyOK2B41Co7AVpAZ+e92izIDYtaUqNeouYx0l
/4FfNitve1MAcGAHU4A6MBn8Rl2hw77+2muvrXpCNdS+uHXr1uRIbRFk2CvF
y/PKcW/u6OM31IS6btmVNc0wFUdlvvnTn/50MFfSCNaCp/ZLWN363EAAPAwb
aais7w4PD//V2rVrq57QPuvfa7fbs3GhFJ9QUFUDOBAcn2oo/NvwNuYf1E3V
E1ZYUx153Xtd+VKpte66O1dgGUyH9PIxRkCiJgzF9GrT8Cp2InDlEMIbbfKe
ocZrVl1eHaVW7v38Ewo4mK0LDGBhIS3KfJnJ55qUdUHWZTLXSyvEdw8eVDX8
mZzlG3LHDvF9rB46veuJqw8+ig68BotIi8/rukdxng6r8JF0cGmRber45n55
c+pgS8DXs19CcaH3iIaHv++76KKLYBsYT+D7X4aGhk544oknnJ1ji18AMDj8
G4zdO4RN14Xmxq7p5N4lugM5Oo/pHE888SpjZuXwwr2UgLTVOfomo319N5Rp
xHMjsQO6QLlkR1AauxqK9qGJey/YFmws/LIOu17CiU8PrDuytMF0rRw1OEuC
8xDReUeTRlMChuHX67K4CdcoGvUbNxTsgzwtAesae+aesKxrGgHZCnuzhLY0
nZtIVeqXmwLdyDXZecGVWq8tx9UI3R7R8iPS7xQoNAXS5l9qNKhsCCf4WiF6
T36WRtI3EXuyD4X5qs4aIYojBEVPovh5YkVdUUtIa8vsPONoCpvaJlCqCTRZ
UwKrVxSxUoDVK6xrqxA9sk/OCb+i9u+yJDLGXgHbtDCpXvFsq6CtCTNj9qRp
r9BgWhTbK5DbMj/4hNwvEHuwSF1unyhiuWDVLwxukxA9NkaaLUT2Nhfn3qFP
aLpMtN1+YXqb5gcfIsNHBPO7mdh7J1OyJw0ie+ov2qI1vEYgVxemx+yp/+gX
RSzJGqCSgkgDIt9GIbrq/iL7K0Tj6RetwQyG+5IBIdJGwaouVPxQwT74oXaW
O3VCkSn1JYPi2QaBQ0MY3IdIZ+pU2sK47K0fdyqDwuDWzw85Gdx+Y3+lKLYt
IJ8QrIaFwa0TkDeEwTF7arEK/IlUNSMC3rXiWVMIwkypexkQkI8L/YaFmR0i
IG8KM/tFYk9FDArIx0QRo8Lg1ghNm8LgIvurBKsBAXlkT13JqLCC1fODTwZ3
C7EnoAfFs1Gh1ZiokFUZpTSVa4nymD11L0MCkWGRb5HQNLKn/qIlnkX2e0XS
oAB/WGiwSIA6Iyopsqfx34eJPWUfEqwUIuPC9KYF+L0iH7Mnix6e3xyphUwI
rabnB59Q+iVj/25Lou5lSIAf2VP3MilYLRdo9go0S/alD6NMbeEJJ0W+ZQLy
PiEc60wtdkRAHrtZ6gcmBZTLBKteUTX20qm6WhQ7LCDvE2KqDneJgLxP5GP2
BGrUnnqj3lQ1S4QuU/NDTtjcSkzJfKI3o/FaS5jjEgHvYvGsT1gGs6fGM5q9
GTQI0qoeaqkodlJAHq2FHHFk/x6haWRPHW5DFLtUgDohwFcD7Y8Se9JgTIhU
F6AuE4Y0LvL1i3zMnrqNMQF+TeRbLkxv0fzgUwX/srG3BSbZaRL4cZpPPdkK
QTsqwG8LWmZP0poGzc6VLXc+06I1jgrM1eSGuZIhR64l5iVe08LQol+gqVdb
GJq9qY8vnligGF/nUPt37KRpMDaUKxslF6862a5KbsFBTWRj/szxxx8f3NqM
QGBIyNcWlvMxUoc0Hc9GineJr/3CF77g4x2ykig3LXKq2WBkZW+5uE+Idu7L
x8FQVwnTaAvYBoWmzIoQXZSg7HAJK4VRKLMbEFB9nPiR6zfVGu7myQ0oy+gT
aEYVqR+LLO3VGi/lWgNqkj3M2rvGwh4puXd+YGmJ5Xbiqrw8NaAekW+lMKGW
wHlQeBNmryYM5DV6hOtdKcyqKTCPDYi6Z2ZPwIxkVp1vMcgclOtpCPCHhJV9
wti/XwA4LNpbQ1jNdLL+hoB8SFAwU6oNNXYv1hoAeWjhUWda7qvNDznhegex
pyJU9mIXRQfkLVrsnPsQ3MNCvcj6A/PbJnWqvQI861SbZGxzHy9rRNgYc/2R
bqBYcu3Au+5r217GiDCpTxI3GntEbrRC3ifgNR3rsKmPX3bZZQ7piBA2crN3
6HLRSa2DURHLsyGgUwo1UrS9NJr6FWJFHrad2sCAAC8y8FD/YDFqbMAMCJEo
N70TU5PKuI3CYxjOffDBB2Elyioit+ssibx9rBPV+xNy1mhC8CK4edFev0Oi
Au4kruTFVTc1JOCcSmDn1zxDojxmRQ1GTW+HBZyT2b6hQTCD4oVWesk+IMzl
LmKvXv2QZx8V+I5n2oRv7AHI9bSFMUX29vpfdo3k2UcF0OMJ3oZwTm1hU8yU
GLSE3GMC8jEBeVO07j5hXJ8i9uTZi/XDVA3jAvIRAXlLGGafMLjI/nphXArA
onYT5CMJ8uIFWTKzwm6Smf0qMVVhASTjhIBtSEDeJ6qrJcyM2as3xOTtJ4Xz
LFxmgrxf4NUSPjCyv0Ek1YSmizOrFLA2kCAfEGbWECZ6NzElXWri2ZQQpFhv
SJCrSU9kT+MhZq/CHwiHJUKkootPkBeLxsng6uKZ2VEMIWh2Rt65BSwTSOc1
sWFhXTVhXcyrc8bvSC0XADcFwMPCqBRizLVzpOXteoXAtS5wjVMn4jD38Xq7
t2QWdqn828DAwOW33XbbWQ899BDixOLgq8+x3Pzss892BsImKcx9Nvfecsst
iP7zPIilhAHdW9pOCkn9x/Hx8d87+eSTISMi7oLbimPct951112IuivDVhHy
jKj6yC2Ug/hDhNjdeckllyCkH0Opkx5//PHq3tJD9JWxot4/AF38nTzmcs6L
Ih1igABWf7J9+/aQd6S7XG8tMCXQpnLvKUXpL4ffwBCae99Qrk8t4+ylSTvs
Zfbh7tK9rt0GyuwH5u+z4n6Fr2zYsAH7GDzkD8i//fbbb18adGrBTBAJ78lI
QthsqKAY+Okk4degPSvpYr4mzA3IupG6EiykCCNufnX16tXfWbRokUdVoiRw
XRp8U+vPDz/8cITUefJTxxxzzH80m00ELsfYzpqThF+D9qyki/masMYnTjjh
BBfSq5uFFJtamt+emJgIHCOlj11s1NwVqInaff+NN96YHFhBEjtNGdwJFmgi
XcGdB6gplO6s00KSV1/OeUvo/e+Ud6S7XHeRjlHKS02BAi/dpvF9944dO1Lg
Zdxojbx/sWnTpr+bnp6GqHE8/BvnnXceHuVhDBfrvSokAHkq9h5ySeXemb89
+OCDPaQ59DHmknrRPfzZtm3bysDwx0866ST4hbx1PhT1+yeeeGKZDbZz9Oc+
97mK3G7aLuG17L2aWUqjc99VyNaTGwMQDZUdfb33a50RnsyUOvq5j49Dizik
ZHnN1HWOiC5ZTUnuIV601DCbF+6Wi06sGCqnTix2nSRy7DqpVz5QVqbyZjwC
XyocSq/oueMIlUZmanzH7FWAmIr6IaT7E9JqRSaOx2jSw+MxFZdFgkwJyIsX
MAnyOBykMVJkT2Oku8uWzPDWhStcLGAr1p8T5P3Cppq5vDT/YPY0WIrS0kRo
QkA+lCDP4PcK4+K5BiUpYCIrWqofEkDHqQ6NZFsCJWZPCybFNpG0YBKndzQ+
HxFAtwRyfcLMeHJLxaqZ0VjWNM0uxxK8ajbeJzBkpmSzrVRYfNVC8+iCfQK6
iBtPXqFfmBQzpUav6mVUIDIugK4ngQeEBfFyDU1k+4QgwwLeycSgLkxKLUeW
THMD6IByWDybFPD2CEMaFIbE62LUM/QJlzck4I1rKgTvbN6qEElo6TtyvXZ+
G1Dha4Tv0gTTq1i2Z34kiopGHBAgx8VUB/mTl156adEDU1ZeuqU+QL3dbgtM
Y1eM2R1GxitffPHFSq2vR1YfEDqrZch+AeSKbCkYcIcefVRYCi/lqwA7FUIi
XlfUHZGO1xRULcyNGuegcE29AsP4cqT0w+U7mWGBGXMlrx65kldvCThtWNq1
VbTjJQnBwu+gSIdhURHNeZHl13410abVaz9mTz3kcGpkTSGcCq6oZZfZ+fKL
lODXfsqbkozFWkpCWr3ojfnUawMyr8j+GsFqVIikRrdFcGIyiKaAXL3mLtkH
eMdEnfYI/xt1VkN09XqXKpPfLpOMcZJEtTtrCyGdL7bJxHoF3CpqPLJ+n4As
rlGRv5/NG7RnhI31zY8yPeOoCRE2lPZ0OsYq3LZPwBu5kRtnbmSVkRs4Ye3N
IZ3JJafhRVsgquJVI7cYV0NOvoir+X5fX98ld955pwe7kD0MCMhUjBCH8KgQ
diiaVo9mhJ0MCgxVnAuzouYWMXSTvHr//v2ozRkh1dD8GJKyMfhpn4DXFEs7
X91iZ4R9qG0KqptnbiKGp0ktfTYvuE0LOxnJTakzdI4UYa5qVE6NPL9EnRaW
MCpaUlvk48g58qQqWLJHWEKx7pGsaJFAX8VqRvbvEUkqWrEuxFT7rxbNDzlV
fhmrWTp3ArohYFPBz+MC8n4hHAeIUlergoPVm6ylAi8Vl65ikyP7qzNEnXtK
CPJiVSlZ6lKByKSAXIXHcmwygVUEbyTw1XrClBBpSpRXdAepMTJ7AksFw6sg
/inhMVS0tgpWiNHo786apr5AbQUo6i8NSKaEHS8R4KvAcGZPSSoWPzYZ6iCL
0IpkessE+MWrymR6zF7tsqFnbVHspDCp5QJotfckboTYK8xH7bIptkKlGeuE
oF0hwFcbIZi9mqsT+Cpsd1yY3gKbfwkR3nlD3Yva5JMX9yaEICsFA7XXipmq
LYvKCFXgOxlcEbfaudWLDC6yj1u9aAlH7bVS84kxYUirBOSRPQ33y51mZbgT
Aa028hVRPandrxaQq50bvL2Nuhe1tVHF8qjBw+qMV9raqDb989ZGkkztLYwW
TfN3FfW2Rlh+1J4mHMyeFh4GBPiRPXUvalK7Vmiq9tIye7VvgcCfEBqoZcO1
Any1sTNua407ial7UXtpi9XIZGZqTW69AF8tnTN7tXJG4C8WoKpQ7w3zg0/P
eB+12tT2I/txte66QYCvNjJH9nsEgMVLmQT+kvwsdS9qorVRiFmssSTTY/bU
vfQLsOIYTs2FyPReI2jVqQl8bgAVoQ5tiEMGmvj1C+QOE+CrjfvMnhbw1ZEV
aodVvzC9TfODT+9g+MgK6mjUmRFxyKACI8n0NgtadV5IyT50NAryaVFrvULg
LfNDTrjyKSH0Eksd0RKHDNTRqNH9ViF6LSkWNX2nMAF1MsqMkFu9Dd0maNUJ
OHwsDXUvKjp3ldCvKWi3CbzUwSx8LI0aClARBwtTaQozO0KIrt5K8elH9Hpa
DQUOFu25IQxuu9BUHfTE50ypoQA9WyOKrYsK2Z6R43OmgsGxzuqtPkF+yHzW
22FwMdqx8zwtN7bI9R0CQXWcRXHuROe2GrIzO8Wr63Qr14rPDlMBFKTXOmGG
PcK8IlcCeDafqcVc1d5cQjiextYZheMWdbQG1g2JT2Mj81IH3EVm655//nnk
7QzLFGfaJbkip8uEwc9/yFwK7fz3/v5+FEshmW/oBrKM8+BT9FR8M/wlKAsg
KQLTaboiMMVpeqkpMFsVyy1OjaQ4SwdHxVka567l/8j07Vmv1A/MfzyiDNPE
arhHpeKDiMhP7dy5M7T+eE6lH6iJTzUU/m2UZ1H6SaiVveWul6c9gqcNN+jI
xdT3f5A0IbPuydqlaa41uhBUHM5N3r9/P07F9ZNM/WxW2E8MvKwjqvS3zj77
bD+TMh5TWYZ/+0GneFYeUxkMyJQaKA/m7DxhtPMwThhYvMjGbcY1Y32V86Bn
1okMwETQXvxoWwjgpwU/ctppp+FvP+IUjked7We9cdPjNDtPTQ3HsVd1r0uv
w9FsgH7FCMC3MAw/oVdErbIB2uCrvzwo2KsKlg834GcPow7UW0y1h9TmJm0/
ehVFezV59XQeaxxH+S03RkRgIlqWzmd+f6ldixzVbMcxvTaR6APKrrE6ILgM
2aJT32u5t0mxpVuya1LnGUMWVHbwHzbsa33ghhtuQAQ+mnPXMc3XlOo0qROf
zTsDbD7aiz+dI7SApD6fgRY2QaeI165jjrdnBaAkWieU8+ouz+yO5pL88KOn
nnoqAp59YoDyUouI50LH08JpXDCbD7kez32JH9Dt1eGW4JPvcmtDvFilXdIB
ckgMOsScIA0SfXPJkiW3XX755dJH8Znm5RCyzBYHjn6ee8nN8al+1qoEXD98
1VVXIcDGNXnw3HPPxUtTFKVuaNhXCtEoW1JCcyjj1HmMfaqdt2RMvP8GLfL7
qdGeX5/pnjbfeu20s/24b0QlonQ/xT/eAMBupdaNF06Vx9kP0CzYnb1U8rP7
3VWIpenAHmR+lLwLH5q/OtO6nlsHdgGgVv1+CvCASBDBlnrjQfwt76aQ+usX
XnihtyvbtmD20SkJSkXp73yVzsKeNVGkXwZTCmTLQdVOHl95p4V+EttofvuM
M87wOwrmE+jKV9HwWwsLYzpFoxqmA9hnLeYJww9cOAGMvRP0+0H8vpjgvPaJ
Btzu5g4lUK+oictK7oOdseVo8tgJAOpTH330Uaj+rcWLF5clxNXlRqdEQdJ4
feGO+cdaGIlgWwxgg+L4fdojjzzyUQYeiPl1QdDvbWXB1BT97pX/rNfrt+zd
u9fRSE0x3tMCQ/E78UALLtBnZ1lyONcE9yV4ewguSI0kLEgm7C+A9m4kAU0r
K3qu4KLBzIe3nz/yyCOxo0e91f2kJoHtABkrsfqZ3F14HSfesxYItGBzsSjd
hqS3sqsLLQsA9G7UhYhwLNwIDnQr4iLhmd1SUZ1vXKZeyncFAfRgSv3CuH/N
8qMS/G6sdEGQlVWdy/VCWR5ZgJ3RVWdn44bepaFUj5sTdExcHyOpYuA8cvog
Ec0mFP4ZlhuAQ4CAptFVZ2TZ4CG9Uwly/0FOgy5IS/eUGV31k7lKXe1039jn
s2R+TxnUDtVtdNWpubcorw4Lav9pVttvGwM8RlLFqIzyLrJwTZA97izQcld2
U2fX1Wdf7lYiXX1mt6VVtnUsbLZEEl2f9byllVdrAYNgj0ZXHZ/J/TqodGHc
VxdIM7rq2O4sCeUXu1FO5EbnU2hJ/o0FyI3Oz3yX5N9agNzo4hqMJv/OAuRG
F49F1+TfXYDc6OIB45r8ewuQG11cHtXkP1iA3OjiinLI4i0/kf9XN3lKM7q4
CE9Z/PpUu5b3oJyhFC9YrhHH9wjJ5umOyka3dsnw4xWXr8ntzK/KS9dq2pyq
61pNI6kOzZRwWXTL6mCm9BaHdm4kfqOE75OjS0DjnBgllZeSGkl8W9l1uWig
jIsC5aWk4GAkcck2SeSnrgTKJdmp+H2x4GAkcZmg7nuqHYVAuSJjgBL9alEj
ia8IyDrwbXMqpFmGdL+o1709jq810r2ldF3v6u6iU83GG2mjbH75K7ROhrEu
6+TTE9SPkcQ3aAFJoOiXvwbKjd31A9yMJL55TCh7aqDczKU6ykYSJ40a5W0a
ZSPxu4kBIlId4UC5XafFW43HGSG6GPZIlsftxUj8lpvyGuqE0BsyQm6jsEMj
iREIXddQB8rjc7sor682En97T9dQB7ITc0daOoh4RfVgVtL9Q7Kiky2tdC8o
xUjikL/rru1AeVqu6PL6aiOJizFayTdpJY3E37R1K3m2VtImRf6OCE/TNbiB
zIZfNdcwLJpFmpD+/3Cnevl3ddD/AtlAMSU=\
\>"]]
}, Open  ]]
},
WindowSize->{919, 891},
WindowMargins->{{66, Automatic}, {Automatic, 29}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) \
(2008\:5e742\:67087\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 7255, 181, 458, "Input"],
Cell[7848, 206, 4374, 81, 472, "Output"]
}, Open  ]],
Cell[12237, 290, 87, 1, 52, "Input"],
Cell[CellGroupData[{
Cell[12349, 295, 226, 4, 31, "Input"],
Cell[12578, 301, 14385, 410, 426, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27000, 716, 231, 4, 31, "Input"],
Cell[27234, 722, 15085, 249, 328, 4698, 77, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
