library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_textio.all;
use IEEE.std_logic_arith.all;
use STD.textio.all;
--use work.CALC_pack.all;

entity USE_FPU is

end USE_FPU;

architecture Behavior of USE_FPU is
	component FMUL
  port (
    R1      : in  std_logic_vector(31 downto 0);
    R2      : in  std_logic_vector(31 downto 0);
    R3      : out std_logic_vector(31 downto 0)
  );

	end component;

  file In_F:TEXT  is in  "./in.txt";
  file Out_F:TEXT is out "./out.txt";

  signal R1 : std_logic_vector(31 downto 0);
  signal R2 : std_logic_vector(31 downto 0);
  signal R3 : std_logic_vector(31 downto 0);
 
  signal CLK : std_logic;

begin
  R1 <= "11000000110000000000000000000000";
  R2 <= "01000000111000000000000000000000";
	P : process

	variable Li,Lo : line;

	begin -- process P

    wait for 1 ns;
    CLK <= '0';
    wait for 1 ns;
    CLK <= '1';

		wait until CLK = '1';

  end process P;
  FPU : FMUL port map (R1, R2, R3);
end Behavior;

configuration CNFG_USE of USE_FPU is
  for Behavior
		for FPU : FMUL use entity work.FMUL(Behavior);
    end for;
  end for;
end CNFG_USE;

