library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

--library UNISIM;
--use UNISIM.VComponents.all;

-- Assume that R1 >= R2 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

entity FMUL is
	port (
		R1      : in  std_logic_vector(31 downto 0);
		R2      : in  std_logic_vector(31 downto 0);
		R3      : out std_logic_vector(31 downto 0)
	);
end FMUL;

architecture Behavior of fmul is
	-- local variables for calculating !
	signal R1N, R2N : std_logic_vector(23 downto 0);
	signal M : std_logic_vector(47 downto 0);
	signal S, S2 : std_logic_vector(8 downto 0);
	signal E1, E2 : std_logic;
	--signal R3N : std_logic_vector(24 downto 0);
begin  -- Behavior

	R3(31) <= R1(31) xor R2(31); -- sign
	--if R2(30 downto 23) = "00000000" then  -- If R2 is zero
	--				R3(30 downto 0) <= (others => '0');
	--				CEND <= '1';
	--			elsif R1(30 downto 23) = "11111111" then
	--				R3(30 downto 0) <= R1(30 downto 0);
	--				CEND <= '1';
	--			else ..
	-- normal mul :
	S <= ("0" & R1(30 downto 23)) + ("0" & R2(30 downto 23)); -- '0': for overflow ?!

	R1N <= "1" & R1(22 downto 0);  -- '1': real value of Mantissa part: 1011 -> 1.1011
	R2N <= "1" & R2(22 downto 0);

  M <= R1N * R2N;

	S2 <= S - 126 when M(47) = '1' -- reduce the Exponent part to Normal Form ! (-126 <= . <= 127)
	else S - 127;

	E1 <= M(25) and (M(24) or M(26) or M(27)); -- E1, E2: for nearest rounding. G and (ulp or R or S)
	E2 <= M(26) and (M(25) or M(27) or M(28));

  R3(30 downto 23) <= "00000000" when (S <= 127 or R2(30 downto 23) = "00000000" or R1(30 downto 23) = "00000000") -- underflow
								 else "11111111" when (S >= 382 or R1(30 downto 23) = "11111111" or R2(30 downto 23) = "11111111") -- overflow
								 else S2(7 downto 0);


	R3(22 downto 0) <= (others => '0') when (S <= 127 or S >= 382 or R2(30 downto 23) = "00000000" or R1(30 downto 23) = "00000000")
								else R1(22 downto 0) when R1(30 downto 23) = "11111111"
								else R2(22 downto 0) when R2(30 downto 23) = "11111111"
								else M(46 downto 24) + E1 when M(47) = '1' -- overflowed ! M[23..0] will be thrown away !
								else M(47 downto 25) + E2;

end Behavior;
