library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

--library UNISIM;
--use UNISIM.VComponents.all;

-- Exponent path /= 2
entity FHEXP is
	port (
		R1      : in  std_logic_vector(31 downto 0);
		R3      : out std_logic_vector(31 downto 0)
	);
end FHEXP;

architecture Behavior of FHEXP is
signal E, E1, E2  : std_logic_vector(7 downto 0);
begin  -- Behavior

	E <= R1(30 downto 23) - 127;
	E1 <= E(7) & E(7 downto 1);
	E2 <= E1 + 127;

	R3(31) <= R1(31);

  R3(30 downto 23) <= R1(30 downto 23) when (R1(30 downto 23) = "00000000" or R1(30 downto 23) = "11111111")
  else E2;

	R3(22 downto 0) <= R1(22 downto 0);

end architecture Behavior;
